/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.config;

import com.baidu.hugegraph.config.ConfigListOption;
import com.baidu.hugegraph.config.TypedOption;
import com.baidu.hugegraph.util.E;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class ConfigListConvOption<T, R>
extends TypedOption<List<T>, List<R>> {
    private final Class<T> elemClass;
    private final Function<T, R> converter;

    public ConfigListConvOption(String name, String desc, Predicate<List<T>> pred, Function<T, R> convert, T value) {
        this(name, desc, pred, convert, value.getClass(), value);
    }

    public ConfigListConvOption(String name, String desc, Predicate<List<T>> pred, Function<T, R> convert, Class<T> clazz, T ... values) {
        this(name, false, desc, pred, convert, clazz, Arrays.asList(values));
    }

    public ConfigListConvOption(String name, boolean required, String desc, Predicate<List<T>> pred, Function<T, R> convert, Class<T> clazz, List<T> values) {
        super(name, required, desc, pred, values.getClass(), values);
        E.checkArgumentNotNull(clazz, "Element class can't be null", new Object[0]);
        this.elemClass = clazz;
        this.converter = convert;
    }

    @Override
    public List<R> convert(Object value) {
        List results = ConfigListOption.convert(value, part -> super.convert(part, this.elemClass));
        ArrayList<R> enums = new ArrayList<R>(results.size());
        for (Object elem : results) {
            enums.add(this.converter.apply(elem));
        }
        return enums;
    }
}

