/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.config;

import com.baidu.hugegraph.config.ConfigException;
import com.baidu.hugegraph.config.ConfigOption;
import com.baidu.hugegraph.util.E;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class ConfigListOption<T>
extends ConfigOption<List<T>> {
    private final Class<T> elemClass;

    public ConfigListOption(String name, String desc, Predicate<List<T>> pred, T value) {
        this(name, desc, pred, value.getClass(), value);
    }

    public ConfigListOption(String name, String desc, Predicate<List<T>> pred, Class<T> clazz, T ... values) {
        this(name, false, desc, pred, clazz, Arrays.asList(values));
    }

    public ConfigListOption(String name, boolean required, String desc, Predicate<List<T>> pred, Class<T> clazz, List<T> values) {
        super(name, required, desc, pred, values.getClass(), values);
        E.checkArgumentNotNull(clazz, "Element class can't be null", new Object[0]);
        this.elemClass = clazz;
    }

    @Override
    public List<T> convert(Object value) {
        return ConfigListOption.convert(value, part -> super.convert(part, this.elemClass));
    }

    public static <T> List<T> convert(Object value, Function<String, ?> conv) {
        if (value instanceof List) {
            return (List)value;
        }
        String str = (String)value;
        if (!str.startsWith("[") || !str.endsWith("]")) {
            throw new ConfigException("The list type config option expected to be wrapped in [], actual '%s'", str);
        }
        str = str.substring(1, str.length() - 1);
        String[] parts = str.split(",");
        ArrayList results = new ArrayList(parts.length);
        for (String part : parts) {
            results.add(conv.apply(part.trim()));
        }
        return results;
    }
}

