/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.config;

import com.baidu.hugegraph.config.ConfigException;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.config.TypedOption;
import com.baidu.hugegraph.util.Log;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class OptionHolder {
    private static final Logger LOG = Log.logger(HugeConfig.class);
    protected Map<String, TypedOption<?, ?>> options = new HashMap();

    protected void registerOptions() {
        for (Field field : this.getClass().getFields()) {
            try {
                TypedOption option = (TypedOption)field.get(this);
                this.options.putIfAbsent(option.name(), option);
            }
            catch (Exception e) {
                LOG.error("Failed to register option: {}", (Object)field, (Object)e);
                throw new ConfigException("Failed to register option: %s", field);
            }
        }
    }

    public Map<String, TypedOption<?, ?>> options() {
        return Collections.unmodifiableMap(this.options);
    }
}

