/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.config;

import com.baidu.hugegraph.config.ConfigException;
import com.baidu.hugegraph.config.OptionHolder;
import com.baidu.hugegraph.config.TypedOption;
import com.baidu.hugegraph.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public final class OptionSpace {
    private static final Logger LOG = Log.logger(OptionSpace.class);
    private static final Map<String, Class<? extends OptionHolder>> holders = new ConcurrentHashMap<String, Class<? extends OptionHolder>>();
    private static final Map<String, TypedOption<?, ?>> options = new ConcurrentHashMap();
    private static final String INSTANCE_METHOD = "instance";

    public static void register(String module, String holder) {
        Class<?> clazz;
        ClassLoader classLoader = OptionSpace.class.getClassLoader();
        try {
            clazz = classLoader.loadClass(holder);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException("Failed to load class of option holder '%s'", (Throwable)e, holder);
        }
        if (!OptionHolder.class.isAssignableFrom(clazz)) {
            throw new ConfigException("Class '%s' is not a subclass of OptionHolder", holder);
        }
        OptionHolder instance = null;
        ReflectiveOperationException exception = null;
        try {
            Method method = clazz.getMethod(INSTANCE_METHOD, new Class[0]);
            instance = (OptionHolder)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Class {} does not has static method {}.", (Object)holder, (Object)INSTANCE_METHOD);
            exception = e;
        }
        catch (InvocationTargetException e) {
            LOG.warn("Can't call static method {} from class {}.", (Object)INSTANCE_METHOD, (Object)holder);
            exception = e;
        }
        catch (IllegalAccessException e) {
            LOG.warn("Illegal access while calling method {} from class {}.", (Object)INSTANCE_METHOD, (Object)holder);
            exception = e;
        }
        if (exception != null) {
            throw new ConfigException("Failed to instantiate option holder: %s", (Throwable)exception, holder);
        }
        OptionSpace.register(module, instance);
    }

    public static void register(String module, OptionHolder holder) {
        if (holders.containsKey(module)) {
            LOG.warn("Already registered option holder: {} ({})", (Object)module, holders.get(module));
        }
        holders.put(module, holder.getClass());
        options.putAll(holder.options());
        LOG.debug("Registered options for OptionHolder: {}", (Object)holder.getClass().getSimpleName());
    }

    public static Set<String> keys() {
        return options.keySet();
    }

    public static Boolean containKey(String key) {
        return options.containsKey(key);
    }

    public static TypedOption<?, ?> get(String key) {
        return options.get(key);
    }
}

