/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.config;

import com.baidu.hugegraph.config.ConfigException;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.PropertyConverter;
import org.slf4j.Logger;

public class TypedOption<T, R> {
    private static final Logger LOG = Log.logger(TypedOption.class);
    private static final Set<Class<?>> ACCEPTED_DATA_TYPES = ImmutableSet.of(Boolean.class, Short.class, Integer.class, Byte.class, Long.class, Float.class, (Object[])new Class[]{Double.class, String.class, String[].class, List.class});
    private static final String ACCEPTED_DATA_TYPES_STRING = Joiner.on((String)", ").join(ACCEPTED_DATA_TYPES);
    private final String name;
    private final String desc;
    private final boolean required;
    private final Class<T> dataType;
    private final T defaultValue;
    private final Predicate<T> checkFunc;

    public TypedOption(String name, boolean required, String desc, Predicate<T> pred, Class<T> type, T value) {
        E.checkNotNull(name, "name");
        E.checkNotNull(type, "dataType");
        this.name = name;
        this.dataType = this.checkAndAssignDataType(type);
        this.defaultValue = value;
        this.required = required;
        this.desc = desc;
        this.checkFunc = pred;
        this.check(this.defaultValue);
    }

    private Class<?> checkAndAssignDataType(Class<T> dataType) {
        for (Class<T> clazz : ACCEPTED_DATA_TYPES) {
            if (!clazz.isAssignableFrom(dataType)) continue;
            return clazz;
        }
        String msg = String.format("Input data type '%s' doesn't belong to acceptable type set: [%s]", dataType, ACCEPTED_DATA_TYPES_STRING);
        throw new IllegalArgumentException(msg);
    }

    public String name() {
        return this.name;
    }

    public Class<T> dataType() {
        return this.dataType;
    }

    public String desc() {
        return this.desc;
    }

    public boolean required() {
        return this.required;
    }

    public R defaultValue() {
        return this.convert(this.defaultValue);
    }

    public R convert(Object value) {
        return (R)this.convert(value, this.dataType);
    }

    public Object convert(Object value, Class<?> dataType) {
        if (dataType.equals(String.class)) {
            return value;
        }
        String methodTo = "to" + dataType.getSimpleName();
        try {
            Method method = PropertyConverter.class.getMethod(methodTo, Object.class);
            return method.invoke(null, value);
        }
        catch (ReflectiveOperationException e) {
            LOG.error("Invalid type of value '{}' for option '{}'", new Object[]{value, this.name, e});
            throw new ConfigException("Invalid type of value '%s' for option '%s', expect '%s' type", value, this.name, dataType.getSimpleName());
        }
    }

    public void check(Object value) {
        E.checkNotNull(value, "value", this.name);
        E.checkArgument(this.dataType.isInstance(value), "Invalid type of value '%s' for option '%s'", value, this.name);
        if (this.checkFunc != null) {
            Object result = value;
            E.checkArgument(this.checkFunc.apply(result), "Invalid option value for '%s': %s", this.name, value);
        }
    }

    public String toString() {
        return String.format("[%s]%s=%s", this.dataType.getSimpleName(), this.name, this.defaultValue);
    }
}

