/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.iterator;

import com.baidu.hugegraph.iterator.FlatMapperIterator;
import com.baidu.hugegraph.util.E;
import java.util.Iterator;
import java.util.function.Function;

public class FlatMapperFilterIterator<T, R>
extends FlatMapperIterator<T, R> {
    private final Function<R, Boolean> filterCallback;

    public FlatMapperFilterIterator(Iterator<T> origin, Function<T, Iterator<R>> mapper, Function<R, Boolean> filter) {
        super(origin, mapper);
        this.filterCallback = filter;
    }

    @Override
    protected final boolean fetchMapped() {
        E.checkNotNull(this.results, "mapper results");
        while (this.results.hasNext()) {
            Object result = this.results.next();
            if (result == null || !this.filterCallback.apply(result).booleanValue()) continue;
            assert (this.current == FlatMapperFilterIterator.none());
            this.current = result;
            return true;
        }
        this.results = null;
        return false;
    }
}

