/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.iterator;

import com.baidu.hugegraph.iterator.WrappedIterator;
import java.util.Iterator;
import java.util.function.Function;

public class MapperIterator<T, R>
extends WrappedIterator<R> {
    private final Iterator<T> originIterator;
    private final Function<T, R> mapperCallback;

    public MapperIterator(Iterator<T> origin, Function<T, R> mapper) {
        this.originIterator = origin;
        this.mapperCallback = mapper;
    }

    @Override
    protected Iterator<?> originIterator() {
        return this.originIterator;
    }

    @Override
    protected final boolean fetch() {
        while (this.originIterator.hasNext()) {
            T next = this.originIterator.next();
            R result = this.mapperCallback.apply(next);
            if (result == null) continue;
            assert (this.current == MapperIterator.none());
            this.current = result;
            return true;
        }
        return false;
    }
}

