/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.license;

import com.baidu.hugegraph.util.Log;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.xml.GenericCertificate;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;

public class CommonLicenseManager
extends LicenseManager {
    private static final Logger LOG = Log.logger(CommonLicenseManager.class);
    private static final String CHARSET = "UTF-8";
    private static final int BUF_SIZE = 8192;

    public CommonLicenseManager(LicenseParam param) {
        super(param);
    }

    protected synchronized byte[] create(LicenseContent content, LicenseNotary notary) throws Exception {
        super.initialize(content);
        this.validateCreate(content);
        GenericCertificate certificate = notary.sign((Object)content);
        return super.getPrivacyGuard().cert2key(certificate);
    }

    protected synchronized LicenseContent install(byte[] key, LicenseNotary notary) throws Exception {
        GenericCertificate certificate = super.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        String encodedText = certificate.getEncoded();
        LicenseContent content = (LicenseContent)this.load(encodedText);
        this.validate(content);
        super.setLicenseKey(key);
        super.setCertificate(certificate);
        return content;
    }

    protected synchronized LicenseContent verify(LicenseNotary notary) throws Exception {
        byte[] key = super.getLicenseKey();
        if (key == null) {
            String subject = super.getLicenseParam().getSubject();
            throw new NoLicenseInstalledException(subject);
        }
        GenericCertificate certificate = super.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        String encodedText = certificate.getEncoded();
        LicenseContent content = (LicenseContent)this.load(encodedText);
        this.validate(content);
        super.setCertificate(certificate);
        return content;
    }

    protected synchronized void validate(LicenseContent content) throws LicenseContentException {
        super.validate(content);
    }

    protected synchronized void validateCreate(LicenseContent content) throws LicenseContentException {
        super.validate(content);
    }

    private Object load(String text) throws Exception {
        ByteArrayInputStream bis = null;
        XMLDecoder decoder = null;
        try {
            bis = new ByteArrayInputStream(text.getBytes(CHARSET));
            decoder = new XMLDecoder(new BufferedInputStream(bis, 8192));
            Object object = decoder.readObject();
            return object;
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseContentException(String.format("Unsupported charset: %s", CHARSET));
        }
        finally {
            if (decoder != null) {
                decoder.close();
            }
            try {
                if (bis != null) {
                    ((InputStream)bis).close();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to close stream", (Throwable)e);
            }
        }
    }
}

