/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.perf;

import com.baidu.hugegraph.func.TriFunction;
import com.baidu.hugegraph.perf.Stopwatch;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import com.baidu.hugegraph.util.ReflectionUtil;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.slf4j.Logger;

public class PerfUtil {
    private static final Logger LOG = Log.logger(PerfUtil.class);
    private static final ThreadLocal<PerfUtil> INSTANCE = new ThreadLocal();
    private final Map<String, Stopwatch> stopwatches = new HashMap<String, Stopwatch>();
    private final Stack<String> callStack = new Stack();

    private PerfUtil() {
    }

    public static PerfUtil instance() {
        PerfUtil p = INSTANCE.get();
        if (p == null) {
            p = new PerfUtil();
            INSTANCE.set(p);
        }
        return p;
    }

    private static long now() {
        return System.nanoTime();
    }

    public boolean start(String name) {
        String parent = this.callStack.empty() ? "" : this.callStack.peek();
        Stopwatch item = this.stopwatches.get(Stopwatch.id(parent, name));
        if (item == null) {
            item = new Stopwatch(name, parent);
            this.stopwatches.put(item.id(), item);
        }
        this.callStack.push(item.id());
        item.startTime(PerfUtil.now());
        return true;
    }

    public boolean end(String name) {
        long time = PerfUtil.now();
        String current = this.callStack.pop();
        assert (current.endsWith(name));
        String parent = this.callStack.empty() ? "" : this.callStack.peek();
        Stopwatch item = this.stopwatches.get(Stopwatch.id(parent, name));
        if (item == null) {
            throw new InvalidParameterException(name);
        }
        item.endTime(time);
        return true;
    }

    public void clear() {
        E.checkState(this.callStack.empty(), "Can't be cleared when the call has not ended yet", new Object[0]);
        this.stopwatches.clear();
    }

    public void profilePackage(String ... packages) throws NotFoundException, IOException, ClassNotFoundException, CannotCompileException {
        HashSet<String> loadedClasses = new HashSet<String>();
        Iterator<ClassPath.ClassInfo> classes = ReflectionUtil.classes(packages);
        while (classes.hasNext()) {
            String cls = classes.next().getName();
            for (String s : ReflectionUtil.superClasses(cls)) {
                if (loadedClasses.contains(s)) continue;
                this.profileClass(s);
                loadedClasses.add(s);
            }
            if (loadedClasses.contains(cls)) continue;
            this.profileClass(cls);
            loadedClasses.add(cls);
        }
    }

    public void profileClass(String ... classes) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        ClassPool classPool = ClassPool.getDefault();
        for (String cls : classes) {
            CtClass ctClass = classPool.get(cls);
            List<CtMethod> methods = ReflectionUtil.getMethodsAnnotatedWith(ctClass, Watched.class, false);
            for (CtMethod method : methods) {
                this.profile(method);
            }
            if (methods.isEmpty()) continue;
            ctClass.toClass();
        }
    }

    private void profile(CtMethod ctMethod) throws CannotCompileException, ClassNotFoundException {
        String START = "com.baidu.hugegraph.perf.PerfUtil.instance().start(\"%s\");";
        String END = "com.baidu.hugegraph.perf.PerfUtil.instance().end(\"%s\");";
        Watched annotation = (Watched)ctMethod.getAnnotation(Watched.class);
        String name = annotation.value();
        if (name.isEmpty()) {
            name = ctMethod.getName();
        }
        if (!annotation.prefix().isEmpty()) {
            name = annotation.prefix() + "." + name;
        }
        ctMethod.insertBefore(String.format("com.baidu.hugegraph.perf.PerfUtil.instance().start(\"%s\");", name));
        ctMethod.insertAfter(String.format("com.baidu.hugegraph.perf.PerfUtil.instance().end(\"%s\");", name), true);
        LOG.debug("Profiled for: '{}' [{}]", (Object)name, (Object)ctMethod.getLongName());
    }

    public String toString() {
        return this.stopwatches.toString();
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder(8 + this.stopwatches.size() * 96);
        sb.append('{');
        for (Map.Entry<String, Stopwatch> w : this.stopwatches.entrySet()) {
            sb.append('\"');
            sb.append(w.getKey());
            sb.append('\"');
            sb.append(':');
            sb.append(w.getValue().toJson());
            sb.append(',');
        }
        if (!this.stopwatches.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }

    public String toECharts() {
        TriFunction<Integer, Integer, List, String> formatLevel = (totalDepth, depth, items) -> {
            float factor = 100.0f / (float)(totalDepth + 1);
            float showFactor = 1.0f + (float)(totalDepth - depth) / (float)depth.intValue();
            float radiusFrom = (float)depth.intValue() * factor;
            float radiusTo = (float)depth.intValue() * factor + factor;
            if (depth == 1) {
                radiusFrom = 0.0f;
            }
            StringBuilder sb = new StringBuilder(8 + items.size() * 128);
            sb.append('{');
            sb.append("name: 'Total Cost',");
            sb.append("type: 'pie',");
            sb.append(String.format("radius: ['%s%%', '%s%%'],", Float.valueOf(radiusFrom), Float.valueOf(radiusTo)));
            sb.append(String.format("label: {normal: {position: 'inner', formatter:function(params) {  if (params.percent > %s) return params.data.name;  else return '';}}},", Float.valueOf(showFactor)));
            sb.append("data: [");
            items.sort((i, j) -> i.id().compareTo(j.id()));
            for (Stopwatch w : items) {
                sb.append('{');
                sb.append("value:");
                sb.append((double)w.totalCost() / 1000000.0);
                sb.append(',');
                sb.append("min:");
                sb.append(w.minCost());
                sb.append(',');
                sb.append("max:");
                sb.append(w.maxCost());
                sb.append(',');
                sb.append("id:'");
                sb.append(w.id());
                sb.append("',");
                sb.append("name:'");
                sb.append(w.name());
                sb.append("',");
                sb.append("times:");
                sb.append(w.times());
                sb.append('}');
                sb.append(',');
            }
            if (!items.isEmpty()) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]}");
            return sb.toString();
        };
        BiConsumer<List, List> fillOther = (itemsOfI, parents) -> {
            for (Stopwatch parent : parents) {
                Stream<Stopwatch> children = itemsOfI.stream().filter(c -> c.parent().equals(parent.id()));
                long sum = children.mapToLong(c -> c.totalCost()).sum();
                if (sum >= parent.totalCost()) continue;
                Stopwatch other = new Stopwatch("~", parent.id());
                other.totalCost(parent.totalCost() - sum);
                itemsOfI.add(other);
            }
        };
        Map<String, Stopwatch> items2 = this.stopwatches;
        HashMap levelItems = new HashMap();
        int maxDepth = 1;
        for (Map.Entry<String, Stopwatch> e : items2.entrySet()) {
            int depth2 = e.getKey().split("/").length;
            levelItems.putIfAbsent(depth2, new LinkedList());
            ((List)levelItems.get(depth2)).add(e.getValue().copy());
            if (depth2 <= maxDepth) continue;
            maxDepth = depth2;
        }
        StringBuilder sb = new StringBuilder(8 + items2.size() * 128);
        sb.append("{");
        sb.append("tooltip: {trigger: 'item', formatter: function(params) {    return params.data.name + ' ' + params.percent + '% <br/>'        + 'cost: ' + params.data.value + ' (ms) <br/>'        + 'min: ' + params.data.min + ' (ns) <br/>'        + 'max: ' + params.data.max + ' (ns) <br/>'        + 'times: ' + params.data.times + '<br/>'       + params.data.id + '<br/>';}");
        sb.append("},");
        sb.append("series: [");
        int i = 1;
        while (levelItems.containsKey(i)) {
            List itemsOfI2 = (List)levelItems.get(i);
            if (i > 1) {
                fillOther.accept(itemsOfI2, (List)levelItems.get(i - 1));
            }
            sb.append(formatLevel.apply(maxDepth, i, itemsOfI2));
            sb.append(',');
            ++i;
        }
        if (!items2.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]}");
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Watched {
        public String value() default "";

        public String prefix() default "";
    }
}

