/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.rest;

import com.baidu.hugegraph.rest.ClientException;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.util.ExecutorUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.uri.UriComponent;

public abstract class RestClient {
    private static long TTL = 24L;
    private static long IDLE_TIME = 40L;
    private static long CHECK_PERIOD = IDLE_TIME / 2L;
    private final Client client;
    private final WebTarget target;
    private PoolingHttpClientConnectionManager pool;
    private ScheduledExecutorService cleanExecutor;

    public RestClient(String url, int timeout) {
        this(url, new ConfigBuilder().config(timeout).build());
    }

    public RestClient(String url, String user, String password, int timeout) {
        this(url, new ConfigBuilder().config(timeout).config(user, password).build());
    }

    public RestClient(String url, int timeout, int maxTotal, int maxPerRoute) {
        this(url, new ConfigBuilder().config(timeout).config(maxTotal, maxPerRoute).build());
    }

    public RestClient(String url, String user, String password, int timeout, int maxTotal, int maxPerRoute) {
        this(url, new ConfigBuilder().config(timeout).config(user, password).config(maxTotal, maxPerRoute).build());
    }

    public RestClient(String url, ClientConfig config) {
        this.client = ClientBuilder.newClient((Configuration)config);
        this.client.register(GZipEncoder.class);
        this.target = this.client.target(url);
        this.pool = (PoolingHttpClientConnectionManager)config.getProperty("jersey.config.apache.client.connectionManager");
        if (this.pool != null) {
            this.cleanExecutor = ExecutorUtil.newScheduledThreadPool("conn-clean-worker-%d");
            this.cleanExecutor.scheduleWithFixedDelay(() -> {
                PoolStats stats = this.pool.getTotalStats();
                int using = stats.getLeased() + stats.getPending();
                if (using > 0) {
                    return;
                }
                this.pool.closeIdleConnections(IDLE_TIME, TimeUnit.SECONDS);
                this.pool.closeExpiredConnections();
            }, CHECK_PERIOD, CHECK_PERIOD, TimeUnit.SECONDS);
        }
    }

    public void close() {
        if (this.pool != null) {
            this.pool.close();
            this.cleanExecutor.shutdownNow();
        }
        this.client.close();
    }

    protected Response request(Callable<Response> method) {
        try {
            return method.call();
        }
        catch (Exception e) {
            throw new ClientException("Failed to do request", e);
        }
    }

    public RestResult post(String path, Object object) {
        return this.post(path, object, null, null);
    }

    public RestResult post(String path, Object object, MultivaluedMap<String, Object> headers) {
        return this.post(path, object, headers, null);
    }

    public RestResult post(String path, Object object, Map<String, Object> params) {
        return this.post(path, object, null, params);
    }

    public RestResult post(String path, Object object, MultivaluedMap<String, Object> headers, Map<String, Object> params) {
        Pair<Invocation.Builder, Entity<?>> pair = this.buildRequest(path, null, object, headers, params);
        Response response = this.request(() -> ((Invocation.Builder)pair.getLeft()).post((Entity)pair.getRight()));
        this.checkStatus(response, Response.Status.CREATED, Response.Status.OK, Response.Status.ACCEPTED);
        return new RestResult(response);
    }

    public RestResult put(String path, String id, Object object) {
        return this.put(path, id, object, (Map<String, Object>)ImmutableMap.of());
    }

    public RestResult put(String path, String id, Object object, MultivaluedMap<String, Object> headers) {
        return this.put(path, id, object, headers, null);
    }

    public RestResult put(String path, String id, Object object, Map<String, Object> params) {
        return this.put(path, id, object, null, params);
    }

    public RestResult put(String path, String id, Object object, MultivaluedMap<String, Object> headers, Map<String, Object> params) {
        Pair<Invocation.Builder, Entity<?>> pair = this.buildRequest(path, id, object, headers, params);
        Response response = this.request(() -> ((Invocation.Builder)pair.getLeft()).put((Entity)pair.getRight()));
        this.checkStatus(response, Response.Status.OK, Response.Status.ACCEPTED);
        return new RestResult(response);
    }

    public RestResult get(String path) {
        Response response = this.request(() -> this.target.path(path).request().get());
        this.checkStatus(response, Response.Status.OK);
        return new RestResult(response);
    }

    public RestResult get(String path, Map<String, Object> params) {
        Ref target = Refs.of((Object)this.target);
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof Collection) {
                for (Object i : (Collection)value) {
                    target.set((Object)((WebTarget)target.get()).queryParam(key, new Object[]{i}));
                }
                continue;
            }
            target.set((Object)((WebTarget)target.get()).queryParam(key, new Object[]{value}));
        }
        Response response = this.request(() -> ((WebTarget)target.get()).path(path).request().get());
        this.checkStatus(response, Response.Status.OK);
        return new RestResult(response);
    }

    public RestResult get(String path, String id) {
        Response response = this.request(() -> this.target.path(path).path(RestClient.encode(id)).request().get());
        this.checkStatus(response, Response.Status.OK);
        return new RestResult(response);
    }

    public RestResult delete(String path, Map<String, Object> params) {
        Ref target = Refs.of((Object)this.target);
        for (String key : params.keySet()) {
            target.set((Object)((WebTarget)target.get()).queryParam(key, new Object[]{params.get(key)}));
        }
        Response response = this.request(() -> ((WebTarget)target.get()).path(path).request().delete());
        this.checkStatus(response, Response.Status.NO_CONTENT, Response.Status.ACCEPTED);
        return new RestResult(response);
    }

    public RestResult delete(String path, String id) {
        Response response = this.request(() -> this.target.path(path).path(RestClient.encode(id)).request().delete());
        this.checkStatus(response, Response.Status.NO_CONTENT, Response.Status.ACCEPTED);
        return new RestResult(response);
    }

    private Pair<Invocation.Builder, Entity<?>> buildRequest(String path, String id, Object object, MultivaluedMap<String, Object> headers, Map<String, Object> params) {
        Entity entity;
        WebTarget target = this.target;
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> param : params.entrySet()) {
                target = target.queryParam(param.getKey(), new Object[]{param.getValue()});
            }
        }
        Invocation.Builder builder = id == null ? target.path(path).request() : target.path(path).path(RestClient.encode(id)).request();
        String encoding = null;
        if (headers != null && !headers.isEmpty()) {
            builder = builder.headers(headers);
            encoding = (String)headers.getFirst((Object)"Content-Encoding");
        }
        if (encoding == null) {
            entity = Entity.json((Object)object);
        } else {
            Variant variant = new Variant(MediaType.APPLICATION_JSON_TYPE, (String)null, encoding);
            entity = Entity.entity((Object)object, (Variant)variant);
        }
        return Pair.of((Object)builder, (Object)entity);
    }

    private static String encode(String raw) {
        return UriComponent.encode((String)raw, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT);
    }

    protected abstract void checkStatus(Response var1, Response.Status ... var2);

    private static class ConfigBuilder {
        private final ClientConfig config = new ClientConfig();

        public ConfigBuilder config(int timeout) {
            this.config.property("jersey.config.client.connectTimeout", (Object)timeout);
            this.config.property("jersey.config.client.readTimeout", (Object)timeout);
            return this;
        }

        public ConfigBuilder config(String username, String password) {
            this.config.register((Object)HttpAuthenticationFeature.basic((String)username, (String)password));
            return this;
        }

        public ConfigBuilder config(int maxTotal, int maxPerRoute) {
            PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager(TTL, TimeUnit.HOURS);
            pool.setMaxTotal(maxTotal);
            pool.setDefaultMaxPerRoute(maxPerRoute);
            this.config.property("jersey.config.apache.client.connectionManager", (Object)pool);
            this.config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            return this;
        }

        public ClientConfig build() {
            return this.config;
        }
    }
}

