/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.rest;

import com.baidu.hugegraph.rest.SerializeException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class RestResult {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final int status;
    private final MultivaluedMap<String, Object> headers;
    private final String content;

    public RestResult(Response response) {
        this.status = response.getStatus();
        this.headers = response.getHeaders();
        this.content = (String)response.readEntity(String.class);
    }

    public int status() {
        return this.status;
    }

    public MultivaluedMap<String, Object> headers() {
        return this.headers;
    }

    public String content() {
        return this.content;
    }

    public <T> T readObject(Class<T> clazz) {
        try {
            return (T)mapper.readValue(this.content, clazz);
        }
        catch (Exception e) {
            throw new SerializeException("Failed to deserialize: %s", (Throwable)e, this.content);
        }
    }

    public <T> List<T> readList(String key, Class<T> clazz) {
        try {
            JsonNode root = mapper.readTree(this.content);
            JsonNode element = root.get(key);
            if (element == null) {
                throw new SerializeException("Can't find value of the key: %s in json.", key);
            }
            JavaType type = mapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, new Class[]{clazz});
            return (List)mapper.convertValue((Object)element, type);
        }
        catch (IOException e) {
            throw new SerializeException("Failed to deserialize %s", (Throwable)e, this.content);
        }
    }

    public <T> List<T> readList(Class<T> clazz) {
        JavaType type = mapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, new Class[]{clazz});
        try {
            return (List)mapper.readValue(this.content, type);
        }
        catch (IOException e) {
            throw new SerializeException("Failed to deserialize %s", (Throwable)e, this.content);
        }
    }

    public String toString() {
        return String.format("{status=%s, headers=%s, content=%s}", this.status, this.headers, this.content);
    }

    public static void registerModule(Module module) {
        mapper.registerModule(module);
    }
}

