/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public final class CollectionUtil {
    public static <T> Set<T> toSet(Object object) {
        E.checkNotNull(object, "object");
        Set set = InsertionOrderUtil.newSet();
        CollectionUtil.fillCollection(set, object);
        return set;
    }

    public static <T> List<T> toList(Object object) {
        E.checkNotNull(object, "object");
        ArrayList list = new ArrayList();
        CollectionUtil.fillCollection(list, object);
        return list;
    }

    private static <T> void fillCollection(Collection<T> collection, Object object) {
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                collection.add(Array.get(object, i));
            }
        } else if (object instanceof Collection) {
            collection.addAll((Collection)object);
        } else {
            collection.add(object);
        }
    }

    public static <T> boolean prefixOf(List<T> prefix, List<T> all) {
        E.checkNotNull(prefix, "prefix");
        E.checkNotNull(all, "all");
        if (prefix.size() > all.size()) {
            return false;
        }
        for (int i = 0; i < prefix.size(); ++i) {
            T second;
            T first = prefix.get(i);
            if (first == (second = all.get(i)) || first != null && first.equals(second)) continue;
            return false;
        }
        return true;
    }

    public static Set<Integer> randomSet(int min, int max, int count) {
        E.checkArgument(max > min, "Invalid min/max: %s/%s", min, max);
        E.checkArgument(0 < count && count <= max - min, "Invalid count %s", count);
        HashSet<Integer> randoms = new HashSet<Integer>();
        while (randoms.size() < count) {
            randoms.add(ThreadLocalRandom.current().nextInt(min, max));
        }
        return randoms;
    }

    public static boolean allUnique(Collection<?> collection) {
        return collection.stream().allMatch(new HashSet()::add);
    }

    public static <T> Set<T> subSet(Set<T> original, int from, int to) {
        ArrayList<T> list = new ArrayList<T>(original);
        if (to == -1) {
            to = original.size();
        }
        return new LinkedHashSet(list.subList(from, to));
    }

    public static <T> Set<T> union(Collection<T> first, Collection<T> second) {
        E.checkNotNull(first, "first");
        E.checkNotNull(second, "second");
        HashSet<T> results = new HashSet<T>(first);
        results.addAll(second);
        return results;
    }

    public static <T> Collection<T> intersect(Collection<T> first, Collection<T> second) {
        HashSet clone;
        E.checkNotNull(first, "first");
        E.checkNotNull(second, "second");
        HashSet results = null;
        results = first instanceof HashSet ? (clone = (HashSet)((HashSet)first).clone()) : new HashSet(first);
        results.retainAll(second);
        return results;
    }

    public static <T> Collection<T> intersectWithModify(Collection<T> first, Collection<T> second) {
        E.checkNotNull(first, "first");
        E.checkNotNull(second, "second");
        first.retainAll(second);
        return first;
    }

    public static <T> boolean hasIntersection(List<T> first, Set<T> second) {
        E.checkNotNull(first, "first");
        E.checkNotNull(second, "second");
        for (T firstElem : first) {
            if (!second.contains(firstElem)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean hasIntersection(Set<T> first, Set<T> second) {
        E.checkNotNull(first, "first");
        E.checkNotNull(second, "second");
        if (first.size() <= second.size()) {
            for (T firstElem : first) {
                if (!second.contains(firstElem)) continue;
                return true;
            }
        } else {
            for (T secondElem : second) {
                if (!first.contains(secondElem)) continue;
                return true;
            }
        }
        return false;
    }

    public static <K extends Comparable<? super K>, V> Map<K, V> sortByKey(Map<K, V> map, boolean incr) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        if (incr) {
            list.sort(Map.Entry.comparingByKey());
        } else {
            list.sort(Collections.reverseOrder(Map.Entry.comparingByKey()));
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, boolean incr) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        if (incr) {
            list.sort(Map.Entry.comparingByValue());
        } else {
            list.sort(Collections.reverseOrder(Map.Entry.comparingByValue()));
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

