/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.NumericUtil;

public final class LongEncoding {
    private static final String BASE_SYMBOLS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz~";
    private static final String LENGTH_SYMBOLS = "0123456789ABCDEF";
    private static final char NEG = "0123456789ABCDEF".charAt(0);
    private static final long FULL_LONG = Long.MIN_VALUE;

    public static String encodeNumber(Object number) {
        Number num = NumericUtil.convertToNumber(number);
        long value = NumericUtil.numberToSortableLong(num);
        return LongEncoding.encodeSortable(value);
    }

    public static Number decodeNumber(String str, Class<?> clazz) {
        long value = LongEncoding.decodeSortable(str);
        Number number = NumericUtil.sortableLongToNumber(value, clazz);
        return number;
    }

    public static String encodeSortable(long num) {
        String encoded;
        int length;
        boolean negative = false;
        if (num < 0L) {
            negative = true;
            num += Long.MIN_VALUE;
        }
        E.checkArgument((length = (encoded = LongEncoding.encode(num, BASE_SYMBOLS)).length()) <= LENGTH_SYMBOLS.length(), "Length symbols can't represent encoded number '%s'", encoded);
        StringBuilder sb = new StringBuilder(length + 2);
        if (negative) {
            sb.append(NEG);
        }
        char len = LENGTH_SYMBOLS.charAt(length);
        sb.append(len);
        sb.append(encoded);
        return sb.toString();
    }

    public static long decodeSortable(String str) {
        int length;
        E.checkArgument(str.length() >= 2, "Length of sortable encoded string must be >=2", new Object[0]);
        boolean negative = str.charAt(0) == NEG;
        int lengthPos = 0;
        if (negative) {
            lengthPos = 1;
        }
        E.checkArgument((length = BASE_SYMBOLS.indexOf(str.charAt(lengthPos))) == str.length() - lengthPos - 1, "Can't decode illegal string '%s' with wrong length", str);
        String encoded = str.substring(lengthPos + 1);
        long value = LongEncoding.decode(encoded);
        if (negative) {
            value -= Long.MIN_VALUE;
        }
        return value;
    }

    public static boolean validSortableChar(char c) {
        return BASE_SYMBOLS.indexOf(c) != -1;
    }

    public static String encode(long num) {
        return LongEncoding.encode(num, BASE_SYMBOLS);
    }

    public static long decode(String str) {
        return LongEncoding.decode(str, BASE_SYMBOLS);
    }

    public static long decode(String str, String symbols) {
        int B = symbols.length();
        E.checkArgument(B > 0, "The symbols parameter can't be empty", new Object[0]);
        long num = 0L;
        for (char ch : str.toCharArray()) {
            num *= (long)B;
            int pos = symbols.indexOf(ch);
            if (pos < 0) {
                throw new NumberFormatException("Symbol set does not match string");
            }
            num += (long)pos;
        }
        return num;
    }

    public static String encode(long num, String symbols) {
        int B = symbols.length();
        E.checkArgument(num >= 0L, "Expected non-negative number: %s", num);
        E.checkArgument(B > 0, "The symbols parameter can't be empty", new Object[0]);
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(symbols.charAt((int)(num % (long)B)));
        } while ((num /= (long)B) != 0L);
        return sb.reverse().toString();
    }
}

