/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.util.E;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class HugeFactory {
    private static final Map<String, HugeGraph> graphs = new HashMap<String, HugeGraph>();

    public static synchronized HugeGraph open(Configuration config) {
        HugeConfig conf = new HugeConfig(config);
        String name = (String)conf.get(CoreOptions.STORE);
        HugeGraph graph = graphs.get(name);
        if (graph == null || graph.closed()) {
            graph = new HugeGraph(conf);
            graphs.put(name, graph);
        } else {
            String backend = (String)conf.get(CoreOptions.BACKEND);
            E.checkState((boolean)backend.equals(graph.backend()), (String)"Graph name '%s' has been used by backend '%s'", (Object[])new Object[]{name, graph.backend()});
        }
        return graph;
    }

    public static HugeGraph open(String path) {
        return HugeFactory.open((Configuration)HugeFactory.getLocalConfig(path));
    }

    public static HugeGraph open(URL url) {
        return HugeFactory.open((Configuration)HugeFactory.getRemoteConfig(url));
    }

    private static PropertiesConfiguration getLocalConfig(String path) {
        File file = new File(path);
        E.checkArgument((file.exists() && file.isFile() && file.canRead() ? 1 : 0) != 0, (String)"Please specify a proper config file rather than: %s", (Object[])new Object[]{file.toString()});
        try {
            return new PropertiesConfiguration(file);
        }
        catch (ConfigurationException e) {
            throw new HugeException("Unable to load config file: %s", (Throwable)e, path);
        }
    }

    private static PropertiesConfiguration getRemoteConfig(URL url) {
        try {
            return new PropertiesConfiguration(url);
        }
        catch (ConfigurationException e) {
            throw new HugeException("Unable to load remote config file: %s", (Throwable)e, url);
        }
    }
}

