/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph;

import com.baidu.hugegraph.GremlinGraph;
import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.analyzer.Analyzer;
import com.baidu.hugegraph.analyzer.AnalyzerFactory;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.cache.CachedGraphTransaction;
import com.baidu.hugegraph.backend.cache.CachedSchemaTransaction;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.serializer.AbstractSerializer;
import com.baidu.hugegraph.backend.serializer.SerializerFactory;
import com.baidu.hugegraph.backend.store.BackendProviderFactory;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.store.BackendStoreInfo;
import com.baidu.hugegraph.backend.store.BackendStoreProvider;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.event.EventHub;
import com.baidu.hugegraph.io.HugeGraphIoRegistry;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaManager;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeFeatures;
import com.baidu.hugegraph.task.TaskManager;
import com.baidu.hugegraph.task.TaskScheduler;
import com.baidu.hugegraph.traversal.optimize.HugeGraphStepStrategy;
import com.baidu.hugegraph.traversal.optimize.HugeVertexStepStrategy;
import com.baidu.hugegraph.type.define.GraphMode;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.LockUtil;
import com.baidu.hugegraph.util.Log;
import com.baidu.hugegraph.variables.HugeVariables;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.util.AbstractThreadLocalTransaction;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;

public class HugeGraph
implements GremlinGraph {
    private static final Logger LOG = Log.logger(HugeGraph.class);
    private volatile boolean closed;
    private volatile GraphMode mode;
    private final String name;
    private final HugeConfig configuration;
    private final EventHub schemaEventHub;
    private final EventHub indexEventHub;
    private final RateLimiter rateLimiter;
    private final TaskManager taskManager;
    private final HugeFeatures features;
    private final BackendStoreProvider storeProvider;
    private final TinkerpopTransaction tx;
    private HugeVariables variables;

    public HugeGraph(HugeConfig configuration) {
        this.configuration = configuration;
        this.schemaEventHub = new EventHub("schema");
        this.indexEventHub = new EventHub("index");
        int limit = (Integer)configuration.get(CoreOptions.RATE_LIMIT);
        this.rateLimiter = limit > 0 ? RateLimiter.create((double)limit) : null;
        this.taskManager = TaskManager.instance();
        this.features = new HugeFeatures(this, true);
        this.name = (String)configuration.get(CoreOptions.STORE);
        this.closed = false;
        this.mode = GraphMode.NONE;
        LockUtil.init(this.name);
        try {
            this.storeProvider = this.loadStoreProvider();
        }
        catch (BackendException e) {
            String message = "Failed to init backend store";
            LOG.error("{}: {}", (Object)message, (Object)e.getMessage());
            throw new HugeException(message);
        }
        this.tx = new TinkerpopTransaction(this);
        this.taskManager.addScheduler(this);
        this.variables = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String backend() {
        return this.storeProvider.type();
    }

    public String backendVersion() {
        return this.storeProvider.version();
    }

    public boolean closed() {
        if (this.closed && !this.tx.closed()) {
            LOG.warn("The tx is not closed while graph '{}' is closed", (Object)this);
        }
        return this.closed;
    }

    public GraphMode mode() {
        return this.mode;
    }

    public void mode(GraphMode mode) {
        this.mode = mode;
    }

    public EventHub schemaEventHub() {
        return this.schemaEventHub;
    }

    public EventHub indexEventHub() {
        return this.indexEventHub;
    }

    public RateLimiter rateLimiter() {
        return this.rateLimiter;
    }

    @Override
    public void initBackend() {
        this.loadSchemaStore().open(this.configuration);
        this.loadSystemStore().open(this.configuration);
        this.loadGraphStore().open(this.configuration);
        try {
            this.storeProvider.init();
            this.initBackendStoreInfo();
        }
        finally {
            this.loadGraphStore().close();
            this.loadSystemStore().close();
            this.loadSchemaStore().close();
        }
    }

    @Override
    public void clearBackend() {
        this.waitUntilAllTasksCompleted();
        this.loadSchemaStore().open(this.configuration);
        this.loadSystemStore().open(this.configuration);
        this.loadGraphStore().open(this.configuration);
        try {
            this.storeProvider.clear();
        }
        finally {
            this.loadGraphStore().close();
            this.loadSystemStore().close();
            this.loadSchemaStore().close();
        }
    }

    @Override
    public void truncateBackend() {
        this.waitUntilAllTasksCompleted();
        this.storeProvider.truncate();
        this.initBackendStoreInfo();
    }

    private void waitUntilAllTasksCompleted() {
        long timeout = (Long)this.configuration.get(CoreOptions.TASK_WAIT_TIMEOUT);
        try {
            this.taskScheduler().waitUntilAllTasksCompleted(timeout);
        }
        catch (TimeoutException e) {
            throw new HugeException("Failed to wait all tasks to complete", e);
        }
    }

    private void initBackendStoreInfo() {
        new BackendStoreInfo(this).init();
    }

    private SchemaTransaction openSchemaTransaction() throws HugeException {
        this.checkGraphNotClosed();
        try {
            return new CachedSchemaTransaction(this, this.loadSchemaStore());
        }
        catch (BackendException e) {
            String message = "Failed to open schema transaction";
            LOG.error("{}", (Object)message, (Object)e);
            throw new HugeException(message);
        }
    }

    private GraphTransaction openGraphTransaction() throws HugeException {
        this.checkGraphNotClosed();
        try {
            return new CachedGraphTransaction(this, this.loadGraphStore());
        }
        catch (BackendException e) {
            String message = "Failed to open graph transaction";
            LOG.error("{}", (Object)message, (Object)e);
            throw new HugeException(message);
        }
    }

    private BackendStoreProvider loadStoreProvider() {
        String backend = (String)this.configuration.get(CoreOptions.BACKEND);
        LOG.info("Opening backend store '{}' for graph '{}'", (Object)backend, (Object)this.name);
        return BackendProviderFactory.open(backend, this.name);
    }

    private void checkGraphNotClosed() {
        E.checkState((!this.closed ? 1 : 0) != 0, (String)"Graph '%s' has been closed", (Object[])new Object[]{this});
    }

    public BackendStore loadSchemaStore() {
        String name = (String)this.configuration.get(CoreOptions.STORE_SCHEMA);
        return this.storeProvider.loadSchemaStore(name);
    }

    public BackendStore loadGraphStore() {
        String graph = (String)this.configuration.get(CoreOptions.STORE_GRAPH);
        return this.storeProvider.loadGraphStore(graph);
    }

    public BackendStore loadSystemStore() {
        String name = (String)this.configuration.get(CoreOptions.STORE_SYSTEM);
        return this.storeProvider.loadSystemStore(name);
    }

    public SchemaTransaction schemaTransaction() {
        this.checkGraphNotClosed();
        return this.tx.schemaTransaction();
    }

    public GraphTransaction graphTransaction() {
        this.checkGraphNotClosed();
        this.tx.readWrite();
        return this.tx.graphTransaction();
    }

    @Override
    public SchemaManager schema() {
        return new SchemaManager(this.schemaTransaction());
    }

    public GraphTransaction openTransaction() {
        return this.openGraphTransaction();
    }

    public AbstractSerializer serializer() {
        String name = (String)this.configuration.get(CoreOptions.SERIALIZER);
        LOG.debug("Loading serializer '{}' for graph '{}'", (Object)name, (Object)this.name);
        AbstractSerializer serializer = SerializerFactory.serializer(name);
        if (serializer == null) {
            throw new HugeException("Can't load serializer with name " + name);
        }
        return serializer;
    }

    public Analyzer analyzer() {
        String name = (String)this.configuration.get(CoreOptions.TEXT_ANALYZER);
        String mode = (String)this.configuration.get(CoreOptions.TEXT_ANALYZER_MODE);
        LOG.debug("Loading text analyzer '{}' with mode '{}' for graph '{}'", new Object[]{name, mode, this.name});
        return AnalyzerFactory.analyzer(name, mode);
    }

    public TaskScheduler taskScheduler() {
        TaskScheduler scheduler = this.taskManager.getScheduler(this);
        E.checkState((scheduler != null ? 1 : 0) != 0, (String)"Can't find task scheduler for graph '%s'", (Object[])new Object[]{this});
        return scheduler;
    }

    public Vertex addVertex(Object ... keyValues) {
        return this.graphTransaction().addVertex(keyValues);
    }

    public <C extends GraphComputer> C compute(Class<C> clazz) throws IllegalArgumentException {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    public GraphComputer compute() throws IllegalArgumentException {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    public <I extends Io> I io(Io.Builder<I> builder) {
        return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)HugeGraphIoRegistry.instance())).create();
    }

    public Iterator<Vertex> vertices(Object ... objects) {
        if (objects.length == 0) {
            return this.graphTransaction().queryVertices();
        }
        return this.graphTransaction().queryVertices(objects);
    }

    public Iterator<Vertex> vertices(Query query) {
        return this.graphTransaction().queryVertices(query);
    }

    public Iterator<Vertex> adjacentVertices(Iterator<Edge> edges) {
        return this.graphTransaction().queryAdjacentVertices(edges);
    }

    public Iterator<Edge> edges(Object ... objects) {
        if (objects.length == 0) {
            return this.graphTransaction().queryEdges();
        }
        return this.graphTransaction().queryEdges(objects);
    }

    public Iterator<Edge> edges(Query query) {
        return this.graphTransaction().queryEdges(query);
    }

    public PropertyKey propertyKey(Id id) {
        PropertyKey pk = this.schemaTransaction().getPropertyKey(id);
        E.checkArgument((pk != null ? 1 : 0) != 0, (String)"Undefined property key id: '%s'", (Object[])new Object[]{id});
        return pk;
    }

    public PropertyKey propertyKey(String name) {
        PropertyKey pk = this.schemaTransaction().getPropertyKey(name);
        E.checkArgument((pk != null ? 1 : 0) != 0, (String)"Undefined property key: '%s'", (Object[])new Object[]{name});
        return pk;
    }

    public VertexLabel vertexLabel(Id id) {
        VertexLabel vl = this.schemaTransaction().getVertexLabel(id);
        E.checkArgument((vl != null ? 1 : 0) != 0, (String)"Undefined vertex label id: '%s'", (Object[])new Object[]{id});
        return vl;
    }

    public VertexLabel vertexLabel(String name) {
        VertexLabel vl = this.schemaTransaction().getVertexLabel(name);
        E.checkArgument((vl != null ? 1 : 0) != 0, (String)"Undefined vertex label: '%s'", (Object[])new Object[]{name});
        return vl;
    }

    public EdgeLabel edgeLabel(Id id) {
        EdgeLabel el = this.schemaTransaction().getEdgeLabel(id);
        E.checkArgument((el != null ? 1 : 0) != 0, (String)"Undefined edge label id: '%s'", (Object[])new Object[]{id});
        return el;
    }

    public EdgeLabel edgeLabel(String name) {
        EdgeLabel el = this.schemaTransaction().getEdgeLabel(name);
        E.checkArgument((el != null ? 1 : 0) != 0, (String)"Undefined edge label: '%s'", (Object[])new Object[]{name});
        return el;
    }

    public IndexLabel indexLabel(Id id) {
        IndexLabel il = this.schemaTransaction().getIndexLabel(id);
        E.checkArgument((il != null ? 1 : 0) != 0, (String)"Undefined index label id: '%s'", (Object[])new Object[]{id});
        return il;
    }

    public IndexLabel indexLabel(String name) {
        IndexLabel il = this.schemaTransaction().getIndexLabel(name);
        E.checkArgument((il != null ? 1 : 0) != 0, (String)"Undefined index label: '%s'", (Object[])new Object[]{name});
        return il;
    }

    public Transaction tx() {
        return this.tx;
    }

    public void close() throws HugeException {
        this.taskManager.closeScheduler(this);
        try {
            this.closeTx();
        }
        finally {
            this.closed = true;
            this.storeProvider.close();
            LockUtil.destroy(this.name);
        }
        E.checkState((boolean)this.tx.closed(), (String)"Ensure tx closed in all threads when closing graph", (Object[])new Object[0]);
    }

    public void closeTx() {
        try {
            if (this.tx.isOpen()) {
                this.tx.close();
            }
        }
        finally {
            this.tx.destroyTransaction();
        }
    }

    public HugeFeatures features() {
        return this.features;
    }

    public synchronized Graph.Variables variables() {
        if (this.variables == null) {
            this.variables = new HugeVariables(this);
        }
        this.variables.initSchema();
        return this.variables;
    }

    public HugeConfig configuration() {
        return this.configuration;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.name());
    }

    public List<String> mapPkId2Name(Collection<Id> ids) {
        ArrayList<String> names = new ArrayList<String>(ids.size());
        for (Id id : ids) {
            PropertyKey schema = this.propertyKey(id);
            names.add(schema.name());
        }
        return names;
    }

    public List<String> mapVlId2Name(Collection<Id> ids) {
        ArrayList<String> names = new ArrayList<String>(ids.size());
        for (Id id : ids) {
            VertexLabel schema = this.vertexLabel(id);
            names.add(schema.name());
        }
        return names;
    }

    public List<String> mapElId2Name(Collection<Id> ids) {
        ArrayList<String> names = new ArrayList<String>(ids.size());
        for (Id id : ids) {
            EdgeLabel schema = this.edgeLabel(id);
            names.add(schema.name());
        }
        return names;
    }

    public List<String> mapIlId2Name(Collection<Id> ids) {
        ArrayList<String> names = new ArrayList<String>(ids.size());
        for (Id id : ids) {
            IndexLabel schema = this.indexLabel(id);
            names.add(schema.name());
        }
        return names;
    }

    public List<Id> mapPkName2Id(Collection<String> pkeys) {
        ArrayList<Id> ids = new ArrayList<Id>(pkeys.size());
        for (String pkey : pkeys) {
            PropertyKey propertyKey = this.propertyKey(pkey);
            ids.add(propertyKey.id());
        }
        return ids;
    }

    public Id[] mapElName2Id(String[] edgeLabels) {
        Id[] ids = new Id[edgeLabels.length];
        for (int i = 0; i < edgeLabels.length; ++i) {
            EdgeLabel edgeLabel = this.edgeLabel(edgeLabels[i]);
            ids[i] = edgeLabel.id();
        }
        return ids;
    }

    public Id[] mapVlName2Id(String[] vertexLabels) {
        Id[] ids = new Id[vertexLabels.length];
        for (int i = 0; i < vertexLabels.length; ++i) {
            VertexLabel vertexLabel = this.vertexLabel(vertexLabels[i]);
            ids[i] = vertexLabel.id();
        }
        return ids;
    }

    public static void shutdown(long timout) throws InterruptedException {
        EventHub.destroy((long)timout);
        TaskManager.instance().shutdown(timout);
    }

    static {
        TraversalStrategies strategies = null;
        strategies = TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone();
        strategies.addStrategies(new TraversalStrategy[]{HugeVertexStepStrategy.instance(), HugeGraphStepStrategy.instance()});
        TraversalStrategies.GlobalCache.registerStrategies(HugeGraph.class, (TraversalStrategies)strategies);
    }

    private class TinkerpopTransaction
    extends AbstractThreadLocalTransaction {
        private AtomicInteger refs;
        private ThreadLocal<Boolean> opened;
        private ThreadLocal<GraphTransaction> graphTransaction;
        private ThreadLocal<SchemaTransaction> schemaTransaction;

        public TinkerpopTransaction(Graph graph) {
            super(graph);
            this.refs = new AtomicInteger(0);
            this.opened = ThreadLocal.withInitial(() -> false);
            this.graphTransaction = ThreadLocal.withInitial(() -> null);
            this.schemaTransaction = ThreadLocal.withInitial(() -> null);
        }

        public boolean closed() {
            assert (this.refs.get() >= 0) : this.refs.get();
            return this.refs.get() == 0;
        }

        public void commitIfGtSize(int size) {
            this.graphTransaction().commitIfGtSize(size);
        }

        public void commit() {
            try {
                super.commit();
            }
            finally {
                this.setClosed();
            }
        }

        public void rollback() {
            try {
                super.rollback();
            }
            finally {
                this.setClosed();
            }
        }

        public <G extends Graph> G createThreadedTx() {
            throw Transaction.Exceptions.threadedTransactionsNotSupported();
        }

        public boolean isOpen() {
            return this.opened.get();
        }

        protected void doOpen() {
            this.schemaTransaction();
            this.graphTransaction();
            this.setOpened();
        }

        protected void doCommit() {
            this.verifyOpened();
            this.schemaTransaction().commit();
            this.graphTransaction().commit();
        }

        protected void doRollback() {
            this.verifyOpened();
            try {
                this.graphTransaction().rollback();
            }
            finally {
                this.schemaTransaction().rollback();
            }
        }

        protected void doClose() {
            this.verifyOpened();
            try {
                super.doClose();
            }
            finally {
                this.resetState();
            }
        }

        public String toString() {
            return String.format("TinkerpopTransaction{opened=%s, graphTx=%s, schemaTx=%s}", this.opened.get(), this.graphTransaction.get(), this.schemaTransaction.get());
        }

        private void verifyOpened() {
            if (!this.isOpen()) {
                throw new HugeException("Transaction has not been opened");
            }
        }

        private void resetState() {
            this.setClosed();
            this.readWriteConsumerInternal.set(Transaction.READ_WRITE_BEHAVIOR.AUTO);
            this.closeConsumerInternal.set(Transaction.CLOSE_BEHAVIOR.ROLLBACK);
        }

        private void setOpened() {
            assert (!this.opened.get().booleanValue());
            this.opened.set(true);
            this.refs.incrementAndGet();
        }

        private void setClosed() {
            if (this.opened.get().booleanValue()) {
                this.opened.set(false);
                this.refs.decrementAndGet();
            }
        }

        private SchemaTransaction schemaTransaction() {
            SchemaTransaction schemaTx = this.schemaTransaction.get();
            if (schemaTx == null) {
                schemaTx = HugeGraph.this.openSchemaTransaction();
                this.schemaTransaction.set(schemaTx);
            }
            return schemaTx;
        }

        private GraphTransaction graphTransaction() {
            GraphTransaction graphTx = this.graphTransaction.get();
            if (graphTx == null) {
                graphTx = HugeGraph.this.openGraphTransaction();
                this.graphTransaction.set(graphTx);
            }
            return graphTx;
        }

        private void destroyTransaction() {
            SchemaTransaction schemaTx;
            if (this.isOpen()) {
                throw new HugeException("Transaction should be closed before destroying");
            }
            GraphTransaction graphTx = this.graphTransaction.get();
            if (graphTx != null) {
                try {
                    graphTx.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close GraphTransaction", (Throwable)e);
                }
            }
            if ((schemaTx = this.schemaTransaction.get()) != null) {
                try {
                    schemaTx.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close SchemaTransaction", (Throwable)e);
                }
            }
            this.graphTransaction.remove();
            this.schemaTransaction.remove();
        }
    }
}

