/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.analyzer;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.analyzer.Analyzer;
import com.baidu.hugegraph.analyzer.AnsjAnalyzer;
import com.baidu.hugegraph.analyzer.HanLPAnalyzer;
import com.baidu.hugegraph.analyzer.IKAnalyzer;
import com.baidu.hugegraph.analyzer.JcsegAnalyzer;
import com.baidu.hugegraph.analyzer.JiebaAnalyzer;
import com.baidu.hugegraph.analyzer.MMSeg4JAnalyzer;
import com.baidu.hugegraph.analyzer.SmartCNAnalyzer;
import com.baidu.hugegraph.analyzer.WordAnalyzer;
import com.baidu.hugegraph.backend.serializer.SerializerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AnalyzerFactory {
    private static Map<String, Class<? extends Analyzer>> analyzers = new ConcurrentHashMap<String, Class<? extends Analyzer>>();

    public static Analyzer analyzer(String name, String mode) {
        switch (name = name.toLowerCase()) {
            case "word": {
                return new WordAnalyzer(mode);
            }
            case "ansj": {
                return new AnsjAnalyzer(mode);
            }
            case "hanlp": {
                return new HanLPAnalyzer(mode);
            }
            case "smartcn": {
                return new SmartCNAnalyzer(mode);
            }
            case "jieba": {
                return new JiebaAnalyzer(mode);
            }
            case "jcseg": {
                return new JcsegAnalyzer(mode);
            }
            case "mmseg4j": {
                return new MMSeg4JAnalyzer(mode);
            }
            case "ikanalyzer": {
                return new IKAnalyzer(mode);
            }
        }
        return AnalyzerFactory.customizedAnalyzer(name, mode);
    }

    private static Analyzer customizedAnalyzer(String name, String mode) {
        Class<? extends Analyzer> clazz = analyzers.get(name);
        if (clazz == null) {
            throw new HugeException("Not exists analyzer: %s", name);
        }
        assert (Analyzer.class.isAssignableFrom(clazz));
        try {
            return clazz.getConstructor(String.class).newInstance(mode);
        }
        catch (Exception e) {
            throw new HugeException("Failed to construct analyzer '%s' with mode '%s'", (Throwable)e, name, mode);
        }
    }

    public static void register(String name, String classPath) {
        Class<?> clazz;
        ClassLoader classLoader = SerializerFactory.class.getClassLoader();
        try {
            clazz = classLoader.loadClass(classPath);
        }
        catch (Exception e) {
            throw new HugeException("Load class path '%s' failed", (Throwable)e, classPath);
        }
        if (!Analyzer.class.isAssignableFrom(clazz)) {
            throw new HugeException("Class '%s' is not a subclass of class Analyzer", classPath);
        }
        if (analyzers.containsKey(name)) {
            throw new HugeException("Exists analyzer: %s(%s)", name, analyzers.get(name).getName());
        }
        analyzers.put(name, clazz);
    }
}

