/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.backend.cache.Cache;
import com.baidu.hugegraph.backend.cache.RamCache;
import com.baidu.hugegraph.util.Log;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class CacheManager {
    private static final Logger LOG = Log.logger(Cache.class);
    private static CacheManager INSTANCE = new CacheManager();
    private static final long TIMER_TICK_PERIOD = 10L;
    private final Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private final Timer timer = new Timer("cache-expirer", true);

    public static CacheManager instance() {
        return INSTANCE;
    }

    public CacheManager() {
        this.scheduleTimer(10.0f);
    }

    private TimerTask scheduleTimer(float period) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    this.tick();
                }
                catch (Throwable e) {
                    LOG.warn("An exception occurred when running tick", e);
                }
            }

            private void tick() {
                for (Map.Entry<String, Cache> entry : CacheManager.this.caches().entrySet()) {
                    LOG.debug("Cache '{}' expiration tick", (Object)entry.getKey());
                    entry.getValue().tick();
                }
            }
        };
        this.timer.schedule(task, 0L, (long)((double)period * 1000.0));
        return task;
    }

    public Map<String, Cache> caches() {
        return Collections.unmodifiableMap(this.caches);
    }

    public Cache cache(String name) {
        return this.cache(name, 0x100000);
    }

    public Cache cache(String name, int capacity) {
        if (!this.caches.containsKey(name)) {
            this.caches.putIfAbsent(name, new RamCache(capacity));
        }
        return this.caches.get(name);
    }
}

