/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.backend.cache.Cache;
import com.baidu.hugegraph.backend.cache.CacheManager;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendFeatures;
import com.baidu.hugegraph.backend.store.BackendMutation;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.store.BackendStoreProvider;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.type.HugeType;
import java.util.Iterator;

public class CachedBackendStore
implements BackendStore {
    private BackendStore store = null;
    private Cache cache = null;

    public CachedBackendStore(BackendStore store) {
        this.store = store;
        this.cache = CacheManager.instance().cache("store-" + this.store());
        this.cache.expire(30L);
    }

    @Override
    public String store() {
        return this.store.store();
    }

    @Override
    public String database() {
        return this.store.database();
    }

    @Override
    public BackendStoreProvider provider() {
        return this.store.provider();
    }

    @Override
    public void open(HugeConfig config) {
        this.store.open(config);
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public void init() {
        this.store.init();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void truncate() {
        this.store.truncate();
    }

    @Override
    public void beginTx() {
        this.store.beginTx();
    }

    @Override
    public void commitTx() {
        this.store.commitTx();
    }

    @Override
    public void rollbackTx() {
        this.store.rollbackTx();
    }

    @Override
    public <R> R metadata(HugeType type, String meta, Object[] args) {
        return this.store.metadata(type, meta, args);
    }

    @Override
    public BackendFeatures features() {
        return this.store.features();
    }

    @Override
    public Id nextId(HugeType type) {
        return this.store.nextId(type);
    }

    @Override
    public void increaseCounter(HugeType type, long increment) {
        this.store.increaseCounter(type, increment);
    }

    @Override
    public long getCounter(HugeType type) {
        return this.store.getCounter(type);
    }

    @Override
    public void mutate(BackendMutation mutation) {
        this.store.mutate(mutation);
    }

    @Override
    public Iterator<BackendEntry> query(Query query) {
        if (query.empty()) {
            return this.store.query(query);
        }
        QueryId id = new QueryId(query);
        Object result = this.cache.get(id);
        if (result != null) {
            return (Iterator)result;
        }
        Iterator<BackendEntry> rs = this.store.query(query);
        if (rs.hasNext()) {
            this.cache.update(id, rs);
        }
        return rs;
    }

    static class QueryId
    implements Id {
        private Query id;
        private int hashCode;

        public QueryId(Query q) {
            this.id = q;
            this.hashCode = this.id.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (!(other instanceof QueryId)) {
                return false;
            }
            return this.id.equals(((QueryId)other).id);
        }

        @Override
        public int compareTo(Id o) {
            return this.hashCode() - o.hashCode();
        }

        @Override
        public Object asObject() {
            return null;
        }

        @Override
        public String asString() {
            return this.id.toString();
        }

        @Override
        public long asLong() {
            return 0L;
        }

        @Override
        public byte[] asBytes() {
            return null;
        }

        public String toString() {
            return this.id.toString();
        }

        @Override
        public int length() {
            return 32;
        }

        @Override
        public boolean number() {
            return false;
        }
    }
}

