/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.cache.Cache;
import com.baidu.hugegraph.backend.cache.CacheManager;
import com.baidu.hugegraph.backend.cache.CachedBackendStore;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.store.BackendMutation;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.type.HugeType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CachedGraphTransaction
extends GraphTransaction {
    private static final int MAX_CACHE_EDGES_PER_QUERY = 100;
    private final Cache verticesCache;
    private final Cache edgesCache;

    public CachedGraphTransaction(HugeGraph graph, BackendStore store) {
        super(graph, store);
        HugeConfig conf = graph.configuration();
        int capacity = (Integer)conf.get(CoreOptions.VERTEX_CACHE_CAPACITY);
        int expire = (Integer)conf.get(CoreOptions.VERTEX_CACHE_EXPIRE);
        this.verticesCache = this.cache("vertex", capacity, expire);
        capacity = (Integer)conf.get(CoreOptions.EDGE_CACHE_CAPACITY);
        expire = (Integer)conf.get(CoreOptions.EDGE_CACHE_EXPIRE);
        this.edgesCache = this.cache("edge", capacity, expire);
    }

    private Cache cache(String prefix, int capacity, long expire) {
        String name = prefix + "-" + super.graph().name();
        Cache cache = CacheManager.instance().cache(name, capacity);
        cache.expire(expire);
        return cache;
    }

    @Override
    protected Iterator<HugeVertex> queryVerticesFromBackend(Query query) {
        if (!query.ids().isEmpty() && query.conditions().isEmpty()) {
            return this.queryVerticesByIds((IdQuery)query);
        }
        return super.queryVerticesFromBackend(query);
    }

    private Iterator<HugeVertex> queryVerticesByIds(IdQuery query) {
        IdQuery newQuery = new IdQuery(HugeType.VERTEX, query);
        ArrayList<HugeVertex> vertices = new ArrayList<HugeVertex>(query.ids().size());
        for (Id vertexId : query.ids()) {
            Object vertex = this.verticesCache.get(vertexId);
            if (vertex != null) {
                vertices.add((HugeVertex)vertex);
                continue;
            }
            newQuery.query(vertexId);
        }
        if (vertices.isEmpty()) {
            newQuery = query;
        }
        if (!newQuery.empty()) {
            Iterator<HugeVertex> rs = super.queryVerticesFromBackend(newQuery);
            while (rs.hasNext()) {
                HugeVertex vertex = rs.next();
                vertices.add(vertex);
                this.verticesCache.update(vertex.id(), vertex);
            }
        }
        return vertices.iterator();
    }

    @Override
    protected Iterator<HugeEdge> queryEdgesFromBackend(Query query) {
        if (query.empty()) {
            return super.queryEdgesFromBackend(query);
        }
        CachedBackendStore.QueryId id = new CachedBackendStore.QueryId(query);
        List edges = (List)this.edgesCache.get(id);
        if (edges == null && (edges = ImmutableList.copyOf(super.queryEdgesFromBackend(query))).size() <= 100) {
            this.edgesCache.update(id, edges);
        }
        return edges.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commitMutation2Backend(BackendMutation ... mutations) {
        Collection<HugeVertex> changes = this.verticesInTxUpdated();
        Collection<HugeVertex> deletions = this.verticesInTxRemoved();
        int edgesInTxSize = this.edgesInTxSize();
        try {
            super.commitMutation2Backend(mutations);
            for (HugeVertex vertex : changes) {
                vertex = vertex.resetTx();
                this.verticesCache.updateIfPresent(vertex.id(), vertex);
            }
        }
        finally {
            for (HugeVertex vertex : deletions) {
                this.verticesCache.invalidate(vertex.id());
            }
            if (edgesInTxSize > 0) {
                this.edgesCache.clear();
            }
        }
    }

    @Override
    public void removeIndex(IndexLabel indexLabel) {
        try {
            super.removeIndex(indexLabel);
        }
        finally {
            if (indexLabel.baseType() == HugeType.EDGE_LABEL) {
                this.edgesCache.clear();
            }
        }
    }
}

