/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.cache.Cache;
import com.baidu.hugegraph.backend.cache.CacheManager;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.event.Event;
import com.baidu.hugegraph.event.EventHub;
import com.baidu.hugegraph.event.EventListener;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.type.HugeType;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class CachedSchemaTransaction
extends SchemaTransaction {
    private final Cache idCache = this.cache("schema-id");
    private final Cache nameCache = this.cache("schema-name");
    private EventListener storeEventListener;
    private EventListener cacheEventListener;
    private final Map<HugeType, Boolean> cachedTypes = new ConcurrentHashMap<HugeType, Boolean>();

    public CachedSchemaTransaction(HugeGraph graph, BackendStore store) {
        super(graph, store);
        this.listenChanges();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.unlistenChanges();
        }
    }

    private Cache cache(String prefix) {
        HugeConfig conf = super.graph().configuration();
        String name = prefix + "-" + super.graph().name();
        int capacity = (Integer)conf.get(CoreOptions.SCHEMA_CACHE_CAPACITY);
        return CacheManager.instance().cache(name, capacity);
    }

    private void listenChanges() {
        ImmutableSet storeEvents = ImmutableSet.of((Object)"store.init", (Object)"store.clear", (Object)"store.truncate");
        this.storeEventListener = arg_0 -> this.lambda$listenChanges$0((Set)storeEvents, arg_0);
        this.store().provider().listen(this.storeEventListener);
        this.cacheEventListener = event -> {
            LOG.debug("Graph {} received cache event: {}", (Object)this.graph(), (Object)event);
            event.checkArgs(new Class[]{String.class, Id.class});
            Object[] args = event.args();
            if (args[0].equals("invalid")) {
                Id id = (Id)args[1];
                Object value = this.idCache.get(id);
                if (value != null) {
                    this.idCache.invalidate(id);
                    SchemaElement schema = (SchemaElement)value;
                    Id prefixedName = CachedSchemaTransaction.generateId(schema.type(), schema.name());
                    this.nameCache.invalidate(prefixedName);
                }
                return true;
            }
            return false;
        };
        EventHub schemaEventHub = this.graph().schemaEventHub();
        if (!schemaEventHub.containsListener("cache")) {
            schemaEventHub.listen("cache", this.cacheEventListener);
        }
    }

    private void unlistenChanges() {
        this.store().provider().unlisten(this.storeEventListener);
        EventHub schemaEventHub = this.graph().schemaEventHub();
        schemaEventHub.unlisten("cache", this.cacheEventListener);
    }

    private void resetCachedAllIfReachedCapacity() {
        if (this.idCache.size() >= this.idCache.capacity()) {
            LOG.warn("Schema cache reached capacity({}): {}", (Object)this.idCache.capacity(), (Object)this.idCache.size());
            this.cachedTypes.clear();
        }
    }

    private static Id generateId(HugeType type, Id id) {
        return IdGenerator.of(type.string() + "-" + id.asString());
    }

    private static Id generateId(HugeType type, String name) {
        return IdGenerator.of(type.string() + "-" + name);
    }

    private Object getOrFetch(HugeType type, Id id, Function<Id, Object> fetcher) {
        Id prefixedId = CachedSchemaTransaction.generateId(type, id);
        Object value = this.idCache.get(prefixedId);
        if (value == null && (value = fetcher.apply(id)) != null) {
            this.resetCachedAllIfReachedCapacity();
            this.idCache.update(prefixedId, value);
            SchemaElement schema = (SchemaElement)value;
            Id prefixedName = CachedSchemaTransaction.generateId(schema.type(), schema.name());
            this.nameCache.update(prefixedName, schema);
        }
        return value;
    }

    private Object getOrFetch(HugeType type, String name, Function<String, Object> fetcher) {
        Id prefixedName = CachedSchemaTransaction.generateId(type, name);
        Object value = this.nameCache.get(prefixedName);
        if (value == null && (value = fetcher.apply(name)) != null) {
            this.resetCachedAllIfReachedCapacity();
            this.nameCache.update(prefixedName, value);
            SchemaElement schema = (SchemaElement)value;
            Id prefixedId = CachedSchemaTransaction.generateId(schema.type(), schema.id());
            this.idCache.update(prefixedId, schema);
        }
        return value;
    }

    @Override
    protected void addSchema(SchemaElement schema) {
        super.addSchema(schema);
        this.resetCachedAllIfReachedCapacity();
        Id prefixedId = CachedSchemaTransaction.generateId(schema.type(), schema.id());
        this.idCache.update(prefixedId, schema);
        Id prefixedName = CachedSchemaTransaction.generateId(schema.type(), schema.name());
        this.nameCache.update(prefixedName, schema);
    }

    @Override
    protected <T extends SchemaElement> T getSchema(HugeType type, Id id) {
        Object value = this.getOrFetch(type, id, (Id k) -> super.getSchema(type, id));
        return (T)((SchemaElement)value);
    }

    @Override
    protected <T extends SchemaElement> T getSchema(HugeType type, String name) {
        Object value = this.getOrFetch(type, name, (String k) -> super.getSchema(type, name));
        return (T)((SchemaElement)value);
    }

    @Override
    protected void removeSchema(SchemaElement schema) {
        super.removeSchema(schema);
        Id prefixedId = CachedSchemaTransaction.generateId(schema.type(), schema.id());
        Object value = this.idCache.get(prefixedId);
        if (value != null) {
            this.idCache.invalidate(prefixedId);
            schema = (SchemaElement)value;
            Id prefixedName = CachedSchemaTransaction.generateId(schema.type(), schema.name());
            this.nameCache.invalidate(prefixedName);
        }
    }

    @Override
    protected <T extends SchemaElement> List<T> getAllSchema(HugeType type) {
        Boolean cachedAll = this.cachedTypes.getOrDefault(type, false);
        if (cachedAll.booleanValue()) {
            ArrayList results = new ArrayList();
            this.idCache.traverse(value -> {
                SchemaElement schema = (SchemaElement)value;
                if (schema.type() == type) {
                    results.add(schema);
                }
            });
            return results;
        }
        List results = super.getAllSchema(type);
        long free = this.idCache.capacity() - this.idCache.size();
        if ((long)results.size() < free) {
            for (SchemaElement schema : results) {
                Id prefixedId = CachedSchemaTransaction.generateId(schema.type(), schema.id());
                this.idCache.update(prefixedId, schema);
                Id prefixedName = CachedSchemaTransaction.generateId(schema.type(), schema.name());
                this.nameCache.update(prefixedName, schema);
            }
            this.cachedTypes.putIfAbsent(type, true);
        }
        return results;
    }

    private /* synthetic */ Object lambda$listenChanges$0(Set storeEvents, Event event) {
        if (storeEvents.contains(event.name())) {
            LOG.debug("Graph {} clear cache on event '{}'", (Object)this.graph(), (Object)event.name());
            this.idCache.clear();
            this.nameCache.clear();
            this.cachedTypes.clear();
            return true;
        }
        return false;
    }
}

