/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.backend.cache.Cache;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.concurrent.KeyLock;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;

public class RamCache
implements Cache {
    public static final int MB = 0x100000;
    public static final int DEFAULT_SIZE = 0x100000;
    public static final int MAX_INIT_CAP = 0x6400000;
    private static final Logger LOG = Log.logger(Cache.class);
    private volatile long hits = 0L;
    private volatile long miss = 0L;
    private volatile long expire = 0L;
    private final int capacity;
    private final ConcurrentMap<Id, LinkNode<Id, Object>> map;
    private final LinkedQueueNonBigLock<Id, Object> queue;
    private final KeyLock keyLock = new KeyLock();

    public RamCache() {
        this(0x100000);
    }

    public RamCache(int capacity) {
        if (capacity < 1) {
            capacity = 1;
        }
        this.capacity = capacity;
        int initialCapacity = capacity >> 3;
        if (initialCapacity > 0x6400000) {
            initialCapacity = 0x6400000;
        }
        this.map = new ConcurrentHashMap<Id, LinkNode<Id, Object>>(initialCapacity);
        this.queue = new LinkedQueueNonBigLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerfUtil.Watched(prefix="ramcache")
    private Object access(Id id) {
        assert (id != null);
        Lock lock = this.keyLock.lock((Object)id);
        try {
            LinkNode node = (LinkNode)this.map.get(id);
            if (node == null) {
                Object var4_4 = null;
                return var4_4;
            }
            if (this.map.size() > this.capacity >> 1) {
                if (this.queue.remove(node) == null) {
                    Object var4_5 = null;
                    return var4_5;
                }
                this.queue.enqueue(node);
            }
            ++this.hits;
            if (LOG.isDebugEnabled()) {
                LOG.debug("RamCache cached '{}' (hits={}, miss={})", new Object[]{id, this.hits, this.miss});
            }
            assert (id.equals(node.key()));
            Object v = node.value();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerfUtil.Watched(prefix="ramcache")
    private void write(Id id, Object value) {
        assert (id != null);
        assert (this.capacity > 0);
        Lock lock = this.keyLock.lock((Object)id);
        try {
            LinkNode node;
            while (this.map.size() >= this.capacity) {
                LinkNode<Id, Object> removed = this.queue.dequeue();
                if (removed == null) {
                    this.map.clear();
                    break;
                }
                this.map.remove(removed.key());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RamCache replaced '{}' with '{}' (capacity={})", new Object[]{removed.key(), id, this.capacity});
                }
                removed = null;
            }
            if ((node = (LinkNode)this.map.get(id)) != null) {
                this.queue.remove(node);
            }
            this.map.put(id, this.queue.enqueue(id, value));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerfUtil.Watched(prefix="ramcache")
    private void remove(Id id) {
        assert (id != null);
        Lock lock = this.keyLock.lock((Object)id);
        try {
            LinkNode node = (LinkNode)this.map.remove(id);
            if (node != null) {
                this.queue.remove(node);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public Object get(Id id) {
        Object value = null;
        if (this.map.containsKey(id)) {
            value = this.access(id);
        }
        if (value == null) {
            ++this.miss;
            if (LOG.isDebugEnabled()) {
                LOG.debug("RamCache missed '{}' (miss={}, hits={})", new Object[]{id, this.miss, this.hits});
            }
        }
        return value;
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public Object getOrFetch(Id id, Function<Id, Object> fetcher) {
        Object value = null;
        if (this.map.containsKey(id)) {
            value = this.access(id);
        }
        if (value == null) {
            ++this.miss;
            if (LOG.isDebugEnabled()) {
                LOG.debug("RamCache missed '{}' (miss={}, hits={})", new Object[]{id, this.miss, this.hits});
            }
            value = fetcher.apply(id);
            this.update(id, value);
        }
        return value;
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public void update(Id id, Object value) {
        if (id == null || value == null || this.capacity <= 0) {
            return;
        }
        this.write(id, value);
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public void updateIfAbsent(Id id, Object value) {
        if (id == null || value == null || this.capacity <= 0 || this.map.containsKey(id)) {
            return;
        }
        this.write(id, value);
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public void updateIfPresent(Id id, Object value) {
        if (id == null || value == null || this.capacity <= 0 || !this.map.containsKey(id)) {
            return;
        }
        this.write(id, value);
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public void invalidate(Id id) {
        if (id == null || !this.map.containsKey(id)) {
            return;
        }
        this.remove(id);
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public void traverse(Consumer<Object> consumer) {
        E.checkNotNull(consumer, (String)"consumer");
        this.map.values().forEach(node -> consumer.accept(node.value()));
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public void clear() {
        if (this.capacity <= 0 || this.map.isEmpty()) {
            return;
        }
        this.map.clear();
        this.queue.clear();
    }

    @Override
    public void expire(long seconds) {
        this.expire = seconds * 1000L;
    }

    @Override
    public long expire() {
        return this.expire;
    }

    @Override
    public void tick() {
        long expireTime = this.expire;
        if (expireTime <= 0L) {
            return;
        }
        int expireItems = 0;
        long current = RamCache.now();
        for (LinkNode node : this.map.values()) {
            if (current - node.time() <= expireTime) continue;
            this.remove((Id)node.key());
            ++expireItems;
        }
        if (expireItems > 0) {
            LOG.info("Cache expired {} items cost {}ms (size {}, expire {}ms)", new Object[]{expireItems, RamCache.now() - current, this.size(), expireTime});
        }
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public long hits() {
        return this.hits;
    }

    @Override
    public long miss() {
        return this.miss;
    }

    public String toString() {
        return this.map.toString();
    }

    private static final long now() {
        return System.currentTimeMillis();
    }

    private static final class LinkedQueueNonBigLock<K, V> {
        private final KeyLock keyLock = new KeyLock();
        private final LinkNode<K, V> empty = new LinkNode<String, Object>("<empty>", null);
        private final LinkNode<K, V> head = new LinkNode<String, Object>("<head>", null);
        private final LinkNode<K, V> rear = new LinkNode<String, Object>("<rear>", null);

        public LinkedQueueNonBigLock() {
            this.reset();
        }

        private void reset() {
            ((LinkNode)this.head).prev = (LinkNode)this.empty;
            ((LinkNode)this.head).next = (LinkNode)this.rear;
            ((LinkNode)this.rear).prev = (LinkNode)this.head;
            ((LinkNode)this.rear).next = (LinkNode)this.empty;
            assert (((LinkNode)this.head).next == this.rear);
            assert (((LinkNode)this.rear).prev == this.head);
        }

        private List<K> dumpKeys() {
            LinkedList keys = new LinkedList();
            LinkNode node = ((LinkNode)this.head).next;
            while (node != this.rear && node != this.empty) {
                assert (node != null);
                keys.add(node.key());
                node = node.next;
            }
            return keys;
        }

        private boolean checkNotInQueue(K key) {
            List<K> keys = this.dumpKeys();
            if (keys.contains(key)) {
                throw new RuntimeException(String.format("Expect %s should be not in %s", key, keys));
            }
            return true;
        }

        private boolean checkPrevNotInNext(LinkNode<K, V> self) {
            int selfPos;
            LinkNode prev = ((LinkNode)self).prev;
            if (prev.key() == null) {
                assert (prev == this.head || prev == this.empty) : prev;
                return true;
            }
            List<K> keys = this.dumpKeys();
            int prevPos = keys.indexOf(prev.key());
            if (prevPos > (selfPos = keys.indexOf(self.key())) && selfPos != -1) {
                throw new RuntimeException(String.format("Expect %s should be before %s, actual %s", prev.key(), self.key(), keys));
            }
            return true;
        }

        private List<Lock> lock(Object ... nodes) {
            return this.keyLock.lockAll(nodes);
        }

        private List<Lock> lock(Object node1, Object node2) {
            return this.keyLock.lockAll(node1, node2);
        }

        private void unlock(List<Lock> locks) {
            this.keyLock.unlockAll(locks);
        }

        public void clear() {
            assert (((LinkNode)this.rear).prev != null) : LinkNode.access$200(this.head);
            while (true) {
                LinkNode last = ((LinkNode)this.rear).prev;
                List<Lock> locks = this.lock(this.head, last, this.rear);
                try {
                    if (last != ((LinkNode)this.rear).prev) continue;
                    this.reset();
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
        }

        public LinkNode<K, V> enqueue(K key, V value) {
            return this.enqueue(new LinkNode<K, V>(key, value));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkNode<K, V> enqueue(LinkNode<K, V> node) {
            assert (node != null);
            assert (((LinkNode)node).prev == null || ((LinkNode)node).prev == this.empty);
            assert (((LinkNode)node).next == null || ((LinkNode)node).next == this.empty);
            while (true) {
                LinkNode last = ((LinkNode)this.rear).prev;
                List<Lock> locks = this.lock((Object)last, (Object)this.rear);
                try {
                    if (last != ((LinkNode)this.rear).prev) continue;
                    ((LinkNode)node).next = (LinkNode)this.rear;
                    assert (((LinkNode)this.rear).prev == last) : LinkNode.access$100(this.rear);
                    ((LinkNode)this.rear).prev = (LinkNode)node;
                    ((LinkNode)node).prev = last;
                    last.next = (LinkNode)node;
                    LinkNode<K, V> linkNode = node;
                    return linkNode;
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkNode<K, V> dequeue() {
            LinkNode first;
            while ((first = ((LinkNode)this.head).next) != this.rear) {
                List<Lock> locks = this.lock((Object)this.head, (Object)first);
                try {
                    if (first != ((LinkNode)this.head).next) continue;
                    assert (first.next != null);
                    ((LinkNode)this.head).next = first.next;
                    first.next.prev = (LinkNode)this.head;
                    first.prev = (LinkNode)this.empty;
                    first.next = (LinkNode)this.empty;
                    LinkNode linkNode = first;
                    return linkNode;
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkNode<K, V> remove(LinkNode<K, V> node) {
            assert (node != this.empty);
            assert (node != this.head && node != this.rear);
            while (true) {
                LinkNode prev;
                if ((prev = ((LinkNode)node).prev) == this.empty) {
                    assert (((LinkNode)node).next == this.empty);
                    return null;
                }
                List<Lock> locks = this.lock((Object)prev, (Object)node);
                try {
                    if (prev != ((LinkNode)node).prev) continue;
                    assert (((LinkNode)node).next != null) : node;
                    assert (((LinkNode)node).next != ((LinkNode)node).prev) : LinkNode.access$200(node);
                    ((LinkNode)node).prev.next = ((LinkNode)node).next;
                    ((LinkNode)node).next.prev = ((LinkNode)node).prev;
                    assert (prev == ((LinkNode)node).prev) : LinkNode.access$300(prev) + "!=" + LinkNode.access$100(node);
                    ((LinkNode)node).prev = (LinkNode)this.empty;
                    ((LinkNode)node).next = (LinkNode)this.empty;
                    LinkNode<K, V> linkNode = node;
                    return linkNode;
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
        }
    }

    private static class LinkNode<K, V> {
        private final K key;
        private final V value;
        private long time;
        private LinkNode<K, V> prev;
        private LinkNode<K, V> next;

        public LinkNode(K key, V value) {
            assert (key != null);
            this.time = RamCache.now();
            this.key = key;
            this.value = value;
            this.next = null;
            this.prev = null;
        }

        public final K key() {
            return this.key;
        }

        public final V value() {
            return this.value;
        }

        public long time() {
            return this.time;
        }

        public String toString() {
            return this.key.toString();
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LinkNode)) {
                return false;
            }
            LinkNode other = (LinkNode)obj;
            return this.key.equals(other.key());
        }

        static /* synthetic */ Object access$300(LinkNode x0) {
            return x0.key;
        }
    }
}

