/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.id;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.NumericUtil;
import com.baidu.hugegraph.util.StringEncoding;

public abstract class IdGenerator {
    public abstract Id generate(HugeVertex var1);

    public static Id of(String id) {
        return new StringId(id);
    }

    public static Id of(long id) {
        return new LongId(id);
    }

    public static Id of(byte[] bytes, boolean number) {
        return number ? new LongId(bytes) : new StringId(bytes);
    }

    public Id generate(String id) {
        return IdGenerator.of(id);
    }

    public Id generate(long id) {
        return IdGenerator.of(id);
    }

    public static final class LongId
    extends Number
    implements Id {
        private static final long serialVersionUID = -7732461469037400190L;
        private final long id;

        public LongId(long id) {
            this.id = id;
        }

        public LongId(byte[] bytes) {
            this.id = NumericUtil.bytesToLong((byte[])bytes);
        }

        @Override
        public boolean number() {
            return true;
        }

        @Override
        public Object asObject() {
            return this.id;
        }

        @Override
        public String asString() {
            return String.valueOf(this.id);
        }

        @Override
        public long asLong() {
            return this.id;
        }

        @Override
        public byte[] asBytes() {
            return NumericUtil.longToBytes((long)this.id);
        }

        @Override
        public int length() {
            return 8;
        }

        @Override
        public int compareTo(Id other) {
            return Long.compare(this.id, other.asLong());
        }

        public int hashCode() {
            return Long.hashCode(this.id);
        }

        public boolean equals(Object other) {
            if (!(other instanceof LongId)) {
                return false;
            }
            return this.id == ((LongId)other).id;
        }

        public String toString() {
            return String.valueOf(this.id);
        }

        @Override
        public int intValue() {
            return (int)this.id;
        }

        @Override
        public long longValue() {
            return this.id;
        }

        @Override
        public float floatValue() {
            return this.id;
        }

        @Override
        public double doubleValue() {
            return this.id;
        }
    }

    public static final class StringId
    implements Id {
        private final String id;

        public StringId(String id) {
            E.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (String)"The id can't be empty", (Object[])new Object[0]);
            this.id = id;
        }

        public StringId(byte[] bytes) {
            this.id = StringEncoding.decode(bytes);
        }

        @Override
        public boolean number() {
            return false;
        }

        @Override
        public Object asObject() {
            return this.id;
        }

        @Override
        public String asString() {
            return this.id;
        }

        @Override
        public long asLong() {
            return Long.parseLong(this.id);
        }

        @Override
        public byte[] asBytes() {
            return StringEncoding.encode(this.id);
        }

        @Override
        public int length() {
            return this.id.length();
        }

        @Override
        public int compareTo(Id other) {
            return this.id.compareTo(other.asString());
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof StringId)) {
                return false;
            }
            return this.id.equals(((StringId)other).id);
        }

        public String toString() {
            return this.id;
        }
    }
}

