/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.id;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.util.StringUtil;
import java.util.List;

public class SplicingIdGenerator
extends IdGenerator {
    private static volatile SplicingIdGenerator instance;
    private static final char ESCAPE = '`';
    private static final char IDS_SPLITOR = '>';
    private static final char ID_SPLITOR = ':';
    private static final char NAME_SPLITOR = '!';
    public static final String ESCAPE_STR;
    public static final String IDS_SPLITOR_STR;
    public static final String ID_SPLITOR_STR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SplicingIdGenerator instance() {
        if (instance != null) return instance;
        Class<SplicingIdGenerator> clazz = SplicingIdGenerator.class;
        synchronized (SplicingIdGenerator.class) {
            if (instance != null) return instance;
            instance = new SplicingIdGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public Id generate(HugeVertex vertex) {
        return SplicingIdGenerator.splicing(vertex.schemaLabel().id().asString(), vertex.name());
    }

    public static String concat(String ... ids) {
        return StringUtil.escape('>', '`', ids);
    }

    public static String[] split(String ids) {
        return StringUtil.unescape(ids, IDS_SPLITOR_STR, ESCAPE_STR);
    }

    public static String concatValues(List<?> values) {
        int valuesSize = values.size();
        String[] parts = new String[valuesSize];
        for (int i = 0; i < valuesSize; ++i) {
            parts[i] = values.get(i).toString();
        }
        return StringUtil.escape('!', '`', parts);
    }

    public static Id splicing(String ... parts) {
        String escaped = StringUtil.escape(':', '`', parts);
        return IdGenerator.of(escaped);
    }

    public static String[] parse(Id id) {
        return StringUtil.unescape(id.asString(), ID_SPLITOR_STR, ESCAPE_STR);
    }

    static {
        ESCAPE_STR = String.valueOf('`');
        IDS_SPLITOR_STR = String.valueOf('>');
        ID_SPLITOR_STR = String.valueOf(':');
    }
}

