/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.query;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ConditionQuery
extends IdQuery {
    private Set<Condition> conditions = new LinkedHashSet<Condition>();
    private int optimizedType = 0;
    private Function<HugeElement, Boolean> resultsFilter = null;

    public ConditionQuery(HugeType resultType) {
        super(resultType);
    }

    public ConditionQuery(HugeType resultType, Query originQuery) {
        super(resultType, originQuery);
    }

    public ConditionQuery query(Condition condition) {
        Condition.Relation relation;
        if (condition instanceof Condition.Relation && (relation = (Condition.Relation)condition).key().equals((Object)HugeKeys.ID) && relation.relation() == Condition.RelationType.EQ) {
            E.checkArgument((boolean)(relation.value() instanceof Id), (String)"Invalid id value '%s'", (Object[])new Object[]{relation.value()});
            super.query((Id)relation.value());
            return this;
        }
        this.conditions.add(condition);
        return this;
    }

    public ConditionQuery eq(HugeKeys key, Object value) {
        return this.query(Condition.eq(key, value));
    }

    public ConditionQuery gt(HugeKeys key, Object value) {
        return this.query(Condition.gt(key, value));
    }

    public ConditionQuery gte(HugeKeys key, Object value) {
        return this.query(Condition.gte(key, value));
    }

    public ConditionQuery lt(HugeKeys key, Object value) {
        return this.query(Condition.lt(key, value));
    }

    public ConditionQuery lte(HugeKeys key, Object value) {
        return this.query(Condition.lte(key, value));
    }

    public ConditionQuery neq(HugeKeys key, Object value) {
        return this.query(Condition.neq(key, value));
    }

    public ConditionQuery prefix(HugeKeys key, Id value) {
        return this.query(Condition.prefix(key, value));
    }

    public ConditionQuery key(HugeKeys key, Object value) {
        return this.query(Condition.containsKey(key, value));
    }

    public ConditionQuery scan(String start, String end) {
        return this.query(Condition.scan(start, end));
    }

    @Override
    public Set<Condition> conditions() {
        return Collections.unmodifiableSet(this.conditions);
    }

    public void resetConditions(Set<Condition> conditions) {
        this.conditions = conditions;
    }

    public void resetConditions() {
        this.conditions = new LinkedHashSet<Condition>();
    }

    @Override
    public String toString() {
        return String.format("%s and %s", super.toString(), this.conditions.toString());
    }

    public List<Condition.Relation> relations() {
        ArrayList<Condition.Relation> relations = new ArrayList<Condition.Relation>();
        for (Condition c : this.conditions) {
            relations.addAll(c.relations());
        }
        return relations;
    }

    public Object condition(Object key) {
        this.checkFlattened();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Condition c : this.conditions) {
            Condition.Relation r;
            if (!c.isRelation() || !(r = (Condition.Relation)c).key().equals(key)) continue;
            values.add(r.value());
        }
        if (values.isEmpty()) {
            return null;
        }
        E.checkState((values.size() == 1 ? 1 : 0) != 0, (String)"Illegal key '%s' with more than one value", (Object[])new Object[]{key});
        return values.get(0);
    }

    public void unsetCondition(Object key) {
        this.checkFlattened();
        Iterator<Condition> iter = this.conditions.iterator();
        while (iter.hasNext()) {
            Condition c = iter.next();
            assert (c.isRelation());
            if (!((Condition.Relation)c).key().equals(key)) continue;
            iter.remove();
        }
    }

    public boolean containsCondition(HugeKeys key) {
        return this.condition((Object)key) != null;
    }

    public boolean containsCondition(HugeKeys key, Condition.RelationType type) {
        for (Condition.Relation r : this.relations()) {
            if (!r.key().equals((Object)key) || !r.relation().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCondition(Condition.RelationType type) {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsScanCondition() {
        return this.containsCondition(Condition.RelationType.SCAN);
    }

    public boolean allSysprop() {
        for (Condition c : this.conditions) {
            if (c.isSysprop()) continue;
            return false;
        }
        return true;
    }

    public List<Condition> syspropConditions() {
        this.checkFlattened();
        ArrayList<Condition> conds = new ArrayList<Condition>();
        for (Condition c : this.conditions) {
            if (!c.isSysprop()) continue;
            conds.add(c);
        }
        return conds;
    }

    public List<Condition> syspropConditions(HugeKeys key) {
        this.checkFlattened();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Condition condition : this.conditions) {
            Condition.Relation relation = (Condition.Relation)condition;
            if (!relation.key().equals((Object)key)) continue;
            conditions.add(relation);
        }
        return conditions;
    }

    public List<Condition> userpropConditions() {
        this.checkFlattened();
        ArrayList<Condition> conds = new ArrayList<Condition>();
        for (Condition c : this.conditions) {
            if (c.isSysprop()) continue;
            conds.add(c);
        }
        return conds;
    }

    public List<Condition> userpropConditions(Id key) {
        this.checkFlattened();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Condition condition : this.conditions) {
            Condition.Relation relation = (Condition.Relation)condition;
            if (!relation.key().equals(key)) continue;
            conditions.add(relation);
        }
        return conditions;
    }

    public List<Condition.Relation> userpropRelations() {
        ArrayList<Condition.Relation> relations = new ArrayList<Condition.Relation>();
        for (Condition.Relation r : this.relations()) {
            if (r.isSysprop()) continue;
            relations.add(r);
        }
        return relations;
    }

    public void resetUserpropConditions() {
        this.checkFlattened();
        this.conditions.removeIf(condition -> !condition.isSysprop());
    }

    public Set<Id> userpropKeys() {
        LinkedHashSet<Id> keys = new LinkedHashSet<Id>();
        for (Condition.Relation r : this.relations()) {
            if (r.isSysprop()) continue;
            Condition.UserpropRelation ur = (Condition.UserpropRelation)r;
            keys.add(ur.key());
        }
        return keys;
    }

    public List<Object> userpropValues(List<Id> fields) {
        ArrayList<Object> values = new ArrayList<Object>(fields.size());
        for (Id field : fields) {
            boolean got = false;
            for (Condition.Relation r : this.userpropRelations()) {
                if (!r.key().equals(field) || r.isSysprop()) continue;
                E.checkState((r.relation == Condition.RelationType.EQ ? 1 : 0) != 0, (String)"Method userpropValues(List<String>) only used for secondary index, relation must be EQ, but got '%s'", (Object[])new Object[]{r.relation()});
                values.add(r.value());
                got = true;
            }
            if (got) continue;
            throw new BackendException("No such userprop named '%s' in the query '%s'", field, this);
        }
        return values;
    }

    public String userpropValuesString(List<Id> fields) {
        return SplicingIdGenerator.concatValues(this.userpropValues(fields));
    }

    public Set<Object> userpropValues(Id field) {
        HashSet<Object> values = new HashSet<Object>();
        for (Condition.Relation r : this.userpropRelations()) {
            if (!r.key().equals(field)) continue;
            values.add(r.value());
        }
        return values;
    }

    public Object userpropValue(Id field) {
        Set<Object> values = this.userpropValues(field);
        if (values.isEmpty()) {
            return null;
        }
        E.checkState((values.size() == 1 ? 1 : 0) != 0, (String)"Expect one user-property value of field '%s', but got %s", (Object[])new Object[]{field, values.size()});
        return values.iterator().next();
    }

    public boolean hasRangeCondition() {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().isRangeType()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSearchCondition() {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().isSearchType()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSecondaryCondition() {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().isSecondaryType()) continue;
            return true;
        }
        return false;
    }

    public boolean matchUserpropKeys(List<Id> keys) {
        Set<Id> conditionKeys = this.userpropKeys();
        return keys.size() > 0 && conditionKeys.containsAll(keys);
    }

    @Override
    public ConditionQuery copy() {
        ConditionQuery query = (ConditionQuery)super.copy();
        query.originQuery(this);
        query.conditions = new LinkedHashSet<Condition>(this.conditions);
        return query;
    }

    @Override
    public boolean test(HugeElement element) {
        if (!this.ids().isEmpty() && !super.test(element)) {
            return false;
        }
        if (this.resultsFilter != null) {
            return (Boolean)this.resultsFilter.apply((Object)element);
        }
        for (Condition cond : this.conditions()) {
            if (cond.test(element)) continue;
            return false;
        }
        return true;
    }

    public void checkFlattened() {
        for (Condition condition : this.conditions) {
            E.checkState((boolean)condition.isRelation(), (String)"Condition Query has none-flatten condition '%s'", (Object[])new Object[]{condition});
        }
    }

    public void optimized(int optimizedType) {
        this.optimizedType = optimizedType;
        Query originQuery = this.originQuery();
        if (originQuery instanceof ConditionQuery) {
            ((ConditionQuery)originQuery).optimized(optimizedType);
        }
    }

    public int optimized() {
        return this.optimizedType;
    }

    public void registerResultsFilter(Function<HugeElement, Boolean> filter) {
        this.resultsFilter = filter;
        Query originQuery = this.originQuery();
        if (originQuery instanceof ConditionQuery) {
            ((ConditionQuery)originQuery).registerResultsFilter(filter);
        }
    }
}

