/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.query;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import java.util.Collections;
import java.util.Set;

public class IdQuery
extends Query {
    private Set<Id> ids = InsertionOrderUtil.newSet();

    public IdQuery(HugeType resultType) {
        super(resultType);
    }

    public IdQuery(HugeType resultType, Query originQuery) {
        super(resultType, originQuery);
    }

    public IdQuery(HugeType resultType, Set<Id> ids) {
        this(resultType);
        this.query(ids);
    }

    public IdQuery(HugeType resultType, Id id) {
        this(resultType);
        this.query(id);
    }

    public IdQuery(Query originQuery, Id id) {
        this(originQuery.resultType(), originQuery);
        this.query(id);
    }

    public IdQuery(Query originQuery, Set<Id> ids) {
        this(originQuery.resultType(), originQuery);
        this.query(ids);
    }

    @Override
    public Set<Id> ids() {
        return Collections.unmodifiableSet(this.ids);
    }

    public void resetIds() {
        this.ids = InsertionOrderUtil.newSet();
    }

    public IdQuery query(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Query id can't be null", (Object[])new Object[0]);
        this.ids.add(id);
        this.checkCapacity(this.ids.size());
        return this;
    }

    public IdQuery query(Set<Id> ids) {
        for (Id id : ids) {
            this.query(id);
        }
        return this;
    }

    @Override
    public boolean test(HugeElement element) {
        return this.ids.contains(element.id());
    }

    @Override
    public IdQuery copy() {
        IdQuery query = (IdQuery)super.copy();
        query.ids = InsertionOrderUtil.newSet(this.ids);
        return query;
    }

    @Override
    public String toString() {
        return String.format("%s where id in %s", super.toString(), this.ids.toString());
    }
}

