/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.query;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.exception.LimitExceedException;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Query
implements Cloneable {
    public static final long NO_LIMIT = Long.MAX_VALUE;
    public static final long NO_CAPACITY = -1L;
    public static final long DEFAULT_CAPACITY = 800000L;
    private HugeType resultType;
    private Map<HugeKeys, Order> orders;
    private long offset;
    private long limit;
    private String page;
    private long capacity;
    private boolean showHidden;
    private Query originQuery;
    private static final ThreadLocal<Long> capacityContex = new ThreadLocal();

    public Query(HugeType resultType) {
        this(resultType, null);
    }

    public Query(HugeType resultType, Query originQuery) {
        this.resultType = resultType;
        this.originQuery = originQuery;
        this.orders = new LinkedHashMap<HugeKeys, Order>();
        this.offset = 0L;
        this.limit = Long.MAX_VALUE;
        this.page = null;
        this.capacity = Query.defaultCapacity();
        this.showHidden = false;
    }

    public HugeType resultType() {
        return this.resultType;
    }

    public void resultType(HugeType resultType) {
        this.resultType = resultType;
    }

    public Query originQuery() {
        return this.originQuery;
    }

    protected void originQuery(Query originQuery) {
        this.originQuery = originQuery;
    }

    public Map<HugeKeys, Order> orders() {
        return Collections.unmodifiableMap(this.orders);
    }

    public void orders(Map<HugeKeys, Order> orders) {
        this.orders = new LinkedHashMap<HugeKeys, Order>(orders);
    }

    public void order(HugeKeys key, Order order) {
        this.orders.put(key, order);
    }

    public long offset() {
        return this.offset;
    }

    public void offset(long offset) {
        E.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"Invalid offset %s", (Object[])new Object[]{offset});
        this.offset = offset;
    }

    public long total() {
        if (this.limit == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.offset + this.limit;
    }

    public long limit() {
        return this.limit;
    }

    public void limit(long limit) {
        E.checkArgument((limit >= 0L ? 1 : 0) != 0, (String)"Invalid limit %s", (Object[])new Object[]{limit});
        this.limit = limit;
    }

    public boolean reachLimit(long count) {
        if (this.limit == Long.MAX_VALUE) {
            return false;
        }
        return count >= this.offset + this.limit;
    }

    public void range(long start, long end) {
        long offset = this.offset();
        start = Math.max(start, offset);
        this.offset(start);
        if (end != -1L) {
            if (this.limit() != Long.MAX_VALUE) {
                end = Math.min(end, offset + this.limit());
            } else assert (end < Long.MAX_VALUE);
            E.checkArgument((end >= start ? 1 : 0) != 0, (String)"Invalid range: [%s, %s)", (Object[])new Object[]{start, end});
            this.limit(end - start);
        } else assert (this.limit() <= Long.MAX_VALUE);
    }

    public String page() {
        if (this.page != null) {
            E.checkState((this.limit != Long.MAX_VALUE ? 1 : 0) != 0, (String)"Must set limit when using paging", (Object[])new Object[0]);
            E.checkState((this.limit != 0L ? 1 : 0) != 0, (String)"Can't set limit=0 when using paging", (Object[])new Object[0]);
            E.checkState((this.offset == 0L ? 1 : 0) != 0, (String)"Can't set offset when using paging, but got '%s'", (Object[])new Object[]{this.offset});
        }
        return this.page;
    }

    public void page(String page) {
        this.page = page;
    }

    public boolean paging() {
        return this.page != null;
    }

    public long capacity() {
        return this.capacity;
    }

    public void capacity(long capacity) {
        this.capacity = capacity;
    }

    public void checkCapacity(long count) throws LimitExceedException {
        if (this.capacity != -1L && count > this.capacity) {
            int MAX_CHARS = 256;
            String query = this.toString();
            if (query.length() > 256) {
                query = query.substring(0, 256) + "...";
            }
            throw new LimitExceedException("Too many records(must <=%s) for the query: %s", this.capacity, query);
        }
    }

    public boolean showHidden() {
        return this.showHidden;
    }

    public void showHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public Set<Id> ids() {
        return ImmutableSet.of();
    }

    public Set<Condition> conditions() {
        return ImmutableSet.of();
    }

    public boolean empty() {
        return this.ids().isEmpty() && this.conditions().isEmpty();
    }

    public boolean test(HugeElement element) {
        return true;
    }

    public Query copy() {
        try {
            return (Query)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BackendException(e);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Query)) {
            return false;
        }
        Query other = (Query)object;
        return this.resultType.equals(other.resultType) && this.orders.equals(other.orders) && this.offset == other.offset && this.limit == other.limit && (this.page == null && other.page == null || this.page.equals(other.page)) && this.ids().equals(other.ids()) && this.conditions().equals(other.conditions());
    }

    public int hashCode() {
        return this.resultType.hashCode() ^ this.orders.hashCode() ^ Long.hashCode(this.offset) ^ Long.hashCode(this.limit) ^ Objects.hashCode((Object[])new Object[]{this.page}) ^ this.ids().hashCode() ^ this.conditions().hashCode();
    }

    public String toString() {
        return String.format("Query for %s offset=%d, limit=%d, order by %s", this.resultType, this.offset, this.limit, this.orders.toString());
    }

    public static long defaultCapacity(long capacity) {
        Long old = capacityContex.get();
        capacityContex.set(capacity);
        return old != null ? old : 800000L;
    }

    public static long defaultCapacity() {
        Long capacity = capacityContex.get();
        return capacity != null ? capacity : 800000L;
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

