/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.serializer;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.serializer.BytesBuffer;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.StringEncoding;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BinaryBackendEntry
implements BackendEntry {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final HugeType type;
    private final BinaryId id;
    private Id subId;
    private final List<BackendEntry.BackendColumn> columns;

    public BinaryBackendEntry(HugeType type, byte[] bytes) {
        this(type, BytesBuffer.wrap(bytes).parseId());
    }

    public BinaryBackendEntry(HugeType type, BinaryId id) {
        this.type = type;
        this.id = id;
        this.subId = null;
        this.columns = new ArrayList<BackendEntry.BackendColumn>();
    }

    @Override
    public HugeType type() {
        return this.type;
    }

    @Override
    public BinaryId id() {
        return this.id;
    }

    @Override
    public Id subId() {
        return this.subId;
    }

    public void subId(Id subId) {
        this.subId = subId;
    }

    public String toString() {
        return String.format("%s: %s", this.id, this.columns.toString());
    }

    public BackendEntry.BackendColumn column(byte[] name) {
        for (BackendEntry.BackendColumn col : this.columns) {
            if (!Arrays.equals(col.name, name)) continue;
            return col;
        }
        return null;
    }

    public void column(BackendEntry.BackendColumn column) {
        this.columns.add(column);
    }

    public void column(byte[] name, byte[] value) {
        E.checkNotNull((Object)name, (String)"name");
        value = value != null ? value : EMPTY_BYTES;
        this.columns.add(BackendEntry.BackendColumn.of(name, value));
    }

    @Override
    public Collection<BackendEntry.BackendColumn> columns() {
        if (this.columns.size() > 1) {
            Collections.sort(this.columns);
        }
        return Collections.unmodifiableCollection(this.columns);
    }

    @Override
    public int columnsSize() {
        return this.columns.size();
    }

    @Override
    public void columns(Collection<BackendEntry.BackendColumn> bytesColumns) {
        this.columns.addAll(bytesColumns);
    }

    @Override
    public void columns(BackendEntry.BackendColumn ... bytesColumns) {
        this.columns.addAll(Arrays.asList(bytesColumns));
    }

    public BackendEntry.BackendColumn removeColumn(int index) {
        return this.columns.remove(index);
    }

    @Override
    public void merge(BackendEntry other) {
        for (BackendEntry.BackendColumn col : other.columns()) {
            BackendEntry.BackendColumn origin = this.column(col.name);
            if (origin != null) {
                origin.value = col.value;
                continue;
            }
            this.column(col);
        }
    }

    @Override
    public void clear() {
        this.columns.clear();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BinaryBackendEntry)) {
            return false;
        }
        BinaryBackendEntry other = (BinaryBackendEntry)obj;
        if (this.id() != other.id() && !this.id().equals(other.id())) {
            return false;
        }
        if (this.columns.size() != other.columns.size()) {
            return false;
        }
        return this.columns.containsAll(other.columns);
    }

    protected static class BinaryId
    implements Id {
        private final byte[] bytes;
        private final Id id;

        public BinaryId(byte[] bytes, Id id) {
            this.bytes = bytes;
            this.id = id;
        }

        public Id origin() {
            return this.id;
        }

        @Override
        public boolean number() {
            return false;
        }

        @Override
        public Object asObject() {
            return this.asBytes();
        }

        @Override
        public String asString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(Id other) {
            return Bytes.compare((byte[])this.bytes, (byte[])other.asBytes());
        }

        @Override
        public byte[] asBytes() {
            return this.bytes;
        }

        public byte[] asBytes(int offset) {
            E.checkArgument((offset < this.bytes.length ? 1 : 0) != 0, (String)"Invalid offset %s, must be < length %s", (Object[])new Object[]{offset, this.bytes.length});
            return Arrays.copyOfRange(this.bytes, offset, this.bytes.length);
        }

        @Override
        public int length() {
            return this.bytes.length;
        }

        public int hashCode() {
            return ByteBuffer.wrap(this.bytes).hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof BinaryId)) {
                return false;
            }
            return Arrays.equals(this.bytes, ((BinaryId)other).bytes);
        }

        public String toString() {
            return StringEncoding.decode(this.bytes);
        }
    }
}

