/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.serializer;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.serializer.BinaryBackendEntry;
import com.baidu.hugegraph.backend.serializer.BytesBuffer;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendEntryIterator;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.E;
import java.util.Base64;
import java.util.function.BiFunction;

public class BinaryEntryIterator<Elem>
extends BackendEntryIterator {
    protected final BackendEntry.BackendIterator<Elem> results;
    protected final BiFunction<BackendEntry, Elem, BackendEntry> merger;
    protected BackendEntry next;

    public BinaryEntryIterator(BackendEntry.BackendIterator<Elem> results, Query query, BiFunction<BackendEntry, Elem, BackendEntry> m) {
        super(query);
        E.checkNotNull(results, (String)"results");
        E.checkNotNull(m, (String)"merger");
        this.results = results;
        this.merger = m;
        this.next = null;
        this.skipOffset();
        if (query.paging()) {
            this.skipPageOffset(query.page());
        }
    }

    @Override
    public void close() throws Exception {
        this.results.close();
    }

    @Override
    protected final boolean fetch() {
        assert (this.current == null);
        if (this.next != null) {
            this.current = this.next;
            this.next = null;
        }
        while (this.results.hasNext()) {
            Object elem = this.results.next();
            BackendEntry merged = this.merger.apply(this.current, elem);
            E.checkState((merged != null ? 1 : 0) != 0, (String)"Error when merging entry", (Object[])new Object[0]);
            if (this.current == null) {
                this.current = merged;
            } else {
                if (merged != this.current) {
                    assert (this.next == null);
                    this.next = merged;
                    break;
                }
                assert (this.current != null);
            }
            if (!this.query.reachLimit(this.fetched() - 1L)) continue;
            this.removeLastRecord();
            this.results.close();
            break;
        }
        return this.current != null;
    }

    @Override
    protected final long sizeOf(BackendEntry entry) {
        if (entry.type().isEdge() || entry.type().isIndex()) {
            return entry.columnsSize();
        }
        return 1L;
    }

    @Override
    protected final long skip(BackendEntry entry, long skip) {
        BinaryBackendEntry e = (BinaryBackendEntry)entry;
        E.checkState(((long)e.columnsSize() > skip ? 1 : 0) != 0, (String)"Invalid entry to skip", (Object[])new Object[0]);
        for (long i = 0L; i < skip; ++i) {
            e.removeColumn(0);
        }
        return e.columnsSize();
    }

    @Override
    protected String pageState() {
        byte[] position = this.results.position();
        if (position == null) {
            return null;
        }
        PageState page = new PageState(position, 0);
        return page.toString();
    }

    private void removeLastRecord() {
        int lastOne = this.current.columnsSize() - 1;
        ((BinaryBackendEntry)this.current).removeColumn(lastOne);
    }

    private void skipPageOffset(String page) {
        PageState pagestate = PageState.fromString(page);
        if (pagestate.offset() > 0 && this.fetch()) {
            this.skip(this.current, pagestate.offset());
        }
    }

    public static class PageState {
        private final byte[] position;
        private final int offset;

        public PageState(byte[] position, int offset) {
            E.checkNotNull((Object)position, (String)"position");
            this.position = position;
            this.offset = offset;
        }

        public byte[] position() {
            return this.position;
        }

        public int offset() {
            return this.offset;
        }

        public String toString() {
            return Base64.getEncoder().encodeToString(this.toBytes());
        }

        public byte[] toBytes() {
            int length = 2 + this.position.length + 4;
            BytesBuffer buffer = BytesBuffer.allocate(length);
            buffer.writeBytes(this.position);
            buffer.writeInt(this.offset);
            return buffer.bytes();
        }

        public static PageState fromString(String page) {
            byte[] bytes;
            try {
                bytes = Base64.getDecoder().decode(page);
            }
            catch (Exception e) {
                throw new BackendException("Invalid page: '%s'", (Throwable)e, page);
            }
            return PageState.fromBytes(bytes);
        }

        public static PageState fromBytes(byte[] bytes) {
            if (bytes.length == 0) {
                return new PageState(new byte[0], 0);
            }
            try {
                BytesBuffer buffer = BytesBuffer.wrap(bytes);
                return new PageState(buffer.readBytes(), buffer.readInt());
            }
            catch (Exception e) {
                throw new BackendException("Invalid page: '0x%s'", (Throwable)e, Bytes.toHex((byte[])bytes));
            }
        }
    }
}

