/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.serializer;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.serializer.AbstractSerializer;
import com.baidu.hugegraph.backend.serializer.BinaryBackendEntry;
import com.baidu.hugegraph.backend.serializer.BytesBuffer;
import com.baidu.hugegraph.backend.serializer.TextBackendEntry;
import com.baidu.hugegraph.backend.serializer.TextSerializer;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeEdgeProperty;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.structure.HugeIndex;
import com.baidu.hugegraph.structure.HugeProperty;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.structure.HugeVertexProperty;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Cardinality;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.KryoUtil;
import com.baidu.hugegraph.util.StringEncoding;
import com.baidu.hugegraph.util.StringUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;

public class BinarySerializer
extends AbstractSerializer {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final boolean keyWithIdPrefix;
    private final TextSerializer textSerializer = new TextSerializer();

    public BinarySerializer() {
        this(true);
    }

    public BinarySerializer(boolean keyWithIdPrefix) {
        this.keyWithIdPrefix = keyWithIdPrefix;
    }

    @Override
    public BinaryBackendEntry newBackendEntry(HugeType type, Id id) {
        BytesBuffer buffer = BytesBuffer.allocate(1 + id.length());
        BinaryBackendEntry.BinaryId bid = new BinaryBackendEntry.BinaryId(buffer.writeId(id).bytes(), id);
        return new BinaryBackendEntry(type, bid);
    }

    private BinaryBackendEntry newBackendEntry(HugeVertex vertex) {
        return this.newBackendEntry(vertex.type(), vertex.id());
    }

    private BinaryBackendEntry newBackendEntry(HugeEdge edge) {
        BinaryBackendEntry.BinaryId id = new BinaryBackendEntry.BinaryId(this.formatEdgeName(edge), edge.idWithDirection());
        return new BinaryBackendEntry(edge.type(), id);
    }

    private BinaryBackendEntry newBackendEntry(SchemaElement elem) {
        return this.newBackendEntry(elem.type(), elem.id());
    }

    @Override
    protected BinaryBackendEntry convertEntry(BackendEntry entry) {
        assert (entry instanceof BinaryBackendEntry);
        return (BinaryBackendEntry)entry;
    }

    protected byte[] formatSyspropName(Id id, HugeKeys col) {
        int idLen = this.keyWithIdPrefix ? 1 + id.length() : 0;
        BytesBuffer buffer = BytesBuffer.allocate(idLen + 1 + 1);
        byte sysprop = HugeType.SYS_PROPERTY.code();
        if (this.keyWithIdPrefix) {
            buffer.writeId(id);
        }
        return buffer.write(sysprop).write(col.code()).bytes();
    }

    protected byte[] formatSyspropName(BinaryBackendEntry.BinaryId id, HugeKeys col) {
        int idLen = this.keyWithIdPrefix ? id.length() : 0;
        BytesBuffer buffer = BytesBuffer.allocate(idLen + 1 + 1);
        byte sysprop = HugeType.SYS_PROPERTY.code();
        if (this.keyWithIdPrefix) {
            buffer.write(id.asBytes());
        }
        return buffer.write(sysprop).write(col.code()).bytes();
    }

    protected BackendEntry.BackendColumn formatLabel(HugeElement elem) {
        BackendEntry.BackendColumn col = new BackendEntry.BackendColumn();
        col.name = this.formatSyspropName(elem.id(), HugeKeys.LABEL);
        Id label = elem.schemaLabel().id();
        BytesBuffer buffer = BytesBuffer.allocate(label.length() + 1);
        col.value = buffer.writeId(label).bytes();
        return col;
    }

    protected byte[] formatPropertyName(HugeProperty<?> prop) {
        Id id = prop.element().id();
        int idLen = this.keyWithIdPrefix ? 1 + id.length() : 0;
        Id pkeyId = prop.propertyKey().id();
        BytesBuffer buffer = BytesBuffer.allocate(idLen + 2 + pkeyId.length());
        if (this.keyWithIdPrefix) {
            buffer.writeId(id);
        }
        buffer.write(prop.type().code());
        buffer.writeId(pkeyId);
        return buffer.bytes();
    }

    protected BackendEntry.BackendColumn formatProperty(HugeProperty<?> prop) {
        return BackendEntry.BackendColumn.of(this.formatPropertyName(prop), KryoUtil.toKryo(prop.value()));
    }

    protected void parseProperty(Id pkeyId, byte[] val, HugeElement owner) {
        PropertyKey pkey = owner.graph().propertyKey(pkeyId);
        Object value = KryoUtil.fromKryo(val, pkey.clazz());
        if (pkey.cardinality() == Cardinality.SINGLE) {
            owner.addProperty(pkey, value);
        } else {
            if (!(value instanceof Collection)) {
                throw new BackendException("Invalid value of non-single property: %s", value);
            }
            for (Object v : (Collection)value) {
                owner.addProperty(pkey, v);
            }
        }
    }

    protected byte[] formatEdgeName(HugeEdge edge) {
        BytesBuffer buffer = BytesBuffer.allocate(256);
        buffer.writeId(edge.ownerVertex().id());
        buffer.write(edge.type().code());
        buffer.writeId(edge.schemaLabel().id());
        buffer.writeString(edge.name());
        buffer.writeId(edge.otherVertex().id());
        return buffer.bytes();
    }

    protected byte[] formatEdgeValue(HugeEdge edge) {
        int propsCount = edge.getProperties().size();
        BytesBuffer buffer = BytesBuffer.allocate(4 + 16 * propsCount);
        buffer.writeInt(propsCount);
        for (HugeProperty<?> property : edge.getProperties().values()) {
            buffer.writeId(property.propertyKey().id());
            buffer.writeBytes(KryoUtil.toKryo(property.value()));
        }
        return buffer.bytes();
    }

    protected BackendEntry.BackendColumn formatEdge(HugeEdge edge) {
        byte[] name = this.keyWithIdPrefix ? this.formatEdgeName(edge) : EMPTY_BYTES;
        return BackendEntry.BackendColumn.of(name, this.formatEdgeValue(edge));
    }

    protected void parseEdge(BackendEntry.BackendColumn col, HugeVertex vertex, HugeGraph graph) {
        HugeVertex otherVertex;
        BytesBuffer buffer = BytesBuffer.wrap(col.name);
        if (this.keyWithIdPrefix) {
            buffer.readId();
        }
        byte type = buffer.read();
        Id labelId = buffer.readId();
        String sk = buffer.readString();
        Id otherVertexId = buffer.readId();
        boolean isOutEdge = type == HugeType.EDGE_OUT.code();
        EdgeLabel edgeLabel = graph.edgeLabel(labelId);
        VertexLabel srcLabel = graph.vertexLabel(edgeLabel.sourceLabel());
        VertexLabel tgtLabel = graph.vertexLabel(edgeLabel.targetLabel());
        if (isOutEdge) {
            vertex.vertexLabel(srcLabel);
            otherVertex = new HugeVertex(graph, otherVertexId, tgtLabel);
        } else {
            vertex.vertexLabel(tgtLabel);
            otherVertex = new HugeVertex(graph, otherVertexId, srcLabel);
        }
        HugeEdge edge = new HugeEdge(graph, null, edgeLabel);
        edge.name(sk);
        if (isOutEdge) {
            edge.vertices(vertex, vertex, otherVertex);
            edge.assignId();
            vertex.addOutEdge(edge);
            otherVertex.addInEdge(edge.switchOwner());
        } else {
            edge.vertices(vertex, otherVertex, vertex);
            edge.assignId();
            vertex.addInEdge(edge);
            otherVertex.addOutEdge(edge.switchOwner());
        }
        vertex.propNotLoaded();
        otherVertex.propNotLoaded();
        buffer = BytesBuffer.wrap(col.value);
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.parseProperty(buffer.readId(), buffer.readBytes(), edge);
        }
    }

    protected void parseColumn(BackendEntry.BackendColumn col, HugeVertex vertex) {
        BytesBuffer buffer = BytesBuffer.wrap(col.name);
        Id id = this.keyWithIdPrefix ? buffer.readId() : vertex.id();
        E.checkState((buffer.remaining() > 0 ? 1 : 0) != 0, (String)"Missing column type", (Object[])new Object[0]);
        byte type = buffer.read();
        if (type == HugeType.PROPERTY.code()) {
            Id pkeyId = buffer.readId();
            this.parseProperty(pkeyId, col.value, vertex);
        } else if (type == HugeType.EDGE_IN.code() || type == HugeType.EDGE_OUT.code()) {
            this.parseEdge(col, vertex, vertex.graph());
        } else if (type != HugeType.SYS_PROPERTY.code()) {
            E.checkState((boolean)false, (String)"Invalid entry(%s) with unknown type(%s): 0x%s", (Object[])new Object[]{id, type & 0xFF, Bytes.toHex((byte[])col.name)});
        }
    }

    protected byte[] formatIndexName(HugeIndex index) {
        Id indexId = index.id();
        if (BinarySerializer.indexIdLengthExceedLimit(indexId)) {
            indexId = index.hashId();
        }
        Id elemId = index.elementId();
        BytesBuffer buffer = BytesBuffer.allocate(1 + indexId.length() + 1 + elemId.length());
        buffer.writeId(indexId);
        buffer.writeId(elemId, true);
        return buffer.bytes();
    }

    protected void parseIndexName(BinaryBackendEntry entry, HugeIndex index, Object fieldValues) {
        for (BackendEntry.BackendColumn col : entry.columns()) {
            if (BinarySerializer.indexFieldValuesUnmatched(col.value, fieldValues)) continue;
            BytesBuffer buffer = BytesBuffer.wrap(col.name);
            buffer.readId();
            index.elementIds(buffer.readId(true));
        }
    }

    @Override
    public BackendEntry writeVertex(HugeVertex vertex) {
        BinaryBackendEntry entry = this.newBackendEntry(vertex);
        if (vertex.removed()) {
            return entry;
        }
        entry.column(this.formatLabel(vertex));
        for (HugeProperty<?> prop : vertex.getProperties().values()) {
            entry.column(this.formatProperty(prop));
        }
        return entry;
    }

    @Override
    public BackendEntry writeVertexProperty(HugeVertexProperty<?> prop) {
        BinaryBackendEntry entry = this.newBackendEntry(prop.element());
        entry.column(this.formatProperty(prop));
        entry.subId(IdGenerator.of(prop.key()));
        return entry;
    }

    @Override
    public HugeVertex readVertex(HugeGraph graph, BackendEntry bytesEntry) {
        if (bytesEntry == null) {
            return null;
        }
        BinaryBackendEntry entry = this.convertEntry(bytesEntry);
        byte[] VL = this.formatSyspropName(entry.id(), HugeKeys.LABEL);
        BackendEntry.BackendColumn vl = entry.column(VL);
        VertexLabel label = VertexLabel.NONE;
        if (vl != null) {
            label = graph.vertexLabel(BytesBuffer.wrap(vl.value).readId());
        }
        Id id = entry.id().origin();
        HugeVertex vertex = new HugeVertex(graph, id, label);
        for (BackendEntry.BackendColumn col : entry.columns()) {
            this.parseColumn(col, vertex);
        }
        return vertex;
    }

    @Override
    public BackendEntry writeEdge(HugeEdge edge) {
        BinaryBackendEntry entry = this.newBackendEntry(edge);
        entry.column(this.formatEdge(edge));
        return entry;
    }

    @Override
    public BackendEntry writeEdgeProperty(HugeEdgeProperty<?> prop) {
        throw new NotImplementedException("Unsupported writeEdgeProperty()");
    }

    @Override
    public HugeEdge readEdge(HugeGraph graph, BackendEntry entry) {
        throw new NotImplementedException("Unsupported readEdge()");
    }

    @Override
    public BackendEntry writeIndex(HugeIndex index) {
        BinaryBackendEntry entry;
        if (index.fieldValues() == null && index.elementIds().size() == 0) {
            entry = this.formatILDeletion(index);
        } else {
            Id id = index.id();
            byte[] value = null;
            if (!index.type().isRangeIndex() && BinarySerializer.indexIdLengthExceedLimit(id)) {
                id = index.hashId();
                value = StringEncoding.encode(index.fieldValues().toString());
            }
            entry = this.newBackendEntry(index.type(), id);
            entry.column(this.formatIndexName(index), value);
            entry.subId(index.elementId());
        }
        return entry;
    }

    @Override
    public HugeIndex readIndex(HugeGraph graph, ConditionQuery query, BackendEntry bytesEntry) {
        if (bytesEntry == null) {
            return null;
        }
        BinaryBackendEntry entry = this.convertEntry(bytesEntry);
        byte[] bytes = entry.id().asBytes(1);
        HugeIndex index = HugeIndex.parseIndexId(graph, entry.type(), bytes);
        Object fieldValues = null;
        if (!index.type().isRangeIndex()) {
            fieldValues = query.condition((Object)HugeKeys.FIELD_VALUES);
            if (!index.fieldValues().equals(fieldValues)) {
                index.fieldValues(fieldValues);
            }
        }
        this.parseIndexName(entry, index, fieldValues);
        return index;
    }

    @Override
    public BackendEntry writeId(HugeType type, Id id) {
        return this.newBackendEntry(type, id);
    }

    @Override
    protected Id writeQueryId(HugeType type, Id id) {
        if (type.isEdge()) {
            id = BinarySerializer.writeEdgeId(id);
        } else {
            BytesBuffer buffer = BytesBuffer.allocate(1 + id.length());
            id = new BinaryBackendEntry.BinaryId(buffer.writeId(id).bytes(), id);
        }
        return id;
    }

    @Override
    protected Id writeQueryEdgeCondition(Query query) {
        int count = 0;
        BytesBuffer buffer = BytesBuffer.allocate(256);
        for (HugeKeys key : EdgeId.KEYS) {
            Object value = ((ConditionQuery)query).condition((Object)key);
            if (value != null) {
                ++count;
            } else {
                if (key != HugeKeys.DIRECTION) break;
                value = Directions.OUT;
            }
            if (key == HugeKeys.OWNER_VERTEX || key == HugeKeys.OTHER_VERTEX) {
                Id id = HugeVertex.getIdValue(value);
                buffer.writeId(id);
                continue;
            }
            if (key == HugeKeys.DIRECTION) {
                byte t = ((Directions)value).type().code();
                buffer.write(t);
                continue;
            }
            if (key == HugeKeys.LABEL) {
                assert (value instanceof Id);
                buffer.writeId((Id)value);
                continue;
            }
            if (key == HugeKeys.SORT_VALUES) {
                assert (value instanceof String);
                buffer.writeString((String)value);
                continue;
            }
            assert (false) : key;
        }
        if (count > 0) {
            assert (count == query.conditions().size());
            return new BinaryBackendEntry.BinaryId(buffer.bytes(), null);
        }
        return null;
    }

    @Override
    protected Query writeQueryCondition(Query query) {
        HugeType type = query.resultType();
        if (!type.isIndex()) {
            return query;
        }
        ConditionQuery cq = (ConditionQuery)query;
        if (type.isStringIndex()) {
            return this.writeStringIndexQuery(cq);
        }
        if (type.isRangeIndex()) {
            return this.writeRangeIndexQuery(cq);
        }
        E.checkState((boolean)false, (String)"Unsupported index query: %s", (Object[])new Object[]{type});
        return null;
    }

    private BinaryBackendEntry formatILDeletion(HugeIndex index) {
        Id id = index.indexLabel();
        BinaryBackendEntry entry = this.newBackendEntry(index.type(), id);
        switch (index.type()) {
            case SECONDARY_INDEX: 
            case SEARCH_INDEX: {
                String idString = id.asString();
                int idLength = idString.length();
                for (int i = idLength - 1; i < 128; ++i) {
                    BytesBuffer buffer = BytesBuffer.allocate(idLength + 1);
                    buffer.writeUInt8(i | 0x80);
                    buffer.write(IdGenerator.of(idString).asBytes());
                    entry.column(buffer.bytes(), null);
                }
                break;
            }
            case RANGE_INDEX: {
                int il = (int)id.asLong();
                for (int i = 0; i < 4; ++i) {
                    int length = (int)Math.pow(2.0, i) + 4;
                    BytesBuffer buffer = BytesBuffer.allocate(5);
                    buffer.writeUInt8(--length | 0x80);
                    buffer.writeInt(il);
                    entry.column(buffer.bytes(), null);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Index type must be Secondary or Range, but got '%s'", index.type()));
            }
        }
        return entry;
    }

    private Query writeStringIndexQuery(ConditionQuery query) {
        E.checkArgument((query.allSysprop() && query.conditions().size() == 2 ? 1 : 0) != 0, (String)"There should be two conditions: INDEX_LABEL_ID and FIELD_VALUESin secondary index query", (Object[])new Object[0]);
        Id index = (Id)query.condition((Object)HugeKeys.INDEX_LABEL_ID);
        Object key = query.condition((Object)HugeKeys.FIELD_VALUES);
        E.checkArgument((index != null ? 1 : 0) != 0, (String)"Please specify the index label", (Object[])new Object[0]);
        E.checkArgument((key != null ? 1 : 0) != 0, (String)"Please specify the index key", (Object[])new Object[0]);
        BinaryBackendEntry.BinaryId id = BinarySerializer.formatIndexId(query.resultType(), index, key);
        IdQuery idQuery = new IdQuery((Query)query, (Id)id);
        idQuery.limit(query.limit());
        idQuery.offset(query.offset());
        return idQuery;
    }

    private Query writeRangeIndexQuery(ConditionQuery query) {
        Id index = (Id)query.condition((Object)HugeKeys.INDEX_LABEL_ID);
        E.checkArgument((index != null ? 1 : 0) != 0, (String)"Please specify the index label", (Object[])new Object[0]);
        List<Condition> fields = query.syspropConditions(HugeKeys.FIELD_VALUES);
        E.checkArgument((!fields.isEmpty() ? 1 : 0) != 0, (String)"Please specify the index field values", (Object[])new Object[0]);
        Object keyEq = null;
        Object keyMin = null;
        boolean keyMinEq = false;
        Object keyMax = null;
        boolean keyMaxEq = false;
        block7: for (Condition c : fields) {
            Condition.Relation r = (Condition.Relation)c;
            switch (r.relation()) {
                case EQ: {
                    keyEq = r.value();
                    continue block7;
                }
                case GTE: {
                    keyMinEq = true;
                }
                case GT: {
                    keyMin = r.value();
                    continue block7;
                }
                case LTE: {
                    keyMaxEq = true;
                }
                case LT: {
                    keyMax = r.value();
                    continue block7;
                }
            }
            E.checkArgument((boolean)false, (String)"Unsupported relation '%s'", (Object[])new Object[]{r.relation()});
        }
        HugeType type = query.resultType();
        if (keyEq != null) {
            BinaryBackendEntry.BinaryId id = BinarySerializer.formatIndexId(type, index, keyEq);
            IdQuery idQuery = new IdQuery((Query)query, (Id)id);
            idQuery.limit(query.limit());
            idQuery.offset(query.offset());
            return idQuery;
        }
        if (keyMin == null) {
            E.checkArgument((keyMax != null ? 1 : 0) != 0, (String)"Please specify at least one condition", (Object[])new Object[0]);
            keyMin = StringUtil.valueOf(keyMax.getClass(), "0");
            keyMinEq = true;
        }
        query = query.copy();
        query.resetConditions();
        BinaryBackendEntry.BinaryId min = BinarySerializer.formatIndexId(type, index, keyMin);
        if (keyMinEq) {
            query.gte(HugeKeys.ID, min);
        } else {
            query.gt(HugeKeys.ID, min);
        }
        if (keyMax == null) {
            BinaryBackendEntry.BinaryId prefix = BinarySerializer.formatIndexId(type, index, null);
            prefix.asBytes()[0] = min.asBytes()[0];
            query.prefix(HugeKeys.ID, prefix);
        } else {
            BinaryBackendEntry.BinaryId max = BinarySerializer.formatIndexId(type, index, keyMax);
            if (keyMaxEq) {
                query.lte(HugeKeys.ID, max);
            } else {
                query.lt(HugeKeys.ID, max);
            }
        }
        return query;
    }

    private static BinaryBackendEntry.BinaryId writeEdgeId(Id id) {
        EdgeId edgeId = id instanceof EdgeId ? (EdgeId)id : EdgeId.parse(id.asString());
        BytesBuffer buffer = BytesBuffer.allocate(256);
        buffer.writeId(edgeId.ownerVertexId());
        buffer.write(edgeId.direction().type().code());
        buffer.writeId(edgeId.edgeLabelId());
        buffer.writeString(edgeId.sortValues());
        buffer.writeId(edgeId.otherVertexId());
        return new BinaryBackendEntry.BinaryId(buffer.bytes(), id);
    }

    protected static BinaryBackendEntry.BinaryId formatIndexId(HugeType type, Id indexLabel, Object fieldValues) {
        Id id = HugeIndex.formatIndexId(type, indexLabel, fieldValues);
        if (BinarySerializer.indexIdLengthExceedLimit(id)) {
            id = HugeIndex.formatIndexHashId(type, indexLabel, fieldValues);
        }
        BytesBuffer buffer = BytesBuffer.allocate(1 + id.length());
        return new BinaryBackendEntry.BinaryId(buffer.writeId(id).bytes(), id);
    }

    protected static boolean indexIdLengthExceedLimit(Id id) {
        return id.asBytes().length > 32;
    }

    protected static boolean indexFieldValuesUnmatched(byte[] value, Object fieldValues) {
        return value != null && value.length > 0 && fieldValues != null && !StringEncoding.decode(value).equals(fieldValues);
    }

    private static String splitKeyId(byte[] bytes) {
        BytesBuffer buffer = BytesBuffer.wrap(bytes);
        buffer.readId();
        return buffer.readStringFromRemaining();
    }

    private static byte[] joinIdKey(Id id, String key) {
        int size = 1 + id.length() + key.length();
        BytesBuffer buffer = BytesBuffer.allocate(size);
        buffer.writeId(id);
        buffer.writeStringToRemaining(key);
        return buffer.bytes();
    }

    private BackendEntry text2bin(BackendEntry entry) {
        Id id = IdGenerator.of(entry.id().asLong());
        BinaryBackendEntry bin = this.newBackendEntry(entry.type(), id);
        TextBackendEntry text = (TextBackendEntry)entry;
        for (String name : text.columnNames()) {
            String value = text.column(name);
            bin.column(BinarySerializer.joinIdKey(id, name), StringEncoding.encode(value));
        }
        return bin;
    }

    private BackendEntry bin2text(BackendEntry entry) {
        if (entry == null) {
            return null;
        }
        BinaryBackendEntry bin = (BinaryBackendEntry)entry;
        Id id = IdGenerator.of(bin.id().origin().asString());
        TextBackendEntry text = new TextBackendEntry(null, id);
        for (BackendEntry.BackendColumn col : bin.columns()) {
            String name = BinarySerializer.splitKeyId(col.name);
            String value = StringEncoding.decode(col.value);
            text.column(name, value);
        }
        return text;
    }

    @Override
    public BackendEntry writeVertexLabel(VertexLabel vertexLabel) {
        return this.text2bin(this.textSerializer.writeVertexLabel(vertexLabel));
    }

    @Override
    public VertexLabel readVertexLabel(HugeGraph graph, BackendEntry entry) {
        return this.textSerializer.readVertexLabel(graph, this.bin2text(entry));
    }

    @Override
    public BackendEntry writeEdgeLabel(EdgeLabel edgeLabel) {
        return this.text2bin(this.textSerializer.writeEdgeLabel(edgeLabel));
    }

    @Override
    public EdgeLabel readEdgeLabel(HugeGraph graph, BackendEntry entry) {
        return this.textSerializer.readEdgeLabel(graph, this.bin2text(entry));
    }

    @Override
    public BackendEntry writePropertyKey(PropertyKey propertyKey) {
        return this.text2bin(this.textSerializer.writePropertyKey(propertyKey));
    }

    @Override
    public PropertyKey readPropertyKey(HugeGraph graph, BackendEntry entry) {
        return this.textSerializer.readPropertyKey(graph, this.bin2text(entry));
    }

    @Override
    public BackendEntry writeIndexLabel(IndexLabel indexLabel) {
        return this.text2bin(this.textSerializer.writeIndexLabel(indexLabel));
    }

    @Override
    public IndexLabel readIndexLabel(HugeGraph graph, BackendEntry entry) {
        return this.textSerializer.readIndexLabel(graph, this.bin2text(entry));
    }
}

