/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.serializer;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.serializer.BinaryBackendEntry;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.StringEncoding;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class BytesBuffer {
    public static final int BYTE_LEN = 1;
    public static final int SHORT_LEN = 2;
    public static final int INT_LEN = 4;
    public static final int LONG_LEN = 8;
    public static final int CHAR_LEN = 2;
    public static final int FLOAT_LEN = 4;
    public static final int DOUBLE_LEN = 8;
    public static final int UINT8_MAX = 255;
    public static final int UINT16_MAX = 65535;
    public static final long UINT32_MAX = 0xFFFFFFFFL;
    public static final int ID_MAX_LEN = 128;
    public static final int BIG_ID_MAX_LEN = 32768;
    public static final int INDEX_ID_MAX_LENGTH = 32;
    public static final int DEFAULT_CAPACITY = 64;
    public static final int MAX_BUFFER_CAPACITY = 0x8000000;
    private ByteBuffer buffer;

    public BytesBuffer() {
        this(64);
    }

    public BytesBuffer(int capacity) {
        E.checkArgument((capacity <= 0x8000000 ? 1 : 0) != 0, (String)"Capacity exceeds max buffer capacity: %s", (Object[])new Object[]{0x8000000});
        this.buffer = ByteBuffer.allocate(capacity);
    }

    public BytesBuffer(ByteBuffer buffer) {
        E.checkNotNull((Object)buffer, (String)"buffer");
        this.buffer = buffer;
    }

    public static BytesBuffer allocate(int capacity) {
        return new BytesBuffer(capacity);
    }

    public static BytesBuffer wrap(byte[] array) {
        return new BytesBuffer(ByteBuffer.wrap(array));
    }

    public static BytesBuffer wrap(byte[] array, int offset, int length) {
        return new BytesBuffer(ByteBuffer.wrap(array, offset, length));
    }

    public ByteBuffer asByteBuffer() {
        return this.buffer;
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public byte[] bytes() {
        byte[] bytes = this.buffer.array();
        if (this.buffer.position() == bytes.length) {
            return bytes;
        }
        return Arrays.copyOf(bytes, this.buffer.position());
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    private void require(int size) {
        if (this.buffer.capacity() - this.buffer.position() >= size) {
            return;
        }
        int newcapacity = size + this.buffer.capacity() + 64;
        E.checkArgument((newcapacity <= 0x8000000 ? 1 : 0) != 0, (String)"Capacity exceeds max buffer capacity: %s", (Object[])new Object[]{0x8000000});
        ByteBuffer newBuffer = ByteBuffer.allocate(newcapacity);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    public BytesBuffer write(byte val) {
        this.require(1);
        this.buffer.put(val);
        return this;
    }

    public BytesBuffer write(byte[] val) {
        this.require(1 * val.length);
        this.buffer.put(val);
        return this;
    }

    public BytesBuffer writeBoolean(boolean val) {
        return this.write((byte)(val ? 1 : 0));
    }

    public BytesBuffer writeChar(char val) {
        this.require(2);
        this.buffer.putChar(val);
        return this;
    }

    public BytesBuffer writeShort(short val) {
        this.require(2);
        this.buffer.putShort(val);
        return this;
    }

    public BytesBuffer writeInt(int val) {
        this.require(4);
        this.buffer.putInt(val);
        return this;
    }

    public BytesBuffer writeLong(long val) {
        this.require(8);
        this.buffer.putLong(val);
        return this;
    }

    public BytesBuffer writeFloat(float val) {
        this.require(4);
        this.buffer.putFloat(val);
        return this;
    }

    public BytesBuffer writeDouble(double val) {
        this.require(8);
        this.buffer.putDouble(val);
        return this;
    }

    public BytesBuffer writeBytes(byte[] bytes) {
        E.checkArgument((bytes.length <= 65535 ? 1 : 0) != 0, (String)"The max length of bytes is %s, got %s", (Object[])new Object[]{65535, bytes.length});
        this.require(2 + bytes.length);
        this.writeUInt16(bytes.length);
        this.write(bytes);
        return this;
    }

    public BytesBuffer writeString(String val) {
        byte[] bytes = StringEncoding.encode(val);
        this.writeBytes(bytes);
        return this;
    }

    public byte read() {
        return this.buffer.get();
    }

    public byte[] read(int length) {
        byte[] bytes = new byte[length];
        this.buffer.get(bytes);
        return bytes;
    }

    public boolean readBoolean() {
        return this.buffer.get() != 0;
    }

    public char readChar() {
        return this.buffer.getChar();
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public long readLong() {
        return this.buffer.getLong();
    }

    public float readFloat() {
        return this.buffer.getFloat();
    }

    public double readDouble() {
        return this.buffer.getDouble();
    }

    public byte[] readBytes() {
        int length = this.readUInt16();
        byte[] bytes = this.read(length);
        return bytes;
    }

    public String readString() {
        return StringEncoding.decode(this.readBytes());
    }

    public BytesBuffer writeUInt8(int val) {
        assert (val <= 255);
        this.write((byte)val);
        return this;
    }

    public int readUInt8() {
        return this.read() & 0xFF;
    }

    public BytesBuffer writeUInt16(int val) {
        assert (val <= 65535);
        this.writeShort((short)val);
        return this;
    }

    public int readUInt16() {
        return this.readShort() & 0xFFFF;
    }

    public BytesBuffer writeUInt32(long val) {
        assert (val <= 0xFFFFFFFFL);
        this.writeInt((int)val);
        return this;
    }

    public long readUInt32() {
        return this.readInt() & 0xFFFFFFFF;
    }

    public BytesBuffer writeStringToRemaining(String value) {
        byte[] bytes = StringEncoding.encode(value);
        this.write(bytes);
        return this;
    }

    public String readStringFromRemaining() {
        byte[] bytes = new byte[this.buffer.remaining()];
        this.buffer.get(bytes);
        return StringEncoding.decode(bytes);
    }

    public BytesBuffer writeId(Id id) {
        return this.writeId(id, false);
    }

    public BytesBuffer writeId(Id id, boolean big) {
        boolean number = id.number();
        if (number) {
            long value = id.asLong();
            this.writeNumber(value);
        } else {
            byte[] bytes = id.asBytes();
            int len = bytes.length;
            E.checkArgument((len > 0 ? 1 : 0) != 0, (String)"Can't write empty id", (Object[])new Object[0]);
            if (!big) {
                E.checkArgument((len <= 128 ? 1 : 0) != 0, (String)"Id max length is %s, but got %s {%s}", (Object[])new Object[]{128, len, id});
                this.writeUInt8(--len | 0x80);
            } else {
                E.checkArgument((len <= 32768 ? 1 : 0) != 0, (String)"Big id max length is %s, but got %s", (Object[])new Object[]{32768, len});
                int high = --len >> 8;
                int low = len & 0xFF;
                this.writeUInt8(high | 0x80);
                this.writeUInt8(low);
            }
            this.write(bytes);
        }
        return this;
    }

    public Id readId() {
        return this.readId(false);
    }

    public Id readId(boolean big) {
        int b = this.readUInt8();
        boolean number = (b & 0x80) == 0;
        int len = b & 0x7F;
        if (number) {
            return IdGenerator.of(this.readNumber(len));
        }
        if (big) {
            int high = len << 8;
            int low = this.readUInt8();
            len = high + low;
        }
        byte[] id = this.read(len + 1);
        return IdGenerator.of(id, false);
    }

    public BinaryBackendEntry.BinaryId asId() {
        return new BinaryBackendEntry.BinaryId(this.bytes(), null);
    }

    public BinaryBackendEntry.BinaryId parseId() {
        int start = this.buffer.position();
        Id id = this.readId();
        int end = this.buffer.position();
        int len = end - start;
        byte[] bytes = new byte[len];
        System.arraycopy(this.array(), start, bytes, 0, len);
        return new BinaryBackendEntry.BinaryId(bytes, id);
    }

    private void writeNumber(long val) {
        if (-128L <= val && val <= 127L) {
            this.writeUInt8(1);
            this.write((byte)val);
        } else if (-32768L <= val && val <= 32767L) {
            this.writeUInt8(2);
            this.writeShort((short)val);
        } else if (Integer.MIN_VALUE <= val && val <= Integer.MAX_VALUE) {
            this.writeUInt8(4);
            this.writeInt((int)val);
        } else {
            this.writeUInt8(8);
            this.writeLong(val);
        }
    }

    private long readNumber(int len) {
        if (len <= 1) {
            return this.read();
        }
        if (len <= 2) {
            return this.readShort();
        }
        if (len <= 4) {
            return this.readInt();
        }
        assert (len == 8) : len;
        return this.readLong();
    }
}

