/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.serializer;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Cardinality;
import com.baidu.hugegraph.type.define.HugeKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TableBackendEntry
implements BackendEntry {
    private final Row row;
    private final List<Row> subRows;
    private boolean selfChanged = true;

    public TableBackendEntry(Id id) {
        this(null, id);
    }

    public TableBackendEntry(HugeType type) {
        this(type, null);
    }

    public TableBackendEntry(HugeType type, Id id) {
        this(new Row(type, id));
    }

    public TableBackendEntry(Row row) {
        this.row = row;
        this.subRows = new ArrayList<Row>();
        this.selfChanged = true;
    }

    @Override
    public HugeType type() {
        return this.row.type;
    }

    public void type(HugeType type) {
        this.row.type = type;
    }

    @Override
    public Id id() {
        return this.row.id;
    }

    public void id(Id id) {
        this.row.id = id;
    }

    @Override
    public Id subId() {
        return this.row.subId;
    }

    public void subId(Id subId) {
        this.row.subId = subId;
    }

    public void selfChanged(boolean changed) {
        this.selfChanged = changed;
    }

    public boolean selfChanged() {
        return this.selfChanged;
    }

    public Row row() {
        return this.row;
    }

    public Map<HugeKeys, Object> columnsMap() {
        return this.row.columns();
    }

    public <T> void column(HugeKeys key, T value) {
        this.row.column(key, value);
    }

    public <T> void column(HugeKeys key, Object name, T value) {
        this.row.column(key, name, value);
    }

    public <T> void column(HugeKeys key, T value, Cardinality c) {
        this.row.column(key, (Object)value, c);
    }

    public <T> T column(HugeKeys key) {
        return this.row.column(key);
    }

    public void subRow(Row row) {
        this.subRows.add(row);
    }

    public List<Row> subRows() {
        return this.subRows;
    }

    public String toString() {
        return String.format("TableBackendEntry{%s, sub-rows: %s}", this.row.toString(), this.subRows.toString());
    }

    @Override
    public int columnsSize() {
        throw new RuntimeException("Not supported by table backend");
    }

    @Override
    public Collection<BackendEntry.BackendColumn> columns() {
        throw new RuntimeException("Not supported by table backend");
    }

    @Override
    public void columns(Collection<BackendEntry.BackendColumn> bytesColumns) {
        throw new RuntimeException("Not supported by table backend");
    }

    @Override
    public void columns(BackendEntry.BackendColumn ... bytesColumns) {
        throw new RuntimeException("Not supported by table backend");
    }

    @Override
    public void merge(BackendEntry other) {
        throw new RuntimeException("Not supported by table backend");
    }

    @Override
    public void clear() {
        throw new RuntimeException("Not supported by table backend");
    }

    public static class Row {
        private HugeType type;
        private Id id;
        private Id subId;
        private Map<HugeKeys, Object> columns;

        public Row(HugeType type) {
            this(type, null);
        }

        public Row(HugeType type, Id id) {
            this.type = type;
            this.id = id;
            this.subId = null;
            this.columns = new ConcurrentHashMap<HugeKeys, Object>();
        }

        public HugeType type() {
            return this.type;
        }

        public Id id() {
            return this.id;
        }

        public Map<HugeKeys, Object> columns() {
            return this.columns;
        }

        public <T> T column(HugeKeys key) {
            return (T)this.columns.get((Object)key);
        }

        public <T> void column(HugeKeys key, T value) {
            this.columns.put(key, value);
        }

        public <T> void column(HugeKeys key, T value, Cardinality c) {
            switch (c) {
                case SINGLE: {
                    this.column(key, value);
                    break;
                }
                case SET: {
                    this.columns.putIfAbsent(key, new LinkedHashSet());
                    ((Set)this.column(key)).add(value);
                    break;
                }
                case LIST: {
                    this.columns.putIfAbsent(key, new LinkedList());
                    ((List)this.column(key)).add(value);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported cardinality: " + c));
                }
            }
        }

        public <T> void column(HugeKeys key, Object name, T value) {
            this.columns.putIfAbsent(key, new ConcurrentHashMap());
            ((Map)this.column(key)).put(name, value);
        }

        public String toString() {
            return String.format("Row{type=%s, id=%s, columns=%s}", this.type, this.id, this.columns);
        }
    }
}

