/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.serializer;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.JsonUtil;
import com.baidu.hugegraph.util.StringEncoding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TextBackendEntry
implements BackendEntry,
Cloneable {
    public static final String VALUE_SPLITOR = "\u0002";
    private final HugeType type;
    private final Id id;
    private Id subId;
    private Map<String, String> columns;

    public TextBackendEntry(HugeType type, Id id) {
        this.type = type;
        this.id = id;
        this.subId = null;
        this.columns = new ConcurrentHashMap<String, String>();
    }

    @Override
    public HugeType type() {
        return this.type;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Id subId() {
        return this.subId;
    }

    public void subId(Id subId) {
        this.subId = subId;
    }

    public Set<String> columnNames() {
        return this.columns.keySet();
    }

    public void column(HugeKeys column, String value) {
        this.columns.put(column.string(), value);
    }

    public void column(String column, String value) {
        this.columns.put(column, value);
    }

    public String column(HugeKeys column) {
        return this.columns.get(column.string());
    }

    public String column(String column) {
        return this.columns.get(column);
    }

    public boolean contains(String column) {
        return this.columns.containsKey(column);
    }

    public boolean contains(String column, String value) {
        return this.columns.containsKey(column) && this.columns.get(column).equals(value);
    }

    public boolean containsPrefix(String column) {
        for (String c : this.columns.keySet()) {
            if (!c.startsWith(column)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(String value) {
        return this.columns.values().contains(value);
    }

    public Collection<BackendEntry.BackendColumn> columnsWithPrefix(String column) {
        ArrayList<BackendEntry.BackendColumn> list = new ArrayList<BackendEntry.BackendColumn>();
        for (Map.Entry<String, String> e : this.columns.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (!key.startsWith(column)) continue;
            list.add(BackendEntry.BackendColumn.of(StringEncoding.encode(key), StringEncoding.encode(value)));
        }
        return list;
    }

    public void append(TextBackendEntry entry) {
        for (Map.Entry<String, String> col : entry.columns.entrySet()) {
            String newValue = col.getValue();
            String oldValue = this.column(col.getKey());
            if (col.getKey().startsWith(HugeType.PROPERTY.string())) {
                this.columns.put(col.getKey(), col.getValue());
                continue;
            }
            if (!col.getKey().endsWith(HugeKeys.ELEMENT_IDS.string())) continue;
            ArrayList<Object> values = new ArrayList<Object>();
            Object[] oldValues = JsonUtil.fromJson(oldValue, Object[].class);
            Object[] newValues = JsonUtil.fromJson(newValue, Object[].class);
            values.addAll(Arrays.asList(oldValues));
            values.addAll(Arrays.asList(newValues));
            this.column(col.getKey(), JsonUtil.toJson(values));
        }
    }

    public void eliminate(TextBackendEntry entry) {
        for (Map.Entry<String, String> col : entry.columns.entrySet()) {
            String newValue = col.getValue();
            String oldValue = this.column(col.getKey());
            if (col.getKey().startsWith(HugeType.PROPERTY.string()) || col.getKey().startsWith(HugeType.EDGE_OUT.string()) || col.getKey().startsWith(HugeType.EDGE_IN.string())) {
                this.columns.remove(col.getKey());
                continue;
            }
            if (!col.getKey().endsWith(HugeKeys.ELEMENT_IDS.string())) continue;
            ArrayList<Object> values = new ArrayList<Object>();
            Object[] oldValues = JsonUtil.fromJson(oldValue, Object[].class);
            Object[] newValues = JsonUtil.fromJson(newValue, Object[].class);
            values.addAll(Arrays.asList(oldValues));
            values.removeAll(Arrays.asList(newValues));
            this.column(col.getKey(), JsonUtil.toJson(values));
        }
    }

    public String toString() {
        return String.format("%s: %s", this.id, this.columns.toString());
    }

    @Override
    public int columnsSize() {
        return this.columns.size();
    }

    @Override
    public Collection<BackendEntry.BackendColumn> columns() {
        ArrayList<BackendEntry.BackendColumn> list = new ArrayList<BackendEntry.BackendColumn>(this.columns.size());
        for (Map.Entry<String, String> column : this.columns.entrySet()) {
            BackendEntry.BackendColumn bytesColumn = new BackendEntry.BackendColumn();
            bytesColumn.name = StringEncoding.encode(column.getKey());
            bytesColumn.value = StringEncoding.encode(column.getValue());
            list.add(bytesColumn);
        }
        return list;
    }

    @Override
    public void columns(Collection<BackendEntry.BackendColumn> bytesColumns) {
        for (BackendEntry.BackendColumn column : bytesColumns) {
            this.columns.put(StringEncoding.decode(column.name), StringEncoding.decode(column.value));
        }
    }

    @Override
    public void columns(BackendEntry.BackendColumn ... bytesColumns) {
        for (BackendEntry.BackendColumn column : bytesColumns) {
            this.columns.put(StringEncoding.decode(column.name), StringEncoding.decode(column.value));
        }
    }

    @Override
    public void merge(BackendEntry other) {
        TextBackendEntry text = (TextBackendEntry)other;
        this.columns.putAll(text.columns);
    }

    @Override
    public void clear() {
        this.columns.clear();
    }

    public TextBackendEntry copy() {
        try {
            TextBackendEntry clone = (TextBackendEntry)this.clone();
            clone.columns = new ConcurrentHashMap<String, String>(this.columns);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new BackendException(e);
        }
    }

    public TextBackendEntry copyLast(int count) {
        TextBackendEntry clone;
        try {
            clone = (TextBackendEntry)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BackendException(e);
        }
        clone.columns = new ConcurrentHashMap<String, String>();
        Iterator<Map.Entry<String, String>> it = this.columns.entrySet().iterator();
        int skip = this.columns.size() - count;
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (i >= skip) {
                clone.columns.put(entry.getKey(), entry.getValue());
            }
            ++i;
        }
        return clone;
    }

    public TextBackendEntry copyHead(int count) {
        TextBackendEntry clone;
        try {
            clone = (TextBackendEntry)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BackendException(e);
        }
        clone.columns = new ConcurrentHashMap<String, String>();
        Iterator<Map.Entry<String, String>> it = this.columns.entrySet().iterator();
        for (int i = 0; it.hasNext() && i < count; ++i) {
            Map.Entry<String, String> entry = it.next();
            clone.columns.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextBackendEntry)) {
            return false;
        }
        TextBackendEntry other = (TextBackendEntry)obj;
        if (this.id() != other.id() && !this.id().equals(other.id())) {
            return false;
        }
        if (this.columns().size() != other.columns().size()) {
            return false;
        }
        for (Map.Entry<String, String> e : this.columns.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            String otherValue = other.columns.get(key);
            if (otherValue == null) {
                return false;
            }
            if (value.equals(otherValue)) continue;
            return false;
        }
        return true;
    }
}

