/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.serializer;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.id.IdUtil;
import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.serializer.AbstractSerializer;
import com.baidu.hugegraph.backend.serializer.TextBackendEntry;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeEdgeProperty;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.structure.HugeIndex;
import com.baidu.hugegraph.structure.HugeProperty;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.structure.HugeVertexProperty;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Cardinality;
import com.baidu.hugegraph.type.define.DataType;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.Frequency;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.type.define.IdStrategy;
import com.baidu.hugegraph.type.define.IndexType;
import com.baidu.hugegraph.type.define.SchemaStatus;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;

public class TextSerializer
extends AbstractSerializer {
    private static final String VALUE_SPLITOR = "\u0002";

    @Override
    public TextBackendEntry newBackendEntry(HugeType type, Id id) {
        return new TextBackendEntry(type, id);
    }

    private TextBackendEntry newBackendEntry(HugeElement elem) {
        Id id = IdGenerator.of(TextSerializer.writeEntryId(elem.id()));
        return new TextBackendEntry(elem.type(), id);
    }

    private TextBackendEntry newBackendEntry(SchemaElement elem) {
        Id id = IdGenerator.of(TextSerializer.writeId(elem.id()));
        return new TextBackendEntry(elem.type(), id);
    }

    @Override
    protected TextBackendEntry convertEntry(BackendEntry backendEntry) {
        if (!(backendEntry instanceof TextBackendEntry)) {
            throw new HugeException("The entry '%s' is not TextBackendEntry", backendEntry);
        }
        return (TextBackendEntry)backendEntry;
    }

    private String formatSyspropName(String name) {
        return SplicingIdGenerator.concat(TextSerializer.writeType(HugeType.SYS_PROPERTY), name);
    }

    private String formatSyspropName(HugeKeys col) {
        return this.formatSyspropName(col.string());
    }

    private String formatPropertyName(String key) {
        return SplicingIdGenerator.concat(TextSerializer.writeType(HugeType.PROPERTY), key);
    }

    private String formatPropertyName(HugeProperty<?> prop) {
        return this.formatPropertyName(TextSerializer.writeId(prop.propertyKey().id()));
    }

    private String formatPropertyValue(HugeProperty<?> prop) {
        return JsonUtil.toJson(prop.value());
    }

    private void parseProperty(String colName, String colValue, HugeElement owner) {
        String[] colParts = SplicingIdGenerator.split(colName);
        assert (colParts.length == 2) : colName;
        PropertyKey pkey = owner.graph().propertyKey(TextSerializer.readId(colParts[1]));
        Object value = JsonUtil.fromJson(colValue, pkey.clazz());
        if (pkey.cardinality() == Cardinality.SINGLE) {
            owner.addProperty(pkey, value);
        } else {
            if (!(value instanceof Collection)) {
                throw new BackendException("Invalid value of non-sigle property: %s", colValue);
            }
            for (Object v : (Collection)value) {
                v = JsonUtil.castNumber(v, pkey.dataType().clazz());
                owner.addProperty(pkey, v);
            }
        }
    }

    private String formatEdgeName(HugeEdge edge) {
        return this.writeEdgeId(edge.idWithDirection(), false);
    }

    private String formatEdgeValue(HugeEdge edge) {
        StringBuilder sb = new StringBuilder(256 * edge.getProperties().size());
        sb.append(edge.id().asString());
        for (HugeProperty<?> property : edge.getProperties().values()) {
            sb.append(VALUE_SPLITOR);
            sb.append(this.formatPropertyName(property));
            sb.append(VALUE_SPLITOR);
            sb.append(this.formatPropertyValue(property));
        }
        return sb.toString();
    }

    private void parseEdge(String colName, String colValue, HugeVertex vertex) {
        HugeVertex otherVertex;
        String[] colParts = EdgeId.split(colName);
        HugeGraph graph = vertex.graph();
        EdgeLabel label = graph.edgeLabel(TextSerializer.readId(colParts[1]));
        VertexLabel sourceLabel = graph.vertexLabel(label.sourceLabel());
        VertexLabel targetLabel = graph.vertexLabel(label.targetLabel());
        Id otherVertexId = TextSerializer.readEntryId(colParts[3]);
        boolean isOutEdge = colParts[0].equals(TextSerializer.writeType(HugeType.EDGE_OUT));
        if (isOutEdge) {
            vertex.vertexLabel(sourceLabel);
            otherVertex = new HugeVertex(graph, otherVertexId, targetLabel);
        } else {
            vertex.vertexLabel(targetLabel);
            otherVertex = new HugeVertex(graph, otherVertexId, sourceLabel);
        }
        HugeEdge edge = new HugeEdge(graph, null, label);
        edge.name(colParts[2]);
        if (isOutEdge) {
            edge.vertices(vertex, vertex, otherVertex);
            edge.assignId();
            vertex.addOutEdge(edge);
            otherVertex.addInEdge(edge.switchOwner());
        } else {
            edge.vertices(vertex, otherVertex, vertex);
            edge.assignId();
            vertex.addInEdge(edge);
            otherVertex.addOutEdge(edge.switchOwner());
        }
        vertex.propNotLoaded();
        otherVertex.propNotLoaded();
        String[] valParts = colValue.split(VALUE_SPLITOR);
        for (int i = 1; i < valParts.length; i += 2) {
            this.parseProperty(valParts[i], valParts[i + 1], edge);
        }
    }

    private void parseColumn(String colName, String colValue, HugeVertex vertex) {
        String type = SplicingIdGenerator.split(colName)[0];
        if (type.equals(TextSerializer.writeType(HugeType.PROPERTY))) {
            this.parseProperty(colName, colValue, vertex);
        } else if (type.equals(TextSerializer.writeType(HugeType.EDGE_OUT)) || type.equals(TextSerializer.writeType(HugeType.EDGE_IN))) {
            this.parseEdge(colName, colValue, vertex);
        } else if (!type.equals(TextSerializer.writeType(HugeType.SYS_PROPERTY))) {
            E.checkState((boolean)false, (String)"Invalid entry with unknown type(%s): %s", (Object[])new Object[]{type, colName});
        }
    }

    @Override
    public BackendEntry writeVertex(HugeVertex vertex) {
        TextBackendEntry entry = this.newBackendEntry(vertex);
        if (vertex.schemaLabel() != null) {
            entry.column(this.formatSyspropName(HugeKeys.LABEL), TextSerializer.writeId(vertex.schemaLabel().id()));
        }
        for (HugeProperty<?> prop : vertex.getProperties().values()) {
            entry.column(this.formatPropertyName(prop), this.formatPropertyValue(prop));
        }
        return entry;
    }

    @Override
    public BackendEntry writeVertexProperty(HugeVertexProperty<?> prop) {
        HugeVertex vertex = prop.element();
        TextBackendEntry entry = this.newBackendEntry(vertex);
        entry.subId(IdGenerator.of(prop.key()));
        if (vertex.schemaLabel() != null) {
            entry.column(this.formatSyspropName(HugeKeys.LABEL), TextSerializer.writeId(vertex.schemaLabel().id()));
        }
        entry.column(this.formatPropertyName(prop), this.formatPropertyValue(prop));
        return entry;
    }

    @Override
    public HugeVertex readVertex(HugeGraph graph, BackendEntry backendEntry) {
        E.checkNotNull((Object)graph, (String)"serializer graph");
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        String labelId = entry.column(this.formatSyspropName(HugeKeys.LABEL));
        VertexLabel label = VertexLabel.NONE;
        if (labelId != null) {
            label = graph.vertexLabel(TextSerializer.readId(labelId));
        }
        Id id = IdUtil.readString(entry.id().asString());
        HugeVertex vertex = new HugeVertex(graph, id, label);
        for (String name : entry.columnNames()) {
            this.parseColumn(name, entry.column(name), vertex);
        }
        return vertex;
    }

    @Override
    public BackendEntry writeEdge(HugeEdge edge) {
        Id id = IdGenerator.of(edge.idWithDirection().asString());
        TextBackendEntry entry = this.newBackendEntry(edge.type(), id);
        entry.column(this.formatEdgeName(edge), this.formatEdgeValue(edge));
        return entry;
    }

    @Override
    public BackendEntry writeEdgeProperty(HugeEdgeProperty<?> prop) {
        HugeEdge edge = prop.element();
        Id id = IdGenerator.of(edge.idWithDirection().asString());
        TextBackendEntry entry = this.newBackendEntry(edge.type(), id);
        entry.subId(IdGenerator.of(prop.key()));
        entry.column(this.formatEdgeName(edge), this.formatEdgeValue(edge));
        return entry;
    }

    @Override
    public HugeEdge readEdge(HugeGraph graph, BackendEntry backendEntry) {
        E.checkNotNull((Object)graph, (String)"serializer graph");
        throw new NotImplementedException("Unsupported readEdge()");
    }

    @Override
    public BackendEntry writeIndex(HugeIndex index) {
        TextBackendEntry entry = this.newBackendEntry(index.type(), index.id());
        if (index.fieldValues() == null && index.elementIds().size() == 0) {
            entry.column(this.formatSyspropName(HugeKeys.INDEX_LABEL_ID), TextSerializer.writeId(index.indexLabel()));
        } else {
            entry.column(this.formatSyspropName(HugeKeys.FIELD_VALUES), JsonUtil.toJson(index.fieldValues()));
            entry.column(this.formatSyspropName(HugeKeys.INDEX_LABEL_ID), TextSerializer.writeId(index.indexLabel()));
            entry.column(this.formatSyspropName(HugeKeys.ELEMENT_IDS), TextSerializer.writeIds(index.elementIds()));
            entry.subId(index.elementId());
        }
        return entry;
    }

    @Override
    public HugeIndex readIndex(HugeGraph graph, ConditionQuery query, BackendEntry backendEntry) {
        E.checkNotNull((Object)graph, (String)"serializer graph");
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        String indexValues = entry.column(this.formatSyspropName(HugeKeys.FIELD_VALUES));
        String indexLabelId = entry.column(this.formatSyspropName(HugeKeys.INDEX_LABEL_ID));
        String elementIds = entry.column(this.formatSyspropName(HugeKeys.ELEMENT_IDS));
        IndexLabel indexLabel = IndexLabel.label(graph, TextSerializer.readId(indexLabelId));
        HugeIndex index = new HugeIndex(indexLabel);
        index.fieldValues(JsonUtil.fromJson(indexValues, Object.class));
        index.elementIds(TextSerializer.readIds(elementIds));
        return index;
    }

    @Override
    public TextBackendEntry writeId(HugeType type, Id id) {
        id = this.writeQueryId(type, id);
        return this.newBackendEntry(type, id);
    }

    @Override
    protected Id writeQueryId(HugeType type, Id id) {
        if (type.isEdge()) {
            id = IdGenerator.of(this.writeEdgeId(id, true));
        } else if (type.isGraph()) {
            id = IdGenerator.of(TextSerializer.writeEntryId(id));
        } else {
            assert (type.isSchema());
            id = IdGenerator.of(TextSerializer.writeId(id));
        }
        return id;
    }

    @Override
    protected Id writeQueryEdgeCondition(Query query) {
        HugeKeys key;
        Object value;
        ArrayList<String> condParts = new ArrayList<String>(query.conditions().size());
        HugeKeys[] hugeKeysArray = EdgeId.KEYS;
        int n = hugeKeysArray.length;
        for (int i = 0; i < n && (value = ((ConditionQuery)query).condition((Object)(key = hugeKeysArray[i]))) != null; ++i) {
            if (key == HugeKeys.OWNER_VERTEX || key == HugeKeys.OTHER_VERTEX) {
                condParts.add(TextSerializer.writeEntryId((Id)value));
                continue;
            }
            if (key == HugeKeys.DIRECTION) {
                condParts.add(TextSerializer.writeType(((Directions)value).type()));
                continue;
            }
            if (key == HugeKeys.LABEL) {
                condParts.add(TextSerializer.writeId((Id)value));
                continue;
            }
            condParts.add(value.toString());
        }
        if (condParts.size() > 0) {
            String id = EdgeId.concat(condParts.toArray(new String[0]));
            return IdGenerator.of(id);
        }
        return null;
    }

    @Override
    protected Query writeQueryCondition(Query query) {
        ConditionQuery result = (ConditionQuery)query;
        assert (result.allSysprop());
        for (Condition.Relation r : result.relations()) {
            if (query.resultType().isSchema()) {
                r.serialKey(((HugeKeys)((Object)r.key())).string());
            } else {
                r.serialKey(this.formatSyspropName((HugeKeys)((Object)r.key())));
            }
            if (r.value() instanceof Id) {
                r.serialValue(TextSerializer.writeId((Id)r.value()));
            } else {
                r.serialValue(JsonUtil.toJson(r.value()));
            }
            if (r.relation() != Condition.RelationType.CONTAINS_KEY) continue;
            String key = (String)r.serialValue();
            r.serialValue(this.formatPropertyName(key));
        }
        return result;
    }

    @Override
    public BackendEntry writeVertexLabel(VertexLabel vertexLabel) {
        TextBackendEntry entry = this.newBackendEntry(vertexLabel);
        entry.column(HugeKeys.NAME, JsonUtil.toJson(vertexLabel.name()));
        entry.column(HugeKeys.ID_STRATEGY, JsonUtil.toJson(vertexLabel.idStrategy()));
        entry.column(HugeKeys.PROPERTIES, TextSerializer.writeIds(vertexLabel.properties()));
        entry.column(HugeKeys.PRIMARY_KEYS, TextSerializer.writeIds(vertexLabel.primaryKeys()));
        entry.column(HugeKeys.NULLABLE_KEYS, TextSerializer.writeIds(vertexLabel.nullableKeys()));
        entry.column(HugeKeys.INDEX_LABELS, TextSerializer.writeIds(vertexLabel.indexLabels()));
        entry.column(HugeKeys.ENABLE_LABEL_INDEX, JsonUtil.toJson(vertexLabel.enableLabelIndex()));
        TextSerializer.writeUserdata(vertexLabel, entry);
        entry.column(HugeKeys.STATUS, JsonUtil.toJson(vertexLabel.status()));
        return entry;
    }

    @Override
    public VertexLabel readVertexLabel(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        Id id = TextSerializer.readId(entry.id());
        String name = JsonUtil.fromJson(entry.column(HugeKeys.NAME), String.class);
        String idStrategy = entry.column(HugeKeys.ID_STRATEGY);
        String properties = entry.column(HugeKeys.PROPERTIES);
        String primaryKeys = entry.column(HugeKeys.PRIMARY_KEYS);
        String nullableKeys = entry.column(HugeKeys.NULLABLE_KEYS);
        String indexLabels = entry.column(HugeKeys.INDEX_LABELS);
        String enableLabelIndex = entry.column(HugeKeys.ENABLE_LABEL_INDEX);
        String status = entry.column(HugeKeys.STATUS);
        VertexLabel vertexLabel = new VertexLabel(graph, id, name);
        vertexLabel.idStrategy(JsonUtil.fromJson(idStrategy, IdStrategy.class));
        vertexLabel.properties(TextSerializer.readIds(properties));
        vertexLabel.primaryKeys(TextSerializer.readIds(primaryKeys));
        vertexLabel.nullableKeys(TextSerializer.readIds(nullableKeys));
        vertexLabel.indexLabels(TextSerializer.readIds(indexLabels));
        vertexLabel.enableLabelIndex(JsonUtil.fromJson(enableLabelIndex, Boolean.class));
        TextSerializer.readUserdata(vertexLabel, entry);
        vertexLabel.status(JsonUtil.fromJson(status, SchemaStatus.class));
        return vertexLabel;
    }

    @Override
    public BackendEntry writeEdgeLabel(EdgeLabel edgeLabel) {
        TextBackendEntry entry = this.newBackendEntry(edgeLabel);
        entry.column(HugeKeys.NAME, JsonUtil.toJson(edgeLabel.name()));
        entry.column(HugeKeys.SOURCE_LABEL, TextSerializer.writeId(edgeLabel.sourceLabel()));
        entry.column(HugeKeys.TARGET_LABEL, TextSerializer.writeId(edgeLabel.targetLabel()));
        entry.column(HugeKeys.FREQUENCY, JsonUtil.toJson(edgeLabel.frequency()));
        entry.column(HugeKeys.PROPERTIES, TextSerializer.writeIds(edgeLabel.properties()));
        entry.column(HugeKeys.SORT_KEYS, TextSerializer.writeIds(edgeLabel.sortKeys()));
        entry.column(HugeKeys.NULLABLE_KEYS, TextSerializer.writeIds(edgeLabel.nullableKeys()));
        entry.column(HugeKeys.INDEX_LABELS, TextSerializer.writeIds(edgeLabel.indexLabels()));
        entry.column(HugeKeys.ENABLE_LABEL_INDEX, JsonUtil.toJson(edgeLabel.enableLabelIndex()));
        TextSerializer.writeUserdata(edgeLabel, entry);
        entry.column(HugeKeys.STATUS, JsonUtil.toJson(edgeLabel.status()));
        return entry;
    }

    @Override
    public EdgeLabel readEdgeLabel(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        Id id = TextSerializer.readId(entry.id());
        String name = JsonUtil.fromJson(entry.column(HugeKeys.NAME), String.class);
        String sourceLabel = entry.column(HugeKeys.SOURCE_LABEL);
        String targetLabel = entry.column(HugeKeys.TARGET_LABEL);
        String frequency = entry.column(HugeKeys.FREQUENCY);
        String sortKeys = entry.column(HugeKeys.SORT_KEYS);
        String nullablekeys = entry.column(HugeKeys.NULLABLE_KEYS);
        String properties = entry.column(HugeKeys.PROPERTIES);
        String indexLabels = entry.column(HugeKeys.INDEX_LABELS);
        String enableLabelIndex = entry.column(HugeKeys.ENABLE_LABEL_INDEX);
        String status = entry.column(HugeKeys.STATUS);
        EdgeLabel edgeLabel = new EdgeLabel(graph, id, name);
        edgeLabel.sourceLabel(TextSerializer.readId(sourceLabel));
        edgeLabel.targetLabel(TextSerializer.readId(targetLabel));
        edgeLabel.frequency(JsonUtil.fromJson(frequency, Frequency.class));
        edgeLabel.properties(TextSerializer.readIds(properties));
        edgeLabel.sortKeys(TextSerializer.readIds(sortKeys));
        edgeLabel.nullableKeys(TextSerializer.readIds(nullablekeys));
        edgeLabel.indexLabels(TextSerializer.readIds(indexLabels));
        edgeLabel.enableLabelIndex(JsonUtil.fromJson(enableLabelIndex, Boolean.class));
        TextSerializer.readUserdata(edgeLabel, entry);
        edgeLabel.status(JsonUtil.fromJson(status, SchemaStatus.class));
        return edgeLabel;
    }

    @Override
    public BackendEntry writePropertyKey(PropertyKey propertyKey) {
        TextBackendEntry entry = this.newBackendEntry(propertyKey);
        entry.column(HugeKeys.NAME, JsonUtil.toJson(propertyKey.name()));
        entry.column(HugeKeys.DATA_TYPE, JsonUtil.toJson(propertyKey.dataType()));
        entry.column(HugeKeys.CARDINALITY, JsonUtil.toJson(propertyKey.cardinality()));
        entry.column(HugeKeys.PROPERTIES, TextSerializer.writeIds(propertyKey.properties()));
        TextSerializer.writeUserdata(propertyKey, entry);
        entry.column(HugeKeys.STATUS, JsonUtil.toJson(propertyKey.status()));
        return entry;
    }

    @Override
    public PropertyKey readPropertyKey(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        Id id = TextSerializer.readId(entry.id());
        String name = JsonUtil.fromJson(entry.column(HugeKeys.NAME), String.class);
        String dataType = entry.column(HugeKeys.DATA_TYPE);
        String cardinality = entry.column(HugeKeys.CARDINALITY);
        String properties = entry.column(HugeKeys.PROPERTIES);
        String status = entry.column(HugeKeys.STATUS);
        PropertyKey propertyKey = new PropertyKey(graph, id, name);
        propertyKey.dataType(JsonUtil.fromJson(dataType, DataType.class));
        propertyKey.cardinality(JsonUtil.fromJson(cardinality, Cardinality.class));
        propertyKey.properties(TextSerializer.readIds(properties));
        TextSerializer.readUserdata(propertyKey, entry);
        propertyKey.status(JsonUtil.fromJson(status, SchemaStatus.class));
        return propertyKey;
    }

    @Override
    public BackendEntry writeIndexLabel(IndexLabel indexLabel) {
        TextBackendEntry entry = this.newBackendEntry(indexLabel);
        entry.column(HugeKeys.NAME, JsonUtil.toJson(indexLabel.name()));
        entry.column(HugeKeys.BASE_TYPE, JsonUtil.toJson(indexLabel.baseType()));
        entry.column(HugeKeys.BASE_VALUE, TextSerializer.writeId(indexLabel.baseValue()));
        entry.column(HugeKeys.INDEX_TYPE, JsonUtil.toJson(indexLabel.indexType()));
        entry.column(HugeKeys.FIELDS, TextSerializer.writeIds(indexLabel.indexFields()));
        entry.column(HugeKeys.STATUS, JsonUtil.toJson(indexLabel.status()));
        return entry;
    }

    @Override
    public IndexLabel readIndexLabel(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        Id id = TextSerializer.readId(entry.id());
        String name = JsonUtil.fromJson(entry.column(HugeKeys.NAME), String.class);
        String baseType = entry.column(HugeKeys.BASE_TYPE);
        String baseValue = entry.column(HugeKeys.BASE_VALUE);
        String indexType = entry.column(HugeKeys.INDEX_TYPE);
        String indexFields = entry.column(HugeKeys.FIELDS);
        String status = entry.column(HugeKeys.STATUS);
        IndexLabel indexLabel = new IndexLabel(graph, id, name);
        indexLabel.baseType(JsonUtil.fromJson(baseType, HugeType.class));
        indexLabel.baseValue(TextSerializer.readId(baseValue));
        indexLabel.indexType(JsonUtil.fromJson(indexType, IndexType.class));
        indexLabel.indexFields(TextSerializer.readIds(indexFields));
        indexLabel.status(JsonUtil.fromJson(status, SchemaStatus.class));
        return indexLabel;
    }

    private String writeEdgeId(Id id, boolean withOwnerVertex) {
        EdgeId edgeId = id instanceof EdgeId ? (EdgeId)id : EdgeId.parse(id.asString());
        ArrayList<String> list = new ArrayList<String>(5);
        if (withOwnerVertex) {
            list.add(TextSerializer.writeEntryId(edgeId.ownerVertexId()));
        }
        list.add(TextSerializer.writeType(edgeId.direction().type()));
        list.add(TextSerializer.writeId(edgeId.edgeLabelId()));
        list.add(edgeId.sortValues());
        list.add(TextSerializer.writeEntryId(edgeId.otherVertexId()));
        return EdgeId.concat(list.toArray(new String[0]));
    }

    private static String writeType(HugeType type) {
        return type.string();
    }

    private static String writeEntryId(Id id) {
        return IdUtil.writeString(id);
    }

    private static Id readEntryId(String id) {
        return IdUtil.readString(id);
    }

    private static String writeId(Id id) {
        if (id.number()) {
            return JsonUtil.toJson(id.asLong());
        }
        return JsonUtil.toJson(id.asString());
    }

    private static Id readId(String id) {
        Object value = JsonUtil.fromJson(id, Object.class);
        if (value instanceof Number) {
            return IdGenerator.of(((Number)value).longValue());
        }
        assert (value instanceof String);
        return IdGenerator.of(value.toString());
    }

    private static Id readId(Id id) {
        return TextSerializer.readId(id.asString());
    }

    private static String writeIds(Collection<Id> ids) {
        Object[] array = new Object[ids.size()];
        int i = 0;
        for (Id id : ids) {
            if (id.number()) {
                array[i++] = id.asLong();
                continue;
            }
            array[i++] = id.asString();
        }
        return JsonUtil.toJson(array);
    }

    private static Id[] readIds(String str) {
        Object[] values = JsonUtil.fromJson(str, Object[].class);
        Id[] ids = new Id[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value instanceof Number) {
                ids[i] = IdGenerator.of(((Number)value).longValue());
                continue;
            }
            assert (value instanceof String);
            ids[i] = IdGenerator.of(value.toString());
        }
        return ids;
    }

    private static void writeUserdata(SchemaElement schema, TextBackendEntry entry) {
        entry.column(HugeKeys.USER_DATA, JsonUtil.toJson(schema.userdata()));
    }

    private static void readUserdata(SchemaElement schema, TextBackendEntry entry) {
        String userdataStr = entry.column(HugeKeys.USER_DATA);
        Map userdata = JsonUtil.fromJson(userdataStr, Map.class);
        for (Map.Entry e : userdata.entrySet()) {
            schema.userdata((String)e.getKey(), e.getValue());
        }
    }
}

