/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.StringEncoding;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface BackendEntry {
    public HugeType type();

    public Id id();

    public Id subId();

    public int columnsSize();

    public Collection<BackendColumn> columns();

    public void columns(Collection<BackendColumn> var1);

    public void columns(BackendColumn ... var1);

    public void merge(BackendEntry var1);

    public void clear();

    default public boolean belongToMe(BackendColumn column) {
        return Bytes.prefixWith((byte[])column.name, (byte[])this.id().asBytes());
    }

    public static interface BackendColumnIterator
    extends BackendIterator<BackendColumn> {
        public static BackendColumnIterator empty() {
            return (BackendColumnIterator)EMPTY;
        }
    }

    public static interface BackendIterator<T>
    extends Iterator<T> {
        public static final BackendIterator<?> EMPTY = new BackendIterator<Object>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void close() {
            }

            @Override
            public byte[] position() {
                return null;
            }
        };

        public void close();

        public byte[] position();

        public static <T> BackendIterator<T> empty() {
            return EMPTY;
        }
    }

    public static class BackendColumn
    implements Comparable<BackendColumn> {
        public byte[] name;
        public byte[] value;

        public static BackendColumn of(byte[] name, byte[] value) {
            BackendColumn col = new BackendColumn();
            col.name = name;
            col.value = value;
            return col;
        }

        public String toString() {
            return String.format("%s=%s", StringEncoding.decode(this.name), StringEncoding.decode(this.value));
        }

        @Override
        public int compareTo(BackendColumn other) {
            if (other == null) {
                return 1;
            }
            return Bytes.compare((byte[])this.name, (byte[])other.name);
        }
    }
}

