/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.exception.LimitExceedException;
import com.baidu.hugegraph.exception.NotSupportException;
import com.baidu.hugegraph.iterator.Metadatable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class BackendEntryIterator
implements Iterator<BackendEntry>,
AutoCloseable,
Metadatable {
    protected final Query query;
    protected BackendEntry current;
    private long count;

    public BackendEntryIterator(Query query) {
        this.query = query;
        this.count = 0L;
        this.current = null;
    }

    @Override
    public boolean hasNext() {
        if (this.exceedLimit()) {
            return false;
        }
        if (this.current != null) {
            return true;
        }
        return this.fetch();
    }

    @Override
    public BackendEntry next() {
        BackendEntry current;
        this.checkCapacity();
        if (this.exceedLimit()) {
            throw new NoSuchElementException();
        }
        if (this.current == null) {
            this.fetch();
        }
        if ((current = this.current) == null) {
            throw new NoSuchElementException();
        }
        this.current = null;
        this.count += this.sizeOf(current);
        return current;
    }

    public Object metadata(String meta, Object ... args) {
        if ("page".equals(meta)) {
            return this.pageState();
        }
        throw new NotSupportException("Invalid meta '%s'", meta);
    }

    protected final long count() {
        return this.count;
    }

    protected final long fetched() {
        long ccount = this.current == null ? 0L : this.sizeOf(this.current);
        return this.count + ccount;
    }

    protected final void checkCapacity() throws LimitExceedException {
        this.query.checkCapacity(this.count);
    }

    protected final boolean exceedLimit() {
        return this.query.reachLimit(this.count);
    }

    protected void skipOffset() {
        long offset = this.offset();
        while (this.count < offset && this.fetch()) {
            assert (this.current != null);
            long size = this.sizeOf(this.current);
            this.count += size;
            if (this.count > offset) {
                long skip = size - (this.count - offset);
                this.count -= this.skip(this.current, skip);
                assert (this.count == offset);
                continue;
            }
            this.current = null;
        }
    }

    protected long offset() {
        return this.query.offset();
    }

    protected long sizeOf(BackendEntry entry) {
        return 1L;
    }

    protected long skip(BackendEntry entry, long skip) {
        assert (this.sizeOf(entry) == 1L);
        return this.sizeOf(entry);
    }

    protected abstract boolean fetch();

    protected abstract String pageState();
}

