/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.store.BackendAction;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.iterator.ExtendableIterator;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Action;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BackendMutation {
    private final MutationTable updates = new MutationTable();

    @PerfUtil.Watched(prefix="mutation")
    public void add(BackendEntry entry, Action action) {
        Id id = entry.id();
        assert (id != null);
        if (this.updates.containsKey(entry.type(), id)) {
            this.optimizeUpdates(entry, action);
        } else {
            this.updates.put(entry.type(), id, BackendAction.of(action, entry));
        }
    }

    @PerfUtil.Watched(prefix="mutation")
    private void optimizeUpdates(BackendEntry entry, Action action) {
        Id id = entry.id();
        assert (id != null);
        List<BackendAction> items = this.updates.get(entry.type(), id);
        assert (items != null);
        boolean ignoreCurrent = false;
        Iterator<BackendAction> itor = items.iterator();
        block5: while (itor.hasNext()) {
            BackendAction originItem = itor.next();
            Action originAction = originItem.action();
            switch (action) {
                case INSERT: {
                    itor.remove();
                    break;
                }
                case DELETE: {
                    if (originAction == Action.INSERT) {
                        throw BackendMutation.incompatibleActionException(action, originAction);
                    }
                    if (originAction == Action.DELETE) {
                        ignoreCurrent = true;
                        break;
                    }
                    itor.remove();
                    break;
                }
                case APPEND: 
                case ELIMINATE: {
                    if (originAction == Action.INSERT || originAction == Action.DELETE) {
                        throw BackendMutation.incompatibleActionException(action, originAction);
                    }
                    Id subId = entry.subId();
                    Id originSubId = originItem.entry().subId();
                    assert (subId != null);
                    if (subId != originSubId && !subId.equals(originSubId)) continue block5;
                    itor.remove();
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unknown mutate action: %s", new Object[]{action}));
                }
            }
        }
        if (!ignoreCurrent) {
            items.add(BackendAction.of(action, entry));
        }
    }

    private static HugeException incompatibleActionException(Action newAction, Action originAction) {
        return new HugeException("The action '%s' is incompatible with action '%s'", new Object[]{newAction, originAction});
    }

    public void merge(BackendMutation mutation) {
        E.checkNotNull((Object)mutation, (String)"mutation");
        Iterator<BackendAction> it = mutation.mutation();
        while (it.hasNext()) {
            BackendAction item = it.next();
            this.add(item.entry(), item.action());
        }
    }

    public Set<HugeType> types() {
        return this.updates.keys();
    }

    public Iterator<BackendAction> mutation() {
        return this.updates.values();
    }

    public Iterator<BackendAction> mutation(HugeType type) {
        return this.updates.get(type);
    }

    public List<BackendAction> mutation(HugeType type, Id id) {
        return this.updates.get(type, id);
    }

    public boolean isEmpty() {
        return this.updates.size() == 0;
    }

    public int size() {
        return this.updates.size();
    }

    public String toString() {
        return String.format("BackendMutation{mutations=%s}", this.updates);
    }

    private static class MutationTable {
        private final Map<HugeType, Map<Id, List<BackendAction>>> mutations = InsertionOrderUtil.newMap();

        public void put(HugeType type, Id id, BackendAction mutation) {
            ArrayList<BackendAction> items;
            Map table = this.mutations.get(type);
            if (table == null) {
                table = InsertionOrderUtil.newMap();
                this.mutations.put(type, table);
            }
            if ((items = (ArrayList<BackendAction>)table.get(id)) == null) {
                items = new ArrayList<BackendAction>();
                table.put(id, items);
            }
            items.add(mutation);
        }

        public boolean containsKey(HugeType type, Id id) {
            Map<Id, List<BackendAction>> table = this.mutations.get(type);
            return table != null && table.containsKey(id);
        }

        public List<BackendAction> get(HugeType type, Id id) {
            Map<Id, List<BackendAction>> table = this.mutations.get(type);
            if (table == null) {
                return null;
            }
            return table.get(id);
        }

        public Iterator<BackendAction> get(HugeType type) {
            ExtendableIterator rs = new ExtendableIterator();
            Map<Id, List<BackendAction>> table = this.mutations.get(type);
            for (List<BackendAction> items : table.values()) {
                rs.extend(items.iterator());
            }
            return rs;
        }

        public Set<HugeType> keys() {
            return this.mutations.keySet();
        }

        public Iterator<BackendAction> values() {
            ExtendableIterator rs = new ExtendableIterator();
            for (Map<Id, List<BackendAction>> table : this.mutations.values()) {
                for (List<BackendAction> items : table.values()) {
                    rs.extend(items.iterator());
                }
            }
            return rs;
        }

        public int size() {
            int size = 0;
            for (Map<Id, List<BackendAction>> m : this.mutations.values()) {
                size += m.size();
            }
            return size;
        }
    }
}

