/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.store.BackendStoreProvider;
import com.baidu.hugegraph.backend.store.memory.InMemoryDBStoreProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BackendProviderFactory {
    private static Map<String, Class<? extends BackendStoreProvider>> providers = new ConcurrentHashMap<String, Class<? extends BackendStoreProvider>>();

    public static BackendStoreProvider open(String backend, String graph) {
        if (InMemoryDBStoreProvider.matchType(backend)) {
            return InMemoryDBStoreProvider.instance(graph);
        }
        Class<? extends BackendStoreProvider> clazz = providers.get(backend);
        BackendException.check(clazz != null, "Not exists BackendStoreProvider: %s", backend);
        assert (BackendStoreProvider.class.isAssignableFrom(clazz));
        BackendStoreProvider instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
        BackendException.check(backend.equalsIgnoreCase(instance.type()), "BackendStoreProvider with type '%s' can't be opened by key '%s'", instance.type(), backend);
        instance.open(graph);
        return instance;
    }

    public static void register(String name, String classPath) {
        ClassLoader classLoader = BackendProviderFactory.class.getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(classPath);
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
        boolean subclass = BackendStoreProvider.class.isAssignableFrom(clazz);
        BackendException.check(subclass, "Class '%s' is not a subclass of class BackendStoreProvider", classPath);
        BackendException.check(!providers.containsKey(name), "Exists BackendStoreProvider: %s (%s)", name, providers.get(name));
        providers.put(name, clazz);
    }
}

