/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

public class BackendStoreInfo {
    private static final Logger LOG = Log.logger(HugeGraph.class);
    private static final String PK_BACKEND_INFO = Graph.Hidden.hide((String)"backend_info");
    private final HugeGraph graph;

    public BackendStoreInfo(HugeGraph graph) {
        this.graph = graph;
    }

    public void init() {
        SchemaTransaction schema = this.graph.schemaTransaction();
        String backendVersion = this.graph.backendVersion();
        PropertyKey backendInfo = (PropertyKey)this.graph.schema().propertyKey(PK_BACKEND_INFO).userdata("version", backendVersion).build();
        schema.addPropertyKey(backendInfo);
    }

    private Map<String, Object> info() {
        SchemaTransaction schema = this.graph.schemaTransaction();
        PropertyKey pkey = null;
        try {
            pkey = schema.getPropertyKey(PK_BACKEND_INFO);
        }
        catch (BackendException | IllegalStateException runtimeException) {
            // empty catch block
        }
        return pkey != null ? pkey.userdata() : null;
    }

    public boolean exist() {
        return this.info() != null;
    }

    public boolean checkVersion() {
        Map<String, Object> info = this.info();
        E.checkState((info != null ? 1 : 0) != 0, (String)"The backend version info doesn't exist", (Object[])new Object[0]);
        String driverVersion = this.graph.backendVersion();
        String backendVersion = (String)info.get("version");
        if (!driverVersion.equals(backendVersion)) {
            LOG.error("The backend driver version '{}' is inconsistent with the data version '{}' of backend store for graph '{}'", new Object[]{driverVersion, backendVersion, this.graph.name()});
            return false;
        }
        return true;
    }
}

