/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendSession;
import com.baidu.hugegraph.backend.store.MetaDispatcher;
import com.baidu.hugegraph.backend.store.MetaHandler;
import com.baidu.hugegraph.backend.store.Shard;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.NumericUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class BackendTable<Session extends BackendSession, Entry> {
    private final String table;
    private final MetaDispatcher<Session> dispatcher;

    public BackendTable(String table) {
        this.table = table;
        this.dispatcher = new MetaDispatcher();
        this.registerMetaHandlers();
    }

    public String table() {
        return this.table;
    }

    public MetaDispatcher<Session> metaDispatcher() {
        return this.dispatcher;
    }

    public void registerMetaHandler(String name, MetaHandler<Session> handler) {
        this.dispatcher.registerMetaHandler(name, handler);
    }

    protected void registerMetaHandlers() {
    }

    public static HugeType tableType(Query query) {
        HugeType type = query.resultType();
        if (type == HugeType.EDGE) {
            ConditionQuery cq;
            type = HugeType.EDGE_OUT;
            if (!query.ids().isEmpty() && query instanceof IdQuery && query.originQuery() != null) {
                query = query.originQuery();
            }
            if (!query.conditions().isEmpty() && query instanceof ConditionQuery && (cq = (ConditionQuery)query).condition((Object)HugeKeys.DIRECTION) == Directions.IN) {
                type = HugeType.EDGE_IN;
            }
        }
        return type;
    }

    public static final String joinTableName(String prefix, String table) {
        return prefix + "_" + table;
    }

    public abstract void init(Session var1);

    public abstract void clear(Session var1);

    public abstract Iterator<BackendEntry> query(Session var1, Query var2);

    public abstract void insert(Session var1, Entry var2);

    public abstract void delete(Session var1, Entry var2);

    public abstract void append(Session var1, Entry var2);

    public abstract void eliminate(Session var1, Entry var2);

    public static abstract class ShardSpliter<Session extends BackendSession> {
        private static final int MIN_SHARD_SIZE = 0x100000;
        private static final int ESTIMATE_BYTES_PER_KV = 100;
        private final String table;

        public ShardSpliter(String table) {
            this.table = table;
        }

        public String table() {
            return this.table;
        }

        public List<Shard> getSplits(Session session, long splitSize) {
            double count;
            E.checkArgument((splitSize >= 0x100000L ? 1 : 0) != 0, (String)"The split-size must be >= %s bytes, but got %s", (Object[])new Object[]{0x100000, splitSize});
            long size = this.estimateDataSize(session);
            if (size <= 0L) {
                size = this.estimateNumKeys(session) * 100L;
            }
            if ((count = Math.ceil((double)size / (double)splitSize)) <= 0.0) {
                count = 1.0;
            }
            double each = 4.294967295E9 / count;
            long offset = 0L;
            String last = this.position(offset);
            ArrayList<Shard> splits = new ArrayList<Shard>((int)count);
            while (offset < 0xFFFFFFFFL) {
                if ((offset = (long)((double)offset + each)) > 0xFFFFFFFFL) {
                    offset = 0xFFFFFFFFL;
                }
                String current = this.position(offset);
                splits.add(new Shard(last, current, 0L));
                last = current;
            }
            return splits;
        }

        public final String position(long position) {
            return String.valueOf(position);
        }

        public final byte[] position(String position) {
            int value = Long.valueOf(position).intValue();
            return NumericUtil.intToBytes((int)value);
        }

        protected abstract long estimateDataSize(Session var1);

        protected abstract long estimateNumKeys(Session var1);
    }
}

