/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.memory;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.serializer.TextBackendEntry;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendSession;
import com.baidu.hugegraph.backend.store.BackendTable;
import com.baidu.hugegraph.exception.NotSupportException;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;

public class InMemoryDBTable
extends BackendTable<BackendSession, TextBackendEntry> {
    protected final Map<Id, BackendEntry> store;

    public InMemoryDBTable(HugeType type) {
        super(type.name());
        this.store = new ConcurrentSkipListMap<Id, BackendEntry>();
    }

    public InMemoryDBTable(HugeType type, Map<Id, BackendEntry> store) {
        super(type.name());
        this.store = store;
    }

    protected Map<Id, BackendEntry> store() {
        return this.store;
    }

    @Override
    public void init(BackendSession session) {
    }

    @Override
    public void clear(BackendSession session) {
        this.store.clear();
    }

    @Override
    public void insert(BackendSession session, TextBackendEntry entry) {
        if (!this.store.containsKey(entry.id())) {
            this.store.put(entry.id(), entry);
        } else {
            BackendEntry origin = this.store.get(entry.id());
            origin.merge(entry);
        }
    }

    @Override
    public void delete(BackendSession session, TextBackendEntry entry) {
        this.store.remove(entry.id());
    }

    @Override
    public void append(BackendSession session, TextBackendEntry entry) {
        BackendEntry parent = this.store.get(entry.id());
        if (parent == null) {
            this.store.put(entry.id(), entry);
        } else {
            ((TextBackendEntry)parent).append(entry);
        }
    }

    @Override
    public void eliminate(BackendSession session, TextBackendEntry entry) {
        BackendEntry parent = this.store.get(entry.id());
        if (parent != null) {
            ((TextBackendEntry)parent).eliminate(entry);
        }
    }

    @Override
    public Iterator<BackendEntry> query(BackendSession session, Query query) {
        if (query.paging()) {
            throw new NotSupportException("paging by InMemoryDBStore");
        }
        Map<Id, BackendEntry> rs = this.store;
        if (!query.ids().isEmpty()) {
            if (query.resultType().isEdge()) {
                E.checkState((boolean)query.conditions().isEmpty(), (String)"Not support querying edge by %s", (Object[])new Object[]{query});
                rs = this.queryEdgeById(query.ids(), rs);
            } else {
                rs = this.queryById(query.ids(), rs);
            }
        }
        if (!query.conditions().isEmpty()) {
            rs = query.resultType().isEdge() ? this.queryEdgeByFilter(query.conditions(), rs) : this.queryByFilter(query.conditions(), rs);
        }
        Iterator<BackendEntry> iterator = rs.values().iterator();
        if (query.offset() >= (long)rs.size()) {
            return Collections.emptyIterator();
        }
        iterator = this.skipOffset(iterator, query.offset());
        if (query.limit() != Long.MAX_VALUE && query.offset() + query.limit() < (long)rs.size()) {
            iterator = this.dropTails(iterator, query.limit());
        }
        return iterator;
    }

    protected Map<Id, BackendEntry> queryById(Set<Id> ids, Map<Id, BackendEntry> entries) {
        assert (ids.size() > 0);
        Map rs = InsertionOrderUtil.newMap();
        for (Id id : ids) {
            assert (!id.number());
            if (!entries.containsKey(id)) continue;
            rs.put(id, entries.get(id));
        }
        return rs;
    }

    protected Map<Id, BackendEntry> queryEdgeById(Set<Id> ids, Map<Id, BackendEntry> entries) {
        assert (ids.size() > 0);
        HashMap<Id, BackendEntry> rs = new HashMap<Id, BackendEntry>();
        for (Id id : ids) {
            String[] parts = EdgeId.split(id);
            Id entryId = IdGenerator.of(parts[0]);
            String column = null;
            if (parts.length > 1) {
                parts = Arrays.copyOfRange(parts, 1, parts.length);
                column = EdgeId.concat(parts);
            } else assert (parts.length == 1);
            if (!entries.containsKey(entryId)) continue;
            BackendEntry value = entries.get(entryId);
            TextBackendEntry entry = (TextBackendEntry)value;
            if (column == null) {
                rs.put(entryId, entry);
                continue;
            }
            if (!entry.containsPrefix(column)) continue;
            TextBackendEntry edges = new TextBackendEntry(HugeType.VERTEX, entryId);
            edges.columns(entry.columnsWithPrefix(column));
            BackendEntry result = (BackendEntry)rs.get(entryId);
            if (result == null) {
                rs.put(entryId, edges);
                continue;
            }
            result.merge(edges);
        }
        return rs;
    }

    protected Map<Id, BackendEntry> queryByFilter(Set<Condition> conditions, Map<Id, BackendEntry> entries) {
        assert (conditions.size() > 0);
        HashMap<Id, BackendEntry> rs = new HashMap<Id, BackendEntry>();
        for (BackendEntry entry : entries.values()) {
            boolean matched = true;
            for (Condition c : conditions) {
                if (InMemoryDBTable.matchCondition(entry, c)) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            rs.put(entry.id(), entry);
        }
        return rs;
    }

    protected Map<Id, BackendEntry> queryEdgeByFilter(Set<Condition> conditions, Map<Id, BackendEntry> entries) {
        if (conditions.isEmpty()) {
            return entries;
        }
        E.checkState((conditions.size() == 1 ? 1 : 0) != 0, (String)"Not support querying edge by %s", (Object[])new Object[]{conditions});
        Condition cond = conditions.iterator().next();
        E.checkState((cond.isRelation() && ((Condition.Relation)cond).key().equals((Object)HugeKeys.LABEL) ? 1 : 0) != 0, (String)"Not support querying edge by %s", (Object[])new Object[]{conditions});
        Condition.Relation relation = (Condition.Relation)cond;
        String label = (String)relation.serialValue();
        HashMap<Id, BackendEntry> rs = new HashMap<Id, BackendEntry>();
        for (BackendEntry value : entries.values()) {
            TextBackendEntry edges;
            TextBackendEntry entry = (TextBackendEntry)value;
            String out = EdgeId.concat(HugeType.EDGE_OUT.string(), label);
            String in = EdgeId.concat(HugeType.EDGE_IN.string(), label);
            if (entry.containsPrefix(out)) {
                edges = new TextBackendEntry(HugeType.VERTEX, entry.id());
                edges.columns(entry.columnsWithPrefix(out));
                rs.put(edges.id(), edges);
            }
            if (!entry.containsPrefix(in)) continue;
            edges = new TextBackendEntry(HugeType.VERTEX, entry.id());
            edges.columns(entry.columnsWithPrefix(in));
            BackendEntry result = (BackendEntry)rs.get(edges.id());
            if (result == null) {
                rs.put(edges.id(), edges);
                continue;
            }
            result.merge(edges);
        }
        return rs;
    }

    protected Iterator<BackendEntry> skipOffset(Iterator<BackendEntry> iterator, long offset) {
        for (long i = 0L; i < offset && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return iterator;
    }

    protected Iterator<BackendEntry> dropTails(Iterator<BackendEntry> iterator, long limit) {
        E.checkArgument((limit <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Limit must be <= 0x7fffffff, but got '%s'", (Object[])new Object[]{limit});
        ArrayList<BackendEntry> entries = new ArrayList<BackendEntry>((int)limit);
        for (long i = 0L; i < limit && iterator.hasNext(); ++i) {
            entries.add(iterator.next());
        }
        return entries.iterator();
    }

    private static boolean matchCondition(BackendEntry item, Condition c) {
        TextBackendEntry entry = (TextBackendEntry)item;
        if (!(c instanceof Condition.Relation)) {
            throw new BackendException("Unsupported condition: " + c);
        }
        Condition.Relation r = (Condition.Relation)c;
        String key = r.serialKey().toString();
        if (r.relation() == Condition.RelationType.CONTAINS_KEY) {
            return entry.contains(r.serialValue().toString());
        }
        if (r.relation() == Condition.RelationType.CONTAINS) {
            return entry.containsValue(r.serialValue().toString());
        }
        if (r.relation() == Condition.RelationType.EQ) {
            return entry.contains(key, r.serialValue().toString());
        }
        if (entry.contains(key)) {
            return r.test(entry.column(key));
        }
        return false;
    }
}

