/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.memory;

import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.serializer.TextBackendEntry;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendSession;
import com.baidu.hugegraph.backend.store.memory.InMemoryDBTable;
import com.baidu.hugegraph.iterator.ExtendableIterator;
import com.baidu.hugegraph.structure.HugeIndex;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;

public class InMemoryDBTables {

    public static class RangeIndex
    extends InMemoryDBTable {
        public RangeIndex() {
            super(HugeType.RANGE_INDEX, new ConcurrentSkipListMap<Id, BackendEntry>());
        }

        protected NavigableMap<Id, BackendEntry> store() {
            return (NavigableMap)super.store();
        }

        @Override
        public Iterator<BackendEntry> query(BackendSession session, Query query) {
            Set<Condition> conditions = query.conditions();
            E.checkState((query instanceof ConditionQuery && (conditions.size() == 3 || conditions.size() == 2) ? 1 : 0) != 0, (String)"Range index query must be condition query and have 2 or 3 conditions, but got: %s", (Object[])new Object[]{query});
            ArrayList<Condition.Relation> relations = new ArrayList<Condition.Relation>();
            Id indexLabelId = null;
            for (Condition.Relation r : ((ConditionQuery)query).relations()) {
                if (r.key().equals((Object)HugeKeys.INDEX_LABEL_ID)) {
                    indexLabelId = (Id)r.value();
                    continue;
                }
                relations.add(r);
            }
            assert (indexLabelId != null);
            Object keyEq = null;
            Object keyMin = null;
            boolean keyMinEq = false;
            Object keyMax = null;
            boolean keyMaxEq = false;
            block8: for (Condition.Relation r : relations) {
                E.checkArgument((r.key() == HugeKeys.FIELD_VALUES ? 1 : 0) != 0, (String)"Expect FIELD_VALUES in AND condition", (Object[])new Object[0]);
                switch (r.relation()) {
                    case EQ: {
                        keyEq = r.value();
                        continue block8;
                    }
                    case GTE: {
                        keyMinEq = true;
                    }
                    case GT: {
                        keyMin = r.value();
                        continue block8;
                    }
                    case LTE: {
                        keyMaxEq = true;
                    }
                    case LT: {
                        keyMax = r.value();
                        continue block8;
                    }
                }
                E.checkArgument((boolean)false, (String)"Unsupported relation '%s'", (Object[])new Object[]{r.relation()});
            }
            if (keyEq != null) {
                Id id = HugeIndex.formatIndexId(HugeType.RANGE_INDEX, indexLabelId, keyEq);
                IdQuery q = new IdQuery(query, id);
                q.offset(query.offset());
                q.limit(query.limit());
                return super.query(session, (Query)q);
            }
            if (keyMin == null) {
                assert (keyMax != null);
                return this.ltQuery(indexLabelId, keyMax, keyMaxEq);
            }
            if (keyMax == null) {
                return this.gtQuery(indexLabelId, keyMin, keyMinEq);
            }
            return this.betweenQuery(indexLabelId, keyMax, keyMaxEq, keyMin, keyMinEq);
        }

        private Iterator<BackendEntry> ltQuery(Id indexLabelId, Object keyMax, boolean keyMaxEq) {
            Map.Entry entry;
            Map rs = this.store();
            HashMap results = new HashMap();
            Id min = HugeIndex.formatIndexId(HugeType.RANGE_INDEX, indexLabelId, 0L);
            Id max = HugeIndex.formatIndexId(HugeType.RANGE_INDEX, indexLabelId, keyMax);
            Map.Entry entry2 = entry = keyMaxEq ? rs.floorEntry(max) : rs.lowerEntry(max);
            while (entry != null && entry.getKey().compareTo(min) >= 0) {
                results.put(entry.getKey(), entry.getValue());
                entry = rs.lowerEntry(entry.getKey());
            }
            return results.values().iterator();
        }

        private Iterator<BackendEntry> gtQuery(Id indexLabelId, Object keyMin, boolean keyMinEq) {
            Map.Entry entry;
            Map rs = this.store();
            HashMap results = new HashMap();
            Id min = HugeIndex.formatIndexId(HugeType.RANGE_INDEX, indexLabelId, keyMin);
            indexLabelId = IdGenerator.of(indexLabelId.asLong() + 1L);
            Id max = HugeIndex.formatIndexId(HugeType.RANGE_INDEX, indexLabelId, 0L);
            Map.Entry entry2 = entry = keyMinEq ? rs.ceilingEntry(min) : rs.higherEntry(min);
            while (entry != null && entry.getKey().compareTo(max) < 0) {
                results.put(entry.getKey(), entry.getValue());
                entry = rs.higherEntry(entry.getKey());
            }
            return results.values().iterator();
        }

        private Iterator<BackendEntry> betweenQuery(Id indexLabelId, Object keyMax, boolean keyMaxEq, Object keyMin, boolean keyMinEq) {
            Map.Entry entry;
            Map rs = this.store();
            Id min = HugeIndex.formatIndexId(HugeType.RANGE_INDEX, indexLabelId, keyMin);
            Id max = HugeIndex.formatIndexId(HugeType.RANGE_INDEX, indexLabelId, keyMax);
            Id id = max = keyMaxEq ? rs.floorKey(max) : rs.lowerKey(max);
            if (max == null) {
                return Collections.emptyIterator();
            }
            HashMap results = new HashMap();
            Map.Entry entry2 = entry = keyMinEq ? rs.ceilingEntry(min) : rs.higherEntry(min);
            while (entry != null && entry.getKey().compareTo(max) <= 0) {
                results.put(entry.getKey(), entry.getValue());
                entry = rs.higherEntry(entry.getKey());
            }
            return results.values().iterator();
        }
    }

    public static class SearchIndex
    extends SecondaryIndex {
        public SearchIndex() {
            super(HugeType.SEARCH_INDEX);
        }
    }

    public static class SecondaryIndex
    extends InMemoryDBTable {
        public SecondaryIndex() {
            super(HugeType.SECONDARY_INDEX);
        }

        protected SecondaryIndex(HugeType type) {
            super(type);
        }

        @Override
        public Iterator<BackendEntry> query(BackendSession session, Query query) {
            Set<Condition> conditions = query.conditions();
            E.checkState((query instanceof ConditionQuery && conditions.size() == 2 ? 1 : 0) != 0, (String)"Secondary index query must be condition query and have two conditions, but got: %s", (Object[])new Object[]{query});
            String fieldValue = null;
            String indexLabelId = null;
            for (Condition c : conditions) {
                assert (c instanceof Condition.Relation);
                Condition.Relation r = (Condition.Relation)c;
                if (r.key() == HugeKeys.FIELD_VALUES) {
                    fieldValue = r.value().toString();
                    continue;
                }
                if (r.key() == HugeKeys.INDEX_LABEL_ID) {
                    indexLabelId = r.value().toString();
                    continue;
                }
                E.checkState((boolean)false, (String)"Secondary index query conditions must beFIELD_VALUES or INDEX_LABEL_ID, but got: %s", (Object[])new Object[]{r.key()});
            }
            assert (fieldValue != null && indexLabelId != null);
            Id id = SplicingIdGenerator.splicing(indexLabelId, fieldValue);
            IdQuery q = new IdQuery(query, id);
            q.offset(query.offset());
            q.limit(query.limit());
            return super.query(session, (Query)q);
        }
    }

    public static class Edge
    extends InMemoryDBTable {
        public Edge(HugeType type) {
            super(type);
        }

        @Override
        public void insert(BackendSession session, TextBackendEntry entry) {
            Id id = Edge.vertexIdOfEdge(entry);
            if (!this.store().containsKey(id)) {
                TextBackendEntry vertex = new TextBackendEntry(HugeType.VERTEX, id);
                vertex.merge(entry);
                this.store().put(id, vertex);
            } else {
                BackendEntry vertex = this.store().get(id);
                vertex.merge(entry);
            }
        }

        @Override
        public void delete(BackendSession session, TextBackendEntry entry) {
            Id id = Edge.vertexIdOfEdge(entry);
            BackendEntry vertex = this.store().get(id);
            if (vertex != null) {
                ((TextBackendEntry)vertex).eliminate(entry);
            }
        }

        @Override
        public void append(BackendSession session, TextBackendEntry entry) {
            throw new UnsupportedOperationException("Edge append");
        }

        @Override
        public void eliminate(BackendSession session, TextBackendEntry entry) {
            throw new UnsupportedOperationException("Edge eliminate");
        }

        @Override
        protected Iterator<BackendEntry> skipOffset(Iterator<BackendEntry> itor, long offset) {
            long count;
            BackendEntry last = null;
            for (count = 0L; count < offset && itor.hasNext(); count += (long)last.columnsSize()) {
                last = itor.next();
            }
            if (count == offset) {
                return itor;
            }
            if (count < offset) {
                return Collections.emptyIterator();
            }
            assert (count > offset);
            assert (last != null);
            int remaining = (int)(count - offset);
            last = ((TextBackendEntry)last).copyLast(remaining);
            ExtendableIterator all = new ExtendableIterator();
            all.extend((Iterator)ImmutableList.of((Object)last).iterator());
            all.extend(itor);
            return all;
        }

        @Override
        protected Iterator<BackendEntry> dropTails(Iterator<BackendEntry> itor, long limit) {
            long count;
            BackendEntry last = null;
            ArrayList<BackendEntry> entries = new ArrayList<BackendEntry>();
            for (count = 0L; count < limit && itor.hasNext(); count += (long)last.columnsSize()) {
                last = itor.next();
                entries.add(last);
            }
            if (count <= limit) {
                return entries.iterator();
            }
            assert (count > limit);
            assert (last != null);
            int head = (int)(limit + (long)last.columnsSize() - count);
            last = ((TextBackendEntry)last).copyHead(head);
            entries.remove(entries.size() - 1);
            entries.add(last);
            return entries.iterator();
        }

        private static Id vertexIdOfEdge(TextBackendEntry entry) {
            assert (entry.type().isEdge());
            String vertexId = EdgeId.split(entry.id())[0];
            return IdGenerator.of(vertexId);
        }
    }

    public static class Vertex
    extends InMemoryDBTable {
        public Vertex() {
            super(HugeType.VERTEX);
        }
    }
}

