/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.tx;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.analyzer.Analyzer;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.ConditionQueryFlatten;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.tx.AbstractTransaction;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.exception.NoIndexException;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.structure.HugeIndex;
import com.baidu.hugegraph.structure.HugeProperty;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.type.define.IndexType;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.baidu.hugegraph.util.LockUtil;
import com.baidu.hugegraph.util.NumericUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphIndexTransaction
extends AbstractTransaction {
    private static final String INDEX_EMPTY_SYM = "\u0000";
    private static final Query EMPTY_QUERY = new ConditionQuery(null);
    private final Analyzer textAnalyzer;

    public GraphIndexTransaction(HugeGraph graph, BackendStore store) {
        super(graph, store);
        this.textAnalyzer = graph.analyzer();
        assert (this.textAnalyzer != null);
    }

    protected void removeIndexLeft(ConditionQuery query, HugeElement element) {
        if (element.type() != HugeType.VERTEX && element.type() != HugeType.EDGE_OUT && element.type() != HugeType.EDGE_IN) {
            throw new HugeException("Only accept element of type VERTEX and EDGE to remove left index, but got: '%s'", element.type());
        }
        this.processRangeIndexLeft(query, element);
        this.processSecondaryOrSearchIndexLeft(query, element);
        this.commit();
    }

    private void processRangeIndexLeft(ConditionQuery query, HugeElement element) {
        Set<MatchedIndex> matchedIndexes = this.collectMatchedIndexes(query);
        HashMap queries = null;
        for (MatchedIndex index : matchedIndexes) {
            if (!index.schemaLabel().id().equals(element.schemaLabel().id())) continue;
            queries = index.constructIndexQueries(query);
            break;
        }
        E.checkState((queries != null ? 1 : 0) != 0, (String)"Can't construct left-index query for '%s'", (Object[])new Object[]{query});
        for (ConditionQuery q : queries.values()) {
            if (!q.resultType().isRangeIndex()) continue;
            Iterator<BackendEntry> it = super.query(q);
            while (it.hasNext()) {
                BackendEntry entry = it.next();
                HugeIndex index = this.serializer.readIndex(this.graph(), q, entry);
                if (!index.elementIds().contains(element.id())) continue;
                index.resetElementIds();
                index.elementIds(element.id());
                this.doEliminate(this.serializer.writeIndex(index));
            }
        }
    }

    private void processSecondaryOrSearchIndexLeft(ConditionQuery query, HugeElement element) {
        HugeElement deletion = element.copyAsFresh();
        Set<Id> propKeys = query.userpropKeys();
        Set incorrectPKs = InsertionOrderUtil.newSet();
        for (Id key : propKeys) {
            Object conditionValue;
            Set<Object> conditionValues = query.userpropValues(key);
            E.checkState((!conditionValues.isEmpty() ? 1 : 0) != 0, (String)"Expect user property values for key '%s', but got none", (Object[])new Object[]{key});
            if (conditionValues.size() > 1) {
                return;
            }
            Object propValue = deletion.getProperty(key).value();
            if (propValue.equals(conditionValue = conditionValues.iterator().next())) continue;
            PropertyKey pkey = this.graph().propertyKey(key);
            deletion.addProperty(pkey, conditionValue);
            incorrectPKs.add(key);
        }
        for (IndexLabel il : GraphIndexTransaction.relatedIndexLabels(deletion)) {
            if (!CollectionUtil.hasIntersection(il.indexFields(), (Set)incorrectPKs)) continue;
            if (il.indexType() == IndexType.SEARCH) {
                Id field = il.indexField();
                String cond = (String)deletion.getPropertyValue(field);
                String actual = (String)element.getPropertyValue(field);
                if (this.matchSearchIndexWords(actual, cond)) continue;
            }
            this.updateIndex(il.id(), deletion, true);
            if (il.indexType() != IndexType.SECONDARY) continue;
            this.updateIndex(il.id(), element, false);
        }
    }

    @PerfUtil.Watched(prefix="index")
    public void updateLabelIndex(HugeElement element, boolean removed) {
        if (!this.needIndexForLabel()) {
            return;
        }
        if (!element.schemaLabel().enableLabelIndex()) {
            return;
        }
        HugeIndex index = new HugeIndex(IndexLabel.label(element.type()));
        index.fieldValues(element.schemaLabel().id().asLong());
        index.elementIds(element.id());
        if (removed) {
            this.doEliminate(this.serializer.writeIndex(index));
        } else {
            this.doAppend(this.serializer.writeIndex(index));
        }
    }

    @PerfUtil.Watched(prefix="index")
    public void updateVertexIndex(HugeVertex vertex, boolean removed) {
        for (Id id : vertex.schemaLabel().indexLabels()) {
            this.updateIndex(id, vertex, removed);
        }
    }

    @PerfUtil.Watched(prefix="index")
    public void updateEdgeIndex(HugeEdge edge, boolean removed) {
        for (Id id : edge.schemaLabel().indexLabels()) {
            this.updateIndex(id, edge, removed);
        }
    }

    protected void updateIndex(Id ilId, HugeElement element, boolean removed) {
        SchemaTransaction schema = this.graph().schemaTransaction();
        IndexLabel indexLabel = schema.getIndexLabel(ilId);
        E.checkArgument((indexLabel != null ? 1 : 0) != 0, (String)"Not exist index label with id '%s'", (Object[])new Object[]{ilId});
        ArrayList propValues = new ArrayList();
        for (Id fieldId : indexLabel.indexFields()) {
            HugeProperty property = element.getProperty(fieldId);
            if (property == null) {
                E.checkState((boolean)GraphIndexTransaction.hasNullableProp(element, fieldId), (String)"Non-null property '%s' is null for '%s'", (Object[])new Object[]{this.graph().propertyKey(fieldId), element});
                break;
            }
            propValues.add(property.value());
        }
        if (propValues.isEmpty()) {
            return;
        }
        switch (indexLabel.indexType()) {
            case RANGE: {
                E.checkState((propValues.size() == 1 ? 1 : 0) != 0, (String)"Expect only one property in range index", (Object[])new Object[0]);
                Object value = NumericUtil.convertToNumber(propValues.get(0));
                this.updateIndex(indexLabel, value, element.id(), removed);
                break;
            }
            case SEARCH: {
                E.checkState((propValues.size() == 1 ? 1 : 0) != 0, (String)"Expect only one property in search index", (Object[])new Object[0]);
                Object value = propValues.get(0);
                Set<String> words = this.segmentWords(value.toString());
                for (String word : words) {
                    this.updateIndex(indexLabel, word, element.id(), removed);
                }
                break;
            }
            case SECONDARY: {
                Object value;
                int n = propValues.size();
                for (int i = 0; i < n; ++i) {
                    List prefixValues = propValues.subList(0, i + 1);
                    value = SplicingIdGenerator.concatValues(prefixValues);
                    E.checkArgument((!value.equals(INDEX_EMPTY_SYM) ? 1 : 0) != 0, (String)"Illegal value of index property: '%s'", (Object[])new Object[]{INDEX_EMPTY_SYM});
                    if (((String)value).isEmpty()) {
                        value = INDEX_EMPTY_SYM;
                    }
                    this.updateIndex(indexLabel, value, element.id(), removed);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown index type '%s'", indexLabel.indexType()));
            }
        }
    }

    private void updateIndex(IndexLabel indexLabel, Object propValue, Id elementId, boolean removed) {
        HugeIndex index = new HugeIndex(indexLabel);
        index.fieldValues(propValue);
        index.elementIds(elementId);
        if (removed) {
            this.doEliminate(this.serializer.writeIndex(index));
        } else {
            this.doAppend(this.serializer.writeIndex(index));
        }
    }

    @PerfUtil.Watched(prefix="index")
    public Query query(ConditionQuery query) {
        query.checkFlattened();
        if (this.hasUpdates()) {
            throw new BackendException("Can't do index query when there are changes in transaction");
        }
        List<Condition> conds = query.syspropConditions();
        if (conds.size() > 1 || conds.size() == 1 && !query.containsCondition(HugeKeys.LABEL)) {
            throw new BackendException("Can't do index query with %s", conds);
        }
        query.optimized(OptimizedType.INDEX.ordinal());
        Set<Id> ids = query.allSysprop() && conds.size() == 1 && query.containsCondition(HugeKeys.LABEL) ? this.queryByLabel(query) : this.queryByUserprop(query);
        if (ids.isEmpty()) {
            return EMPTY_QUERY;
        }
        return new IdQuery((Query)query, ids);
    }

    @PerfUtil.Watched(prefix="index")
    private Set<Id> queryByLabel(ConditionQuery query) {
        SchemaLabel schemaLabel;
        HugeType queryType = query.resultType();
        IndexLabel il = IndexLabel.label(queryType);
        Id label = (Id)query.condition((Object)HugeKeys.LABEL);
        assert (label != null);
        if (queryType.isVertex()) {
            schemaLabel = this.graph().vertexLabel(label);
        } else if (queryType.isEdge()) {
            schemaLabel = this.graph().edgeLabel(label);
        } else {
            throw new BackendException("Can't query %s by label", queryType);
        }
        if (!this.store().features().supportsQueryByLabel() && !schemaLabel.enableLabelIndex()) {
            throw new NoIndexException("Don't accept query by label '%s', it disables label index", schemaLabel);
        }
        ConditionQuery indexQuery = new ConditionQuery(HugeType.SECONDARY_INDEX, query);
        indexQuery.eq(HugeKeys.INDEX_LABEL_ID, il.id());
        indexQuery.eq(HugeKeys.FIELD_VALUES, label);
        indexQuery.limit(query.limit());
        indexQuery.offset(query.offset());
        indexQuery.capacity(query.capacity());
        return this.doIndexQuery(il, indexQuery);
    }

    @PerfUtil.Watched(prefix="index")
    private Set<Id> queryByUserprop(ConditionQuery query) {
        Set<MatchedIndex> indexes = this.collectMatchedIndexes(query);
        if (indexes.isEmpty()) {
            Id label = (Id)query.condition((Object)HugeKeys.LABEL);
            throw GraphIndexTransaction.noIndexException(this.graph(), query, label);
        }
        if (!GraphIndexTransaction.validQueryConditionValues(this.graph(), query)) {
            return ImmutableSet.of();
        }
        Set ids = InsertionOrderUtil.newSet();
        for (MatchedIndex index : indexes) {
            if (index.containsSearchIndex()) {
                ids.addAll(this.queryByUserpropWithSearchIndex(query, index));
            } else {
                IndexQueries queries = index.constructIndexQueries(query);
                ids.addAll(this.intersectIndexQueries(queries));
            }
            if (!query.reachLimit(ids.size())) continue;
            break;
        }
        return GraphIndexTransaction.limit(ids, query);
    }

    @PerfUtil.Watched(prefix="index")
    private Set<Id> queryByUserpropWithSearchIndex(ConditionQuery query, MatchedIndex index) {
        ConditionQuery originQuery = query;
        HashSet<Id> indexFields = new HashSet<Id>();
        for (IndexLabel il : index.indexLabels()) {
            if (il.indexType() != IndexType.SEARCH) continue;
            Id indexField = il.indexField();
            Object fieldValue = query.userpropValue(indexField);
            Set<String> words = this.segmentWords(fieldValue.toString());
            indexFields.add(indexField);
            query = query.copy();
            query.unsetCondition(indexField);
            query.query(Condition.textContainsAny(indexField, words));
        }
        query.registerResultsFilter((Function<HugeElement, Boolean>)((Function)elem -> {
            for (Condition cond : originQuery.conditions()) {
                Object key;
                Object object = key = cond.isRelation() ? ((Condition.Relation)cond).key() : null;
                if (key instanceof Id && indexFields.contains(key)) {
                    String fvalue;
                    Id field = (Id)key;
                    String propValue = (String)elem.getPropertyValue(field);
                    if (this.matchSearchIndexWords(propValue, fvalue = originQuery.userpropValue(field).toString())) continue;
                    return false;
                }
                if (cond.test((HugeElement)elem)) continue;
                return false;
            }
            return true;
        }));
        Set ids = InsertionOrderUtil.newSet();
        for (ConditionQuery q : ConditionQueryFlatten.flatten(query)) {
            IndexQueries queries = index.constructIndexQueries(q);
            ids.addAll(this.intersectIndexQueries(queries));
        }
        return ids;
    }

    private boolean matchSearchIndexWords(String propValue, String fieldValue) {
        Set<String> propValues = this.segmentWords(propValue);
        Set<String> words = this.segmentWords(fieldValue);
        return CollectionUtil.hasIntersection(propValues, words);
    }

    private Set<String> segmentWords(String text) {
        return this.textAnalyzer.segment(text);
    }

    private boolean needIndexForLabel() {
        return !this.store().features().supportsQueryByLabel();
    }

    @PerfUtil.Watched(prefix="index")
    private Collection<Id> intersectIndexQueries(IndexQueries queries) {
        Set<Id> intersectIds = null;
        for (Map.Entry entry : queries.entrySet()) {
            Set<Id> ids = this.doIndexQuery((IndexLabel)entry.getKey(), (ConditionQuery)entry.getValue());
            if (intersectIds == null) {
                intersectIds = ids;
            } else {
                CollectionUtil.intersectWithModify(intersectIds, ids);
            }
            if (!intersectIds.isEmpty()) continue;
            break;
        }
        return intersectIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerfUtil.Watched(prefix="index")
    private Set<Id> doIndexQuery(IndexLabel indexLabel, ConditionQuery query) {
        Set ids = InsertionOrderUtil.newSet();
        LockUtil.Locks locks = new LockUtil.Locks(this.graph().name());
        try {
            locks.lockReads("il_delete", indexLabel.id());
            locks.lockReads("il_rebuild", indexLabel.id());
            Iterator<BackendEntry> entries = super.query(query);
            while (entries.hasNext()) {
                HugeIndex index = this.serializer.readIndex(this.graph(), query, entries.next());
                ids.addAll(index.elementIds());
                if (!query.reachLimit(ids.size())) continue;
                break;
            }
        }
        finally {
            locks.unlock();
        }
        return ids;
    }

    @PerfUtil.Watched(prefix="index")
    private Set<MatchedIndex> collectMatchedIndexes(ConditionQuery query) {
        ImmutableList schemaLabels;
        SchemaTransaction schema = this.graph().schemaTransaction();
        Id label = (Id)query.condition((Object)HugeKeys.LABEL);
        if (label != null) {
            SchemaLabel schemaLabel;
            if (query.resultType().isVertex()) {
                schemaLabel = schema.getVertexLabel(label);
            } else if (query.resultType().isEdge()) {
                schemaLabel = schema.getEdgeLabel(label);
            } else {
                throw new AssertionError((Object)String.format("Unsupported index query type: %s", query.resultType()));
            }
            schemaLabels = ImmutableList.of((Object)schemaLabel);
        } else if (query.resultType().isVertex()) {
            schemaLabels = schema.getVertexLabels();
        } else if (query.resultType().isEdge()) {
            schemaLabels = schema.getEdgeLabels();
        } else {
            throw new AssertionError((Object)String.format("Unsupported index query type: %s", query.resultType()));
        }
        Set matchedIndexes = InsertionOrderUtil.newSet();
        for (SchemaLabel schemaLabel : schemaLabels) {
            MatchedIndex index = this.collectMatchedIndex(schemaLabel, query);
            if (index == null) continue;
            matchedIndexes.add(index);
        }
        return matchedIndexes;
    }

    @PerfUtil.Watched(prefix="index")
    private MatchedIndex collectMatchedIndex(SchemaLabel schemaLabel, ConditionQuery query) {
        SchemaTransaction schema = this.graph().schemaTransaction();
        Set ils = InsertionOrderUtil.newSet();
        for (Id il : schemaLabel.indexLabels()) {
            ils.add(schema.getIndexLabel(il));
        }
        if (ils.isEmpty()) {
            return null;
        }
        Set<IndexLabel> matchedILs = GraphIndexTransaction.matchSingleOrCompositeIndex(query, ils);
        if (matchedILs.isEmpty()) {
            matchedILs = GraphIndexTransaction.matchJointIndexes(query, ils);
        }
        if (!matchedILs.isEmpty()) {
            return new MatchedIndex(schemaLabel, matchedILs);
        }
        return null;
    }

    private static Set<IndexLabel> matchSingleOrCompositeIndex(ConditionQuery query, Set<IndexLabel> indexLabels) {
        boolean reqiureRange = query.hasRangeCondition();
        boolean reqiureSearch = query.hasSearchCondition();
        Set<Id> queryPropKeys = query.userpropKeys();
        for (IndexLabel indexLabel : indexLabels) {
            List<Id> indexFields = indexLabel.indexFields();
            if (!GraphIndexTransaction.matchIndexFields(queryPropKeys, indexFields)) continue;
            IndexType indexType = indexLabel.indexType();
            if (reqiureSearch && indexType != IndexType.SEARCH || !reqiureSearch && indexType == IndexType.SEARCH || reqiureRange && indexType != IndexType.RANGE) continue;
            return ImmutableSet.of((Object)indexLabel);
        }
        return ImmutableSet.of();
    }

    private static Set<IndexLabel> matchJointIndexes(ConditionQuery query, Set<IndexLabel> indexLabels) {
        Set<Id> queryPropKeys = query.userpropKeys();
        assert (!queryPropKeys.isEmpty());
        Set allILs = InsertionOrderUtil.newSet(indexLabels);
        Set<IndexLabel> matchedIndexLabels = InsertionOrderUtil.newSet();
        if (query.hasRangeCondition() || query.hasSearchCondition()) {
            matchedIndexLabels = GraphIndexTransaction.matchRangeOrSearchIndexLabels(query, allILs);
            if (matchedIndexLabels.isEmpty()) {
                return ImmutableSet.of();
            }
            allILs.removeAll(matchedIndexLabels);
            for (IndexLabel il : matchedIndexLabels) {
                queryPropKeys.remove(il.indexField());
            }
            if (queryPropKeys.isEmpty()) {
                return matchedIndexLabels;
            }
        }
        Set indexFields = InsertionOrderUtil.newSet();
        for (IndexLabel indexLabel : allILs) {
            if (indexLabel.indexType() == IndexType.SEARCH) continue;
            List<Id> fields = indexLabel.indexFields();
            for (Id field : fields) {
                if (!queryPropKeys.contains(field)) break;
                matchedIndexLabels.add(indexLabel);
                indexFields.add(field);
            }
        }
        if (indexFields.equals(queryPropKeys)) {
            return matchedIndexLabels;
        }
        return ImmutableSet.of();
    }

    private static Set<IndexLabel> matchRangeOrSearchIndexLabels(ConditionQuery query, Set<IndexLabel> indexLabels) {
        Set matchedIndexLabels = InsertionOrderUtil.newSet();
        for (Condition.Relation relation : query.userpropRelations()) {
            if (!relation.relation().isRangeType() && !relation.relation().isSearchType()) continue;
            Id key = (Id)relation.key();
            boolean matched = false;
            for (IndexLabel indexLabel : indexLabels) {
                if (indexLabel.indexType() != IndexType.RANGE && indexLabel.indexType() != IndexType.SEARCH || !indexLabel.indexField().equals(key)) continue;
                matched = true;
                matchedIndexLabels.add(indexLabel);
                break;
            }
            if (matched) continue;
            return ImmutableSet.of();
        }
        return matchedIndexLabels;
    }

    private static IndexQueries buildJointIndexesQueries(ConditionQuery query, MatchedIndex index) {
        IndexQueries queries = new IndexQueries();
        ArrayList<IndexLabel> allILs = new ArrayList<IndexLabel>(index.indexLabels());
        if (query.hasRangeCondition() || query.hasSearchCondition()) {
            Set<IndexLabel> matchedILs = GraphIndexTransaction.matchRangeOrSearchIndexLabels(query, index.indexLabels());
            assert (!matchedILs.isEmpty());
            allILs.removeAll(matchedILs);
            Set queryPropKeys = InsertionOrderUtil.newSet();
            for (IndexLabel il : matchedILs) {
                queryPropKeys.add(il.indexField());
            }
            queries.putAll(GraphIndexTransaction.constructQueries(query, matchedILs, queryPropKeys));
            query = query.copy();
            for (Id field : queryPropKeys) {
                query.unsetCondition(field);
            }
            if (query.userpropKeys().isEmpty()) {
                return queries;
            }
        }
        ConditionQuery q = query;
        int size = allILs.size();
        for (int i = 1; i <= size; ++i) {
            boolean found = GraphIndexTransaction.cmn(allILs, size, i, 0, null, r -> {
                IndexQueries qs = GraphIndexTransaction.constructJointSecondaryQueries(q, r);
                if (qs.isEmpty()) {
                    return false;
                }
                queries.putAll(qs);
                return true;
            });
            if (!found) continue;
            return queries;
        }
        return IndexQueries.EMPTY;
    }

    private static <T> boolean cmn(List<T> all, int m, int n, int current, List<T> result, java.util.function.Function<List<T>, Boolean> callback) {
        assert (m <= all.size());
        assert (n <= m);
        assert (current <= all.size());
        if (result == null) {
            result = new ArrayList<T>(n);
        }
        if (m == n) {
            result.addAll(all.subList(current, all.size()));
            n = 0;
        }
        if (n == 0) {
            return callback.apply(result);
        }
        if (current >= all.size()) {
            return false;
        }
        int index = result.size();
        result.add(all.get(current));
        if (GraphIndexTransaction.cmn(all, m - 1, n - 1, ++current, result, callback)) {
            return true;
        }
        result.remove(index);
        return GraphIndexTransaction.cmn(all, m - 1, n, current, result, callback);
    }

    private static IndexQueries constructJointSecondaryQueries(ConditionQuery query, List<IndexLabel> ils) {
        Set<IndexLabel> indexLabels = InsertionOrderUtil.newSet();
        indexLabels.addAll(ils);
        indexLabels = GraphIndexTransaction.matchJointIndexes(query, indexLabels);
        if (indexLabels.isEmpty()) {
            return IndexQueries.EMPTY;
        }
        return GraphIndexTransaction.constructQueries(query, indexLabels, query.userpropKeys());
    }

    private static IndexQueries constructQueries(ConditionQuery query, Set<IndexLabel> ils, Set<Id> propKeys) {
        IndexQueries queries = new IndexQueries();
        for (IndexLabel il : ils) {
            List<Id> fields = il.indexFields();
            ConditionQuery newQuery = query.copy();
            newQuery.resetUserpropConditions();
            for (Id field : fields) {
                if (!propKeys.contains(field)) break;
                for (Condition c : query.userpropConditions(field)) {
                    newQuery.query(c);
                }
            }
            ConditionQuery q = GraphIndexTransaction.matchIndexLabel(newQuery, il);
            assert (q != null);
            queries.put(il, q);
        }
        return queries;
    }

    private static ConditionQuery matchIndexLabel(ConditionQuery query, IndexLabel indexLabel) {
        ConditionQuery indexQuery;
        List<Id> indexFields;
        boolean isRange;
        IndexType indexType = indexLabel.indexType();
        boolean requireRange = query.hasRangeCondition();
        boolean bl = isRange = indexType == IndexType.RANGE;
        if (requireRange && !isRange) {
            LOG.debug("There is range query condition in '{}',but the index label '{}' is unable to match", (Object)query, (Object)indexLabel.name());
            return null;
        }
        Set<Id> queryKeys = query.userpropKeys();
        if (!GraphIndexTransaction.matchIndexFields(queryKeys, indexFields = indexLabel.indexFields())) {
            return null;
        }
        LOG.debug("Matched index fields: {} of index '{}'", indexFields, (Object)indexLabel);
        switch (indexType) {
            case SEARCH: {
                E.checkState((indexFields.size() == 1 ? 1 : 0) != 0, (String)"Invalid index fields size for %s: %s", (Object[])new Object[]{indexType, indexFields});
                Object fieldValue = query.userpropValue(indexFields.get(0));
                indexQuery = new ConditionQuery(indexType.type(), query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                indexQuery.eq(HugeKeys.FIELD_VALUES, fieldValue);
                break;
            }
            case SECONDARY: {
                List<Id> joinedKeys = indexFields.subList(0, queryKeys.size());
                String joinedValues = query.userpropValuesString(joinedKeys);
                if (joinedValues.isEmpty()) {
                    joinedValues = INDEX_EMPTY_SYM;
                }
                indexQuery = new ConditionQuery(indexType.type(), query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                indexQuery.eq(HugeKeys.FIELD_VALUES, joinedValues);
                break;
            }
            case RANGE: {
                if (query.userpropConditions().size() > 2) {
                    throw new BackendException("Range query has two conditions at most, but got: %s", query.userpropConditions());
                }
                indexQuery = new ConditionQuery(indexType.type(), query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                for (Condition condition : query.userpropConditions()) {
                    assert (condition instanceof Condition.Relation);
                    Condition.Relation r = (Condition.Relation)condition;
                    Condition.SyspropRelation sys = new Condition.SyspropRelation(HugeKeys.FIELD_VALUES, r.relation(), NumericUtil.convertToNumber((Object)r.value()));
                    condition = condition.replace(r, sys);
                    indexQuery.query(condition);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown index type '%s'", indexType));
            }
        }
        return indexQuery;
    }

    private static boolean matchIndexFields(Set<Id> queryKeys, List<Id> indexFields) {
        if (queryKeys.size() > indexFields.size()) {
            return false;
        }
        List<Id> subFields = indexFields.subList(0, queryKeys.size());
        return subFields.containsAll(queryKeys);
    }

    private static boolean validQueryConditionValues(HugeGraph graph, ConditionQuery query) {
        Set<Id> keys = query.userpropKeys();
        for (Id key : keys) {
            PropertyKey pk = graph.propertyKey(key);
            Set<Object> values = query.userpropValues(key);
            E.checkState((!values.isEmpty() ? 1 : 0) != 0, (String)"Expect user property values for key '%s', but got none", (Object[])new Object[]{pk});
            for (Object value : values) {
                if (pk.checkValue(value)) continue;
                return false;
            }
        }
        return true;
    }

    private static NoIndexException noIndexException(HugeGraph graph, ConditionQuery query, Id label) {
        String name = label == null ? "any label" : String.format("label '%s'", query.resultType().isVertex() ? graph.vertexLabel(label).name() : graph.edgeLabel(label).name());
        ArrayList<String> mismatched = new ArrayList<String>();
        if (query.hasSecondaryCondition()) {
            mismatched.add("secondary");
        }
        if (query.hasRangeCondition()) {
            mismatched.add("range");
        }
        if (query.hasSearchCondition()) {
            mismatched.add("search");
        }
        return new NoIndexException("Don't accept query based on properties %s that are not indexed in %s, may not match %s condition", graph.mapPkId2Name(query.userpropKeys()), name, String.join((CharSequence)"/", mismatched));
    }

    private static boolean hasNullableProp(HugeElement element, Id key) {
        return element.schemaLabel().nullableKeys().contains(key);
    }

    private static Set<IndexLabel> relatedIndexLabels(HugeElement element) {
        Set indexLabels = InsertionOrderUtil.newSet();
        Set<Id> indexLabelIds = element.schemaLabel().indexLabels();
        for (Id id : indexLabelIds) {
            SchemaTransaction schema = element.graph().schemaTransaction();
            IndexLabel indexLabel = schema.getIndexLabel(id);
            indexLabels.add(indexLabel);
        }
        return indexLabels;
    }

    private static Set<Id> limit(Set<Id> ids, Query query) {
        long fromIndex = query.offset();
        E.checkArgument((fromIndex <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Offset must be <= 0x7fffffff, but got '%s'", (Object[])new Object[]{fromIndex});
        if (query.offset() >= (long)ids.size()) {
            return ImmutableSet.of();
        }
        if (query.limit() == Long.MAX_VALUE && query.offset() == 0L) {
            return ids;
        }
        long toIndex = query.offset() + query.limit();
        if (query.limit() == Long.MAX_VALUE || toIndex > (long)ids.size()) {
            toIndex = ids.size();
        }
        assert (fromIndex < (long)ids.size());
        assert (toIndex <= (long)ids.size());
        return CollectionUtil.subSet(ids, (int)((int)fromIndex), (int)((int)toIndex));
    }

    public void removeIndex(IndexLabel indexLabel) {
        HugeIndex index = new HugeIndex(indexLabel);
        this.doRemove(this.serializer.writeIndex(index));
    }

    public static enum OptimizedType {
        NONE,
        PRIMARY_KEY,
        SORT_KEY,
        INDEX;

    }

    private static class IndexQueries
    extends HashMap<IndexLabel, ConditionQuery> {
        private static final long serialVersionUID = 1400326138090922676L;
        public static final IndexQueries EMPTY = new IndexQueries();

        private IndexQueries() {
        }

        public static IndexQueries of(IndexLabel il, ConditionQuery query) {
            IndexQueries indexQueries = new IndexQueries();
            indexQueries.put(il, query);
            return indexQueries;
        }
    }

    private static class MatchedIndex {
        private SchemaLabel schemaLabel;
        private Set<IndexLabel> indexLabels;

        public MatchedIndex(SchemaLabel schemaLabel, Set<IndexLabel> indexLabels) {
            this.schemaLabel = schemaLabel;
            this.indexLabels = indexLabels;
        }

        public SchemaLabel schemaLabel() {
            return this.schemaLabel;
        }

        public Set<IndexLabel> indexLabels() {
            return Collections.unmodifiableSet(this.indexLabels);
        }

        public IndexQueries constructIndexQueries(ConditionQuery query) {
            if (this.indexLabels().size() == 1) {
                IndexLabel il = this.indexLabels().iterator().next();
                ConditionQuery indexQuery = GraphIndexTransaction.matchIndexLabel(query, il);
                assert (indexQuery != null);
                indexQuery.limit(query.total());
                return IndexQueries.of(il, indexQuery);
            }
            IndexQueries queries = GraphIndexTransaction.buildJointIndexesQueries(query, this);
            assert (!queries.isEmpty());
            return queries;
        }

        public boolean containsSearchIndex() {
            for (IndexLabel il : this.indexLabels) {
                if (il.indexType() != IndexType.SEARCH) continue;
                return true;
            }
            return false;
        }
    }
}

