/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.tx;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.ConditionQueryFlatten;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendMutation;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.tx.AbstractTransaction;
import com.baidu.hugegraph.backend.tx.GraphIndexTransaction;
import com.baidu.hugegraph.backend.tx.IndexableTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.exception.LimitExceedException;
import com.baidu.hugegraph.iterator.ExtendableIterator;
import com.baidu.hugegraph.iterator.FilterIterator;
import com.baidu.hugegraph.iterator.FlatMapperIterator;
import com.baidu.hugegraph.iterator.MapperIterator;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeEdgeProperty;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.structure.HugeFeatures;
import com.baidu.hugegraph.structure.HugeProperty;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.structure.HugeVertexProperty;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.type.define.IdStrategy;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.baidu.hugegraph.util.LockUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;

public class GraphTransaction
extends IndexableTransaction {
    public static final int COMMIT_BATCH = 500;
    private final GraphIndexTransaction indexTx;
    private Map<Id, HugeVertex> addedVertexes;
    private Map<Id, HugeVertex> removedVertexes;
    private Map<Id, HugeEdge> addedEdges;
    private Map<Id, HugeEdge> removedEdges;
    private Map<Id, HugeVertex> updatedVertexes;
    private Map<Id, HugeEdge> updatedEdges;
    private Set<HugeProperty<?>> updatedProps;
    private LockUtil.LocksTable locksTable;
    private final boolean checkVertexExist;
    private final int vertexesCapacity;
    private final int edgesCapacity;

    public GraphTransaction(HugeGraph graph, BackendStore store) {
        super(graph, store);
        this.indexTx = new GraphIndexTransaction(graph, store);
        assert (!this.indexTx.autoCommit());
        HugeConfig conf = graph.configuration();
        this.checkVertexExist = (Boolean)conf.get(CoreOptions.VERTEX_CHECK_CUSTOMIZED_ID_EXIST);
        this.vertexesCapacity = (Integer)conf.get(CoreOptions.VERTEX_TX_CAPACITY);
        this.edgesCapacity = (Integer)conf.get(CoreOptions.EDGE_TX_CAPACITY);
        this.locksTable = new LockUtil.LocksTable(graph.name());
    }

    @Override
    public boolean hasUpdates() {
        return this.mutationSize() > 0 || super.hasUpdates();
    }

    @Override
    public int mutationSize() {
        return this.verticesInTxSize() + this.edgesInTxSize();
    }

    @Override
    protected void reset() {
        super.reset();
        this.addedVertexes = InsertionOrderUtil.newMap();
        this.removedVertexes = InsertionOrderUtil.newMap();
        this.updatedVertexes = InsertionOrderUtil.newMap();
        this.addedEdges = InsertionOrderUtil.newMap();
        this.removedEdges = InsertionOrderUtil.newMap();
        this.updatedEdges = InsertionOrderUtil.newMap();
        this.updatedProps = InsertionOrderUtil.newSet();
    }

    @Override
    protected AbstractTransaction indexTransaction() {
        return this.indexTx;
    }

    @Override
    protected void beforeWrite() {
        this.checkTxVerticesCapacity();
        this.checkTxEdgesCapacity();
        super.beforeWrite();
    }

    protected final int verticesInTxSize() {
        return this.addedVertexes.size() + this.removedVertexes.size() + this.updatedVertexes.size();
    }

    protected final int edgesInTxSize() {
        return this.addedEdges.size() + this.removedEdges.size() + this.updatedEdges.size();
    }

    protected final Collection<HugeVertex> verticesInTxUpdated() {
        int size = this.addedVertexes.size() + this.updatedVertexes.size();
        ArrayList<HugeVertex> vertices = new ArrayList<HugeVertex>(size);
        vertices.addAll(this.addedVertexes.values());
        vertices.addAll(this.updatedVertexes.values());
        return vertices;
    }

    protected final Collection<HugeVertex> verticesInTxRemoved() {
        return new ArrayList<HugeVertex>(this.removedVertexes.values());
    }

    protected final boolean removingEdgeOwner(HugeEdge edge) {
        for (HugeVertex vertex : this.removedVertexes.values()) {
            if (!edge.belongToVertex(vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    @PerfUtil.Watched(prefix="tx")
    protected BackendMutation prepareCommit() {
        if (this.removedVertexes.size() > 0 || this.removedEdges.size() > 0) {
            this.prepareDeletions(this.removedVertexes, this.removedEdges);
        }
        if (this.addedVertexes.size() > 0 || this.addedEdges.size() > 0) {
            this.prepareAdditions(this.addedVertexes, this.addedEdges);
        }
        return this.mutation();
    }

    protected void prepareAdditions(Map<Id, HugeVertex> addedVertexes, Map<Id, HugeEdge> addedEdges) {
        if (this.checkVertexExist) {
            this.checkVertexExistIfCustomizedId(addedVertexes);
        }
        for (HugeVertex v : addedVertexes.values()) {
            assert (!v.removed());
            v.committed();
            this.doInsert(this.serializer.writeVertex(v));
            this.indexTx.updateVertexIndex(v, false);
            this.indexTx.updateLabelIndex(v, false);
        }
        for (HugeEdge e : addedEdges.values()) {
            assert (!e.removed());
            e.committed();
            if (this.removingEdgeOwner(e)) continue;
            this.doInsert(this.serializer.writeEdge(e));
            this.doInsert(this.serializer.writeEdge(e.switchOwner()));
            this.indexTx.updateEdgeIndex(e, false);
            this.indexTx.updateLabelIndex(e, false);
        }
    }

    protected void prepareDeletions(Map<Id, HugeVertex> removedVertexes, Map<Id, HugeEdge> removedEdges) {
        for (HugeVertex v : removedVertexes.values()) {
            ConditionQuery query = GraphTransaction.constructEdgesQuery(v.id(), Directions.BOTH, new Id[0]);
            Iterator<HugeEdge> vedges = this.queryEdgesFromBackend(query);
            while (vedges.hasNext()) {
                this.checkTxEdgesCapacity();
                HugeEdge edge = vedges.next();
                removedEdges.put(edge.id(), edge);
            }
        }
        for (HugeVertex v : removedVertexes.values()) {
            this.doRemove(this.serializer.writeVertex(v.prepareRemoved()));
            this.indexTx.updateVertexIndex(v, true);
            this.indexTx.updateLabelIndex(v, true);
        }
        for (HugeEdge e : removedEdges.values()) {
            this.indexTx.updateEdgeIndex(e, true);
            this.indexTx.updateLabelIndex(e, true);
            e = e.prepareRemoved();
            this.doRemove(this.serializer.writeEdge(e));
            this.doRemove(this.serializer.writeEdge(e.switchOwner()));
        }
    }

    @Override
    public void commit() throws BackendException {
        try {
            super.commit();
        }
        finally {
            this.locksTable.unlock();
        }
    }

    @Override
    public void rollback() throws BackendException {
        for (HugeProperty<?> prop : this.updatedProps) {
            prop.element().setProperty(prop);
        }
        try {
            super.rollback();
        }
        finally {
            this.locksTable.unlock();
        }
    }

    @Override
    public Iterator<BackendEntry> query(Query query) {
        if (!(query instanceof ConditionQuery)) {
            return super.query(query);
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        for (ConditionQuery cq : ConditionQueryFlatten.flatten((ConditionQuery)query)) {
            Query q = this.optimizeQuery(cq);
            if (q.empty()) continue;
            queries.add(q);
        }
        ExtendableIterator rs = new ExtendableIterator();
        for (Query q : queries) {
            rs.extend(super.query(q));
        }
        return rs;
    }

    @PerfUtil.Watched(prefix="graph")
    public HugeVertex addVertex(Object ... keyValues) {
        return this.addVertex(this.constructVertex(true, keyValues));
    }

    @PerfUtil.Watched(value="graph.addVertex-instance")
    public HugeVertex addVertex(HugeVertex vertex) {
        this.checkOwnerThread();
        this.removedVertexes.remove(vertex.id());
        try {
            this.locksTable.lockReads("vl_delete", vertex.schemaLabel().id());
            this.locksTable.lockReads("il_delete", vertex.schemaLabel().indexLabels());
            this.graph().vertexLabel(vertex.schemaLabel().id());
            this.beforeWrite();
            this.addedVertexes.put(vertex.id(), vertex);
            this.afterWrite();
        }
        catch (Throwable e) {
            this.locksTable.unlock();
            throw e;
        }
        return vertex;
    }

    @PerfUtil.Watched(prefix="graph")
    public HugeVertex constructVertex(boolean verifyVL, Object ... keyValues) {
        HugeElement.ElementKeys elemKeys = HugeElement.classifyKeys(keyValues);
        VertexLabel vertexLabel = this.checkVertexLabel(elemKeys.label(), verifyVL);
        Id id = HugeVertex.getIdValue(elemKeys.id());
        List<Id> keys = this.graph().mapPkName2Id(elemKeys.keys());
        this.checkId(id, keys, vertexLabel);
        this.checkNonnullProperty(keys, vertexLabel);
        HugeVertex vertex = new HugeVertex(this, null, vertexLabel);
        ElementHelper.attachProperties((Vertex)vertex, (Object[])keyValues);
        if (this.graph().mode().maintaining() && vertexLabel.idStrategy() == IdStrategy.AUTOMATIC) {
            vertex.assignId(id, true);
        } else {
            vertex.assignId(id);
        }
        return vertex;
    }

    @PerfUtil.Watched(prefix="graph")
    public void removeVertex(HugeVertex vertex) {
        this.checkOwnerThread();
        this.beforeWrite();
        this.addedVertexes.remove(vertex.id());
        this.removedVertexes.put(vertex.id(), vertex);
        this.afterWrite();
    }

    public Iterator<Vertex> queryAdjacentVertices(Iterator<Edge> edges) {
        if (!edges.hasNext()) {
            return Collections.emptyIterator();
        }
        ArrayList<Id> vertexIds = new ArrayList<Id>();
        while (edges.hasNext()) {
            HugeEdge edge = (HugeEdge)edges.next();
            vertexIds.add(edge.otherVertex().id());
        }
        return this.queryVertices(vertexIds.toArray());
    }

    public Iterator<Vertex> queryVertices(Object ... vertexIds) {
        List ids = InsertionOrderUtil.newList();
        Map vertices = InsertionOrderUtil.newMap();
        IdQuery query = new IdQuery(HugeType.VERTEX);
        for (Object vertexId : vertexIds) {
            Id id2 = HugeVertex.getIdValue(vertexId);
            if (id2 == null || this.removedVertexes.containsKey(id2)) continue;
            HugeVertex vertex = this.addedVertexes.get(id2);
            if (vertex != null || (vertex = this.updatedVertexes.get(id2)) != null) {
                vertices.put(vertex.id(), vertex);
            } else {
                query.query(id2);
            }
            ids.add(id2);
        }
        if (!query.empty()) {
            Iterator<HugeVertex> it = this.queryVerticesFromBackend(query);
            while (it.hasNext()) {
                HugeVertex vertex = it.next();
                vertices.put(vertex.id(), vertex);
            }
        }
        return new MapperIterator(ids.iterator(), id -> (Vertex)vertices.get(id));
    }

    public Iterator<Vertex> queryVertices() {
        Query q = new Query(HugeType.VERTEX);
        return this.queryVertices(q);
    }

    public Iterator<Vertex> queryVertices(Query query) {
        FilterIterator results = this.queryVerticesFromBackend(query);
        results = new FilterIterator(results, vertex -> {
            assert (vertex.schemaLabel() != VertexLabel.NONE);
            if (!query.showHidden() && Graph.Hidden.isHidden((String)vertex.label())) {
                return false;
            }
            if (query.resultType().isVertex() && !this.filterResultFromIndexQuery(query, (HugeElement)vertex)) {
                return false;
            }
            return true;
        });
        Iterator<Vertex> r = this.joinTxVertices(query, (Iterator<HugeVertex>)results);
        return r;
    }

    protected Iterator<HugeVertex> queryVerticesFromBackend(Query query) {
        assert (query.resultType().isVertex());
        Iterator<BackendEntry> entries = this.query(query);
        return new MapperIterator(entries, entry -> {
            HugeVertex vertex = this.serializer.readVertex(this.graph(), (BackendEntry)entry);
            assert (vertex != null);
            return vertex;
        });
    }

    @PerfUtil.Watched(prefix="graph")
    public HugeEdge addEdge(HugeEdge edge) {
        this.checkOwnerThread();
        this.removedEdges.remove(edge.id());
        try {
            this.locksTable.lockReads("el_delete", edge.schemaLabel().id());
            this.locksTable.lockReads("il_delete", edge.schemaLabel().indexLabels());
            this.graph().edgeLabel(edge.schemaLabel().id());
            this.beforeWrite();
            this.addedEdges.put(edge.id(), edge);
            this.afterWrite();
        }
        catch (Throwable e) {
            this.locksTable.unlock();
            throw e;
        }
        return edge;
    }

    @PerfUtil.Watched(prefix="graph")
    public void removeEdge(HugeEdge edge) {
        this.checkOwnerThread();
        this.beforeWrite();
        this.addedEdges.remove(edge.id());
        this.removedEdges.put(edge.id(), edge);
        this.afterWrite();
    }

    public Iterator<Edge> queryEdgesByVertex(Id id) {
        return this.queryEdges(GraphTransaction.constructEdgesQuery(id, Directions.BOTH, new Id[0]));
    }

    public Iterator<Edge> queryEdges(Object ... edgeIds) {
        List ids = InsertionOrderUtil.newList();
        Map edges = InsertionOrderUtil.newMap();
        IdQuery query = new IdQuery(HugeType.EDGE);
        for (Object edgeId : edgeIds) {
            Id id2 = HugeEdge.getIdValue(edgeId);
            if (id2 == null || this.removedEdges.containsKey(id2)) continue;
            HugeEdge edge = this.addedEdges.get(id2);
            if (edge != null || (edge = this.updatedEdges.get(id2)) != null) {
                edges.put(edge.id(), edge);
            } else {
                query.query(id2);
            }
            ids.add(id2);
        }
        if (!query.empty()) {
            Iterator<HugeEdge> it = this.queryEdgesFromBackend(query);
            while (it.hasNext()) {
                HugeEdge edge = it.next();
                edges.put(edge.id(), edge);
            }
        }
        return new MapperIterator(ids.iterator(), id -> (Edge)edges.get(id));
    }

    public Iterator<Edge> queryEdges() {
        Query q = new Query(HugeType.EDGE);
        return this.queryEdges(q);
    }

    public Iterator<Edge> queryEdges(Query query) {
        FilterIterator results = this.queryEdgesFromBackend(query);
        HashSet returnedEdges = new HashSet();
        results = new FilterIterator(results, edge -> {
            if (!query.showHidden() && Graph.Hidden.isHidden((String)edge.label())) {
                return false;
            }
            if (!this.filterResultFromIndexQuery(query, (HugeElement)edge)) {
                return false;
            }
            if (!returnedEdges.contains(edge.id())) {
                returnedEdges.add(edge.id());
                return true;
            }
            LOG.debug("Result contains duplicated edge: {}", edge);
            return false;
        });
        Iterator<Edge> r = this.joinTxEdges(query, (Iterator<HugeEdge>)results, this.removedVertexes);
        return r;
    }

    protected Iterator<HugeEdge> queryEdgesFromBackend(Query query) {
        assert (query.resultType().isEdge());
        Iterator<BackendEntry> entries = this.query(query);
        return new FlatMapperIterator(entries, entry -> {
            HugeVertex vertex = this.serializer.readVertex(this.graph(), (BackendEntry)entry);
            assert (vertex != null);
            if (query.ids().size() == 1) assert (vertex.getEdges().size() == 1);
            return ImmutableList.copyOf(vertex.getEdges()).iterator();
        });
    }

    @PerfUtil.Watched(prefix="graph")
    public <V> void addVertexProperty(HugeVertexProperty<V> prop) {
        HugeVertex vertex = prop.element();
        E.checkState((vertex != null ? 1 : 0) != 0, (String)"No owner for updating property '%s'", (Object[])new Object[]{prop.key()});
        if (vertex.fresh()) {
            vertex.setProperty(prop);
            return;
        }
        E.checkArgument((!this.addedVertexes.containsKey(vertex.id()) || this.updatedVertexes.containsKey(vertex.id()) ? 1 : 0) != 0, (String)"Can't update property '%s' for adding-state vertex", (Object[])new Object[]{prop.key()});
        E.checkArgument((!vertex.removed() && !this.removedVertexes.containsKey(vertex.id()) ? 1 : 0) != 0, (String)"Can't update property '%s' for removing-state vertex", (Object[])new Object[]{prop.key()});
        List<Id> primaryKeyIds = vertex.schemaLabel().primaryKeys();
        E.checkArgument((!primaryKeyIds.contains(prop.propertyKey().id()) ? 1 : 0) != 0, (String)"Can't update primary key: '%s'", (Object[])new Object[]{prop.key()});
        this.lockForUpdateProperty(vertex.schemaLabel(), prop, () -> {
            this.indexTx.updateVertexIndex(vertex, true);
            this.propertyUpdated(vertex, vertex.setProperty(prop));
            this.indexTx.updateVertexIndex(vertex, false);
            if (this.store().features().supportsUpdateVertexProperty()) {
                this.doAppend(this.serializer.writeVertexProperty(prop));
            } else {
                this.addVertex(vertex);
            }
        });
    }

    @PerfUtil.Watched(prefix="graph")
    public <V> void removeVertexProperty(HugeVertexProperty<V> prop) {
        HugeVertex vertex = prop.element();
        PropertyKey propKey = prop.propertyKey();
        E.checkState((vertex != null ? 1 : 0) != 0, (String)"No owner for removing property '%s'", (Object[])new Object[]{prop.key()});
        if (!vertex.hasProperty(propKey.id())) {
            return;
        }
        List<Id> primaryKeyIds = vertex.schemaLabel().primaryKeys();
        E.checkArgument((!primaryKeyIds.contains(propKey.id()) ? 1 : 0) != 0, (String)"Can't remove primary key '%s'", (Object[])new Object[]{prop.key()});
        if (vertex.fresh()) {
            vertex.removeProperty(propKey.id());
            return;
        }
        E.checkArgument((!this.addedVertexes.containsKey(vertex.id()) || this.updatedVertexes.containsKey(vertex.id()) ? 1 : 0) != 0, (String)"Can't remove property '%s' for adding-state vertex", (Object[])new Object[]{prop.key()});
        E.checkArgument((!this.removedVertexes.containsKey(vertex.id()) ? 1 : 0) != 0, (String)"Can't remove property '%s' for removing-state vertex", (Object[])new Object[]{prop.key()});
        this.lockForUpdateProperty(vertex.schemaLabel(), prop, () -> {
            this.indexTx.updateVertexIndex(vertex, true);
            this.propertyUpdated(vertex, vertex.removeProperty(propKey.id()));
            this.indexTx.updateVertexIndex(vertex, false);
            if (this.store().features().supportsUpdateVertexProperty()) {
                this.doEliminate(this.serializer.writeVertexProperty(prop));
            } else {
                this.addVertex(vertex);
            }
        });
    }

    @PerfUtil.Watched(prefix="graph")
    public <V> void addEdgeProperty(HugeEdgeProperty<V> prop) {
        HugeEdge edge = prop.element();
        E.checkState((edge != null ? 1 : 0) != 0, (String)"No owner for updating property '%s'", (Object[])new Object[]{prop.key()});
        if (edge.fresh()) {
            edge.setProperty(prop);
            return;
        }
        E.checkArgument((!this.addedEdges.containsKey(edge.id()) || this.updatedEdges.containsKey(edge.id()) ? 1 : 0) != 0, (String)"Can't update property '%s' for adding-state edge", (Object[])new Object[]{prop.key()});
        E.checkArgument((!edge.removed() && !this.removedEdges.containsKey(edge.id()) ? 1 : 0) != 0, (String)"Can't update property '%s' for removing-state edge", (Object[])new Object[]{prop.key()});
        List<Id> sortKeys = edge.schemaLabel().sortKeys();
        E.checkArgument((!sortKeys.contains(prop.propertyKey().id()) ? 1 : 0) != 0, (String)"Can't update sort key '%s'", (Object[])new Object[]{prop.key()});
        this.lockForUpdateProperty(edge.schemaLabel(), prop, () -> {
            this.indexTx.updateEdgeIndex(edge, true);
            this.propertyUpdated(edge, edge.setProperty(prop));
            this.indexTx.updateEdgeIndex(edge, false);
            if (this.store().features().supportsUpdateEdgeProperty()) {
                this.doAppend(this.serializer.writeEdgeProperty(prop));
                this.doAppend(this.serializer.writeEdgeProperty(prop.switchEdgeOwner()));
            } else {
                this.addEdge(edge);
            }
        });
    }

    @PerfUtil.Watched(prefix="graph")
    public <V> void removeEdgeProperty(HugeEdgeProperty<V> prop) {
        HugeEdge edge = prop.element();
        PropertyKey propKey = prop.propertyKey();
        E.checkState((edge != null ? 1 : 0) != 0, (String)"No owner for removing property '%s'", (Object[])new Object[]{prop.key()});
        if (!edge.hasProperty(propKey.id())) {
            return;
        }
        List<Id> sortKeyIds = edge.schemaLabel().sortKeys();
        E.checkArgument((!sortKeyIds.contains(prop.propertyKey().id()) ? 1 : 0) != 0, (String)"Can't remove sort key '%s'", (Object[])new Object[]{prop.key()});
        if (edge.fresh()) {
            edge.removeProperty(propKey.id());
            return;
        }
        E.checkArgument((!this.addedEdges.containsKey(edge.id()) || this.updatedEdges.containsKey(edge.id()) ? 1 : 0) != 0, (String)"Can't remove property '%s' for adding-state edge", (Object[])new Object[]{prop.key()});
        E.checkArgument((!this.removedEdges.containsKey(edge.id()) ? 1 : 0) != 0, (String)"Can't remove property '%s' for removing-state edge", (Object[])new Object[]{prop.key()});
        this.lockForUpdateProperty(edge.schemaLabel(), prop, () -> {
            this.indexTx.updateEdgeIndex(edge, true);
            this.propertyUpdated(edge, edge.removeProperty(propKey.id()));
            this.indexTx.updateEdgeIndex(edge, false);
            if (this.store().features().supportsUpdateEdgeProperty()) {
                this.doEliminate(this.serializer.writeEdgeProperty(prop));
                this.doEliminate(this.serializer.writeEdgeProperty(prop.switchEdgeOwner()));
            } else {
                this.addEdge(edge);
            }
        });
    }

    public static ConditionQuery constructEdgesQuery(Id sourceVertex, Directions direction, Id ... edgeLabels) {
        E.checkState((sourceVertex != null ? 1 : 0) != 0, (String)"The edge query must contain source vertex", (Object[])new Object[0]);
        E.checkState((direction != null ? 1 : 0) != 0, (String)"The edge query must contain direction", (Object[])new Object[0]);
        ConditionQuery query = new ConditionQuery(HugeType.EDGE);
        query.eq(HugeKeys.OWNER_VERTEX, sourceVertex);
        if (direction == Directions.BOTH) {
            query.query(Condition.or(Condition.eq(HugeKeys.DIRECTION, (Object)Directions.OUT), Condition.eq(HugeKeys.DIRECTION, (Object)Directions.IN)));
        } else {
            assert (direction == Directions.OUT || direction == Directions.IN);
            query.eq(HugeKeys.DIRECTION, direction);
        }
        if (edgeLabels.length == 1) {
            query.eq(HugeKeys.LABEL, edgeLabels[0]);
        } else if (edgeLabels.length > 1) {
            query.query(Condition.in(HugeKeys.LABEL, Arrays.asList(edgeLabels)));
        } else assert (edgeLabels.length == 0);
        return query;
    }

    public static boolean matchEdgeSortKeys(ConditionQuery query, HugeGraph graph) {
        assert (query.resultType().isEdge());
        Id label = (Id)query.condition((Object)HugeKeys.LABEL);
        if (label == null) {
            return false;
        }
        List<Id> keys = graph.edgeLabel(label).sortKeys();
        return !keys.isEmpty() && query.matchUserpropKeys(keys);
    }

    public static void verifyEdgesConditionQuery(ConditionQuery query) {
        HugeKeys key;
        Object value;
        assert (query.resultType().isEdge());
        int total = query.conditions().size();
        if (total == 1 && (query.containsCondition(HugeKeys.LABEL) || query.containsScanCondition())) {
            return;
        }
        int matched = 0;
        HugeKeys[] hugeKeysArray = EdgeId.KEYS;
        int n = hugeKeysArray.length;
        for (int i = 0; i < n && (value = query.condition((Object)(key = hugeKeysArray[i]))) != null; ++i) {
            ++matched;
        }
        if (matched != total) {
            throw new BackendException("Not supported querying edges by %s, expect %s", new Object[]{query.conditions(), EdgeId.KEYS[matched]});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query optimizeQuery(ConditionQuery query) {
        VertexLabel vertexLabel;
        Id label = (Id)query.condition((Object)HugeKeys.LABEL);
        if (label != null && query.resultType().isVertex() && (vertexLabel = this.graph().vertexLabel(label)).idStrategy() == IdStrategy.PRIMARY_KEY) {
            List<Id> keys = vertexLabel.primaryKeys();
            E.checkState((!keys.isEmpty() ? 1 : 0) != 0, (String)"The primary keys can't be empty when using '%s' id strategy for vertex label '%s'", (Object[])new Object[]{IdStrategy.PRIMARY_KEY, vertexLabel.name()});
            if (query.matchUserpropKeys(keys)) {
                query.optimized(GraphIndexTransaction.OptimizedType.PRIMARY_KEY.ordinal());
                String primaryValues = query.userpropValuesString(keys);
                LOG.debug("Query vertices by primaryKeys: {}", (Object)query);
                Id id = SplicingIdGenerator.splicing(vertexLabel.id().asString(), primaryValues);
                return new IdQuery((Query)query, id);
            }
        }
        if (label != null && query.resultType().isEdge()) {
            List<Id> keys = this.graph().edgeLabel(label).sortKeys();
            if (query.condition((Object)HugeKeys.OWNER_VERTEX) != null && query.condition((Object)HugeKeys.DIRECTION) != null && !keys.isEmpty() && query.matchUserpropKeys(keys)) {
                query.optimized(GraphIndexTransaction.OptimizedType.SORT_KEY.ordinal());
                query = query.copy();
                query.eq(HugeKeys.SORT_VALUES, query.userpropValuesString(keys));
                query.resetUserpropConditions();
                LOG.debug("Query edges by sortKeys: {}", (Object)query);
                return query;
            }
        }
        if (query.allSysprop()) {
            boolean byLabel;
            if (query.resultType().isEdge()) {
                GraphTransaction.verifyEdgesConditionQuery(query);
            }
            boolean bl = byLabel = label != null && query.conditions().size() == 1;
            if (this.store().features().supportsQueryByLabel() || !byLabel) {
                return query;
            }
        }
        this.beforeRead();
        try {
            Query query2 = this.indexTx.query(query);
            return query2;
        }
        finally {
            this.afterRead();
        }
    }

    private VertexLabel checkVertexLabel(Object label, boolean verifyLabel) {
        HugeFeatures.HugeVertexFeatures features = this.graph().features().vertex();
        if (label == null && features.supportsDefaultLabel()) {
            label = features.defaultLabel();
        }
        if (label == null) {
            throw Element.Exceptions.labelCanNotBeNull();
        }
        E.checkArgument((label instanceof String || label instanceof VertexLabel ? 1 : 0) != 0, (String)"Expect a string or a VertexLabel object as the vertex label argument, but got: '%s'", (Object[])new Object[]{label});
        if (label instanceof String) {
            if (verifyLabel) {
                ElementHelper.validateLabel((String)((String)label));
            }
            label = this.graph().vertexLabel((String)label);
        }
        assert (label instanceof VertexLabel);
        return (VertexLabel)label;
    }

    private void checkId(Id id, List<Id> keys, VertexLabel vertexLabel) {
        IdStrategy strategy = vertexLabel.idStrategy();
        switch (strategy) {
            case PRIMARY_KEY: {
                E.checkArgument((id == null ? 1 : 0) != 0, (String)"Can't customize vertex id when id strategy is '%s' for vertex label '%s'", (Object[])new Object[]{strategy, vertexLabel.name()});
                List<Id> primaryKeys = vertexLabel.primaryKeys();
                E.checkArgument((boolean)keys.containsAll(primaryKeys), (String)"The primary keys: %s of vertex label '%s' must be set when using '%s' id strategy", (Object[])new Object[]{this.graph().mapPkId2Name(primaryKeys), vertexLabel.name(), strategy});
                break;
            }
            case AUTOMATIC: {
                if (this.graph().mode().maintaining()) {
                    E.checkArgument((id != null && id.number() ? 1 : 0) != 0, (String)"Must customize vertex number id when id strategy is '%s' for vertex label '%s' in restoring mode", (Object[])new Object[]{strategy, vertexLabel.name()});
                    break;
                }
                E.checkArgument((id == null ? 1 : 0) != 0, (String)"Can't customize vertex id when id strategy is '%s' for vertex label '%s'", (Object[])new Object[]{strategy, vertexLabel.name()});
                break;
            }
            case CUSTOMIZE_STRING: {
                E.checkArgument((id != null && !id.number() ? 1 : 0) != 0, (String)"Must customize vertex string id when id strategy is '%s' for vertex label '%s'", (Object[])new Object[]{strategy, vertexLabel.name()});
                break;
            }
            case CUSTOMIZE_NUMBER: {
                E.checkArgument((id != null && id.number() ? 1 : 0) != 0, (String)"Must customize vertex number id when id strategy is '%s' for vertex label '%s'", (Object[])new Object[]{strategy, vertexLabel.name()});
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown id strategy: " + strategy));
            }
        }
    }

    private void checkNonnullProperty(List<Id> keys, VertexLabel vertexLabel) {
        Collection nonNullKeys = CollectionUtils.subtract(vertexLabel.properties(), vertexLabel.nullableKeys());
        if (!keys.containsAll(nonNullKeys)) {
            Collection missed = CollectionUtils.subtract((Collection)nonNullKeys, keys);
            HugeGraph graph = this.graph();
            E.checkArgument((boolean)false, (String)"All non-null property keys %s of vertex label '%s' must be setted, missed keys %s", (Object[])new Object[]{graph.mapPkId2Name(nonNullKeys), vertexLabel.name(), graph.mapPkId2Name(missed)});
        }
    }

    private void checkVertexExistIfCustomizedId(Map<Id, HugeVertex> vertices) {
        HashSet<Id> ids = new HashSet<Id>();
        for (HugeVertex vertex : vertices.values()) {
            VertexLabel vl = vertex.schemaLabel();
            if (vl.hidden() || !vl.idStrategy().isCustomized()) continue;
            ids.add(vertex.id());
        }
        if (ids.isEmpty()) {
            return;
        }
        IdQuery idQuery = new IdQuery(HugeType.VERTEX, ids);
        Iterator<HugeVertex> results = this.queryVerticesFromBackend(idQuery);
        if (results.hasNext()) {
            HugeVertex existedVertex = results.next();
            HugeVertex newVertex = vertices.get(existedVertex.id());
            if (!existedVertex.label().equals(newVertex.label())) {
                throw new HugeException("The newly added vertex with id:'%s' label:'%s' is not allowed to insert, because already exist a vertex with same id and different label:'%s'", newVertex.id(), newVertex.label(), existedVertex.label());
            }
        }
    }

    private void lockForUpdateProperty(SchemaLabel schemaLabel, HugeProperty<?> prop, Runnable callback) {
        this.checkOwnerThread();
        Id pkey = prop.propertyKey().id();
        HashSet<Id> indexIds = new HashSet<Id>();
        for (Id il : schemaLabel.indexLabels()) {
            if (!this.graph().indexLabel(il).indexFields().contains(pkey)) continue;
            indexIds.add(il);
        }
        String group = schemaLabel.type() == HugeType.VERTEX_LABEL ? "vl_delete" : "el_delete";
        try {
            this.locksTable.lockReads(group, schemaLabel.id());
            this.locksTable.lockReads("il_delete", indexIds);
            if (schemaLabel.type() == HugeType.VERTEX_LABEL) {
                this.graph().vertexLabel(schemaLabel.id());
            } else {
                assert (schemaLabel.type() == HugeType.EDGE_LABEL);
                this.graph().edgeLabel(schemaLabel.id());
            }
            this.beforeWrite();
            callback.run();
            this.afterWrite();
        }
        catch (Throwable e) {
            this.locksTable.unlock();
            throw e;
        }
    }

    private boolean filterResultFromIndexQuery(Query query, HugeElement elem) {
        if (!(query instanceof ConditionQuery)) {
            return true;
        }
        ConditionQuery cq = (ConditionQuery)query;
        if (cq.optimized() == 0 || cq.test(elem)) {
            return true;
        }
        if (cq.optimized() == GraphIndexTransaction.OptimizedType.INDEX.ordinal()) {
            LOG.info("Remove left index: {}, query: {}", (Object)elem, (Object)cq);
            this.indexTx.removeIndexLeft(cq, elem);
        }
        return false;
    }

    private Iterator<?> joinTxVertices(Query query, Iterator<HugeVertex> vertices) {
        assert (query.resultType().isVertex());
        return this.joinTxRecords(query, vertices, (q, v) -> q.test((HugeElement)v) ? v : null, this.addedVertexes, this.removedVertexes, this.updatedVertexes);
    }

    private Iterator<?> joinTxEdges(Query query, Iterator<HugeEdge> edges, Map<Id, HugeVertex> removingVertexes) {
        assert (query.resultType().isEdge());
        BiFunction<Query, HugeEdge, HugeEdge> matchTxEdges = (q, e) -> {
            assert (q.resultType() == HugeType.EDGE);
            return q.test((HugeElement)e) ? e : (q.test(e = e.switchOwner()) ? e : null);
        };
        edges = this.joinTxRecords(query, edges, matchTxEdges, this.addedEdges, this.removedEdges, this.updatedEdges);
        if (removingVertexes.isEmpty()) {
            return edges;
        }
        return new FilterIterator(edges, edge -> {
            for (HugeVertex v : removingVertexes.values()) {
                if (!edge.belongToVertex(v)) continue;
                return false;
            }
            return true;
        });
    }

    private <V extends HugeElement> Iterator<V> joinTxRecords(Query query, Iterator<V> records, BiFunction<Query, V, V> match, Map<Id, V> addedTxRecords, Map<Id, V> removedTxRecords, Map<Id, V> updatedTxRecords) {
        if (addedTxRecords.isEmpty() && removedTxRecords.isEmpty() && updatedTxRecords.isEmpty()) {
            return records;
        }
        Set txResults = InsertionOrderUtil.newSet();
        for (HugeElement elem2 : addedTxRecords.values()) {
            if (query.reachLimit(txResults.size())) break;
            if ((elem2 = (HugeElement)match.apply(query, elem2)) == null) continue;
            txResults.add(elem2);
        }
        for (HugeElement elem2 : updatedTxRecords.values()) {
            if (query.reachLimit(txResults.size())) break;
            if ((elem2 = (HugeElement)match.apply(query, elem2)) == null) continue;
            txResults.add(elem2);
        }
        FilterIterator backendResults = new FilterIterator(records, elem -> !txResults.contains(elem) && !removedTxRecords.containsKey(elem.id()));
        return new ExtendableIterator(txResults.iterator(), (Iterator)backendResults);
    }

    private void checkTxVerticesCapacity() throws LimitExceedException {
        if (this.verticesInTxSize() >= this.vertexesCapacity) {
            throw new LimitExceedException("Vertices size has reached tx capacity %d", this.vertexesCapacity);
        }
    }

    private void checkTxEdgesCapacity() throws LimitExceedException {
        if (this.edgesInTxSize() >= this.edgesCapacity) {
            throw new LimitExceedException("Edges size has reached tx capacity %d", this.edgesCapacity);
        }
    }

    private void propertyUpdated(HugeVertex vertex, HugeProperty<?> property) {
        this.updatedVertexes.put(vertex.id(), vertex);
        if (property != null) {
            this.updatedProps.add(property);
        }
    }

    private void propertyUpdated(HugeEdge edge, HugeProperty<?> property) {
        this.updatedEdges.put(edge.id(), edge);
        if (property != null) {
            this.updatedProps.add(property);
        }
    }

    public void removeIndex(IndexLabel indexLabel) {
        this.checkOwnerThread();
        this.beforeWrite();
        this.indexTx.removeIndex(indexLabel);
        this.afterWrite();
    }

    public void updateIndex(Id ilId, HugeElement element) {
        this.checkOwnerThread();
        this.beforeWrite();
        this.indexTx.updateIndex(ilId, element, false);
        this.afterWrite();
    }

    public void removeVertices(VertexLabel vertexLabel) {
        if (this.hasUpdates()) {
            throw new BackendException("There are still changes to commit");
        }
        boolean autoCommit = this.autoCommit();
        this.autoCommit(false);
        this.commit();
        try {
            this.traverseVerticesByLabel(vertexLabel, vertex -> {
                this.removeVertex((HugeVertex)vertex);
                this.commitIfGtSize(500);
            });
            this.commit();
        }
        catch (Exception e) {
            LOG.error("Failed to remove vertices", (Throwable)e);
            throw new HugeException("Failed to remove vertices", e);
        }
        finally {
            this.autoCommit(autoCommit);
        }
    }

    public void removeEdges(EdgeLabel edgeLabel) {
        if (this.hasUpdates()) {
            throw new BackendException("There are still changes to commit");
        }
        boolean autoCommit = this.autoCommit();
        this.autoCommit(false);
        this.commit();
        try {
            if (this.store().features().supportsDeleteEdgeByLabel()) {
                this.doRemove(this.serializer.writeId(HugeType.EDGE_OUT, edgeLabel.id()));
                this.doRemove(this.serializer.writeId(HugeType.EDGE_IN, edgeLabel.id()));
            } else {
                this.traverseEdgesByLabel(edgeLabel, edge -> {
                    this.removeEdge((HugeEdge)edge);
                    this.commitIfGtSize(500);
                });
            }
            this.commit();
        }
        catch (Exception e) {
            LOG.error("Failed to remove edges", (Throwable)e);
            throw new HugeException("Failed to remove edges", e);
        }
        finally {
            this.autoCommit(autoCommit);
        }
    }

    public void traverseVerticesByLabel(VertexLabel label, Consumer<Vertex> consumer) {
        this.traverseByLabel(label, this::queryVertices, consumer);
    }

    public void traverseEdgesByLabel(EdgeLabel label, Consumer<Edge> consumer) {
        this.traverseByLabel(label, this::queryEdges, consumer);
    }

    private <T> void traverseByLabel(SchemaLabel label, Function<Query, Iterator<T>> fetcher, Consumer<T> consumer) {
        HugeType type = label.type() == HugeType.VERTEX_LABEL ? HugeType.VERTEX : HugeType.EDGE;
        ConditionQuery query = new ConditionQuery(type);
        if (label.hidden()) {
            query.showHidden(true);
        }
        if (!label.enableLabelIndex()) {
            query.capacity(-1L);
            Iterator<T> itor = fetcher.apply(query);
            while (itor.hasNext()) {
                T e = itor.next();
                SchemaLabel elemLabel = ((HugeElement)e).schemaLabel();
                if (!label.equals(elemLabel)) continue;
                consumer.accept(e);
            }
            return;
        }
        query.limit(800000L);
        query.capacity(800000L);
        query.eq(HugeKeys.LABEL, label.id());
        int pass = 0;
        int counter = 0;
        do {
            query.offset((long)pass++ * 800000L);
            Iterator<T> itor = fetcher.apply(query);
            counter = 0;
            while (itor.hasNext()) {
                consumer.accept(itor.next());
                ++counter;
            }
            assert ((long)counter <= 800000L);
        } while ((long)counter == 800000L);
    }
}

