/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.tx;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.store.BackendMutation;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.tx.AbstractTransaction;

public abstract class IndexableTransaction
extends AbstractTransaction {
    public IndexableTransaction(HugeGraph graph, BackendStore store) {
        super(graph, store);
    }

    @Override
    public boolean hasUpdates() {
        AbstractTransaction indexTx = this.indexTransaction();
        boolean indexTxChanged = indexTx != null && indexTx.hasUpdates();
        return indexTxChanged || super.hasUpdates();
    }

    @Override
    protected void reset() {
        super.reset();
        AbstractTransaction indexTx = this.indexTransaction();
        if (indexTx != null) {
            indexTx.reset();
        }
    }

    @Override
    protected void commit2Backend() {
        BackendMutation mutation = this.prepareCommit();
        BackendMutation txMutation = this.indexTransaction().prepareCommit();
        assert (!mutation.isEmpty() || !txMutation.isEmpty());
        this.commitMutation2Backend(mutation, txMutation);
    }

    @Override
    public void rollback() throws BackendException {
        try {
            super.rollback();
        }
        finally {
            this.indexTransaction().rollback();
        }
    }

    @Override
    public void close() {
        try {
            this.indexTransaction().close();
        }
        finally {
            super.close();
        }
    }

    protected abstract AbstractTransaction indexTransaction();
}

