/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.config;

import com.baidu.hugegraph.config.ConfigOption;
import com.baidu.hugegraph.config.OptionChecker;
import com.baidu.hugegraph.config.OptionHolder;

public class CoreOptions
extends OptionHolder {
    private static volatile CoreOptions instance;
    public static final ConfigOption<String> GREMLIN_GRAPH;
    public static final ConfigOption<String> BACKEND;
    public static final ConfigOption<String> STORE;
    public static final ConfigOption<String> STORE_SYSTEM;
    public static final ConfigOption<String> STORE_SCHEMA;
    public static final ConfigOption<String> STORE_GRAPH;
    public static final ConfigOption<String> SERIALIZER;
    public static final ConfigOption<Integer> RATE_LIMIT;
    public static final ConfigOption<Long> TASK_WAIT_TIMEOUT;
    public static final ConfigOption<String> VERTEX_DEFAULT_LABEL;
    public static final ConfigOption<Boolean> VERTEX_CHECK_CUSTOMIZED_ID_EXIST;
    public static final ConfigOption<Integer> VERTEX_TX_CAPACITY;
    public static final ConfigOption<Integer> EDGE_TX_CAPACITY;
    public static final ConfigOption<String> SCHEMA_ILLEGAL_NAME_REGEX;
    public static final ConfigOption<Integer> SCHEMA_CACHE_CAPACITY;
    public static final ConfigOption<Boolean> SCHEMA_SYNC_DELETION;
    public static final ConfigOption<Integer> VERTEX_CACHE_CAPACITY;
    public static final ConfigOption<Integer> VERTEX_CACHE_EXPIRE;
    public static final ConfigOption<Integer> EDGE_CACHE_CAPACITY;
    public static final ConfigOption<Integer> EDGE_CACHE_EXPIRE;
    public static final ConfigOption<Long> SNOWFLAKE_WORKER_ID;
    public static final ConfigOption<Long> SNOWFLAKE_DATACENTER_ID;
    public static final ConfigOption<Boolean> SNOWFLAKE_FORCE_STRING;
    public static final ConfigOption<String> TEXT_ANALYZER;
    public static final ConfigOption<String> TEXT_ANALYZER_MODE;

    private CoreOptions() {
    }

    public static synchronized CoreOptions instance() {
        if (instance == null) {
            instance = new CoreOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        GREMLIN_GRAPH = new ConfigOption("gremlin.graph", "Gremlin entrence to create graph.", OptionChecker.disallowEmpty(), (Object)"com.baidu.hugegraph.HugeFactory");
        BACKEND = new ConfigOption("backend", "The data store type.", OptionChecker.disallowEmpty(), (Object)"memory");
        STORE = new ConfigOption("store", "The database name like Cassandra Keyspace.", OptionChecker.disallowEmpty(), (Object)"hugegraph");
        STORE_SYSTEM = new ConfigOption("store.system", "The system table name, which store system data.", OptionChecker.disallowEmpty(), (Object)"system");
        STORE_SCHEMA = new ConfigOption("store.schema", "The schema table name, which store meta data.", OptionChecker.disallowEmpty(), (Object)"schema");
        STORE_GRAPH = new ConfigOption("store.graph", "The graph table name, which store vertex, edge and property.", OptionChecker.disallowEmpty(), (Object)"graph");
        SERIALIZER = new ConfigOption("serializer", "The serializer for backend store, like: text/binary/cassandra.", OptionChecker.disallowEmpty(), (Object)"text");
        RATE_LIMIT = new ConfigOption("rate_limit", "The max rate(items/s) to add/update/delete vertices/edges.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)0);
        TASK_WAIT_TIMEOUT = new ConfigOption("task.wait_timeout", "Timeout in seconds for waiting for the task to complete,such as when truncating or clearing the backend.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)10L);
        VERTEX_DEFAULT_LABEL = new ConfigOption("vertex.default_label", "The default vertex label.", OptionChecker.disallowEmpty(), (Object)"vertex");
        VERTEX_CHECK_CUSTOMIZED_ID_EXIST = new ConfigOption("vertex.check_customzied_id_exist", "Whether to check the vertices exist for those using customized id strategy", OptionChecker.disallowEmpty(), (Object)true);
        VERTEX_TX_CAPACITY = new ConfigOption("vertex.tx_capacity", "The max size(items) of vertices(uncommitted) in transaction.", OptionChecker.rangeInt((Number)1, (Number)1000000), (Object)10000);
        EDGE_TX_CAPACITY = new ConfigOption("edge.tx_capacity", "The max size(items) of edges(uncommitted) in transaction.", OptionChecker.rangeInt((Number)1, (Number)1000000), (Object)10000);
        SCHEMA_ILLEGAL_NAME_REGEX = new ConfigOption("schema.illegal_name_regex", "The regex specified the illegal format for schema name.", OptionChecker.disallowEmpty(), (Object)".*\\s+$|~.*");
        SCHEMA_CACHE_CAPACITY = new ConfigOption("schema.cache_capacity", "The max cache size(items) of schema cache.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)100000);
        SCHEMA_SYNC_DELETION = new ConfigOption("schema.sync_deletion", "Whether to delete schema synchronously.", OptionChecker.disallowEmpty(), (Object)false);
        VERTEX_CACHE_CAPACITY = new ConfigOption("vertex.cache_capacity", "The max cache size(items) of vertex cache.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)10000000);
        VERTEX_CACHE_EXPIRE = new ConfigOption("vertex.cache_expire", "The expire time in seconds of vertex cache.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)600);
        EDGE_CACHE_CAPACITY = new ConfigOption("edge.cache_capacity", "The max cache size(items) of edge cache.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)1000000);
        EDGE_CACHE_EXPIRE = new ConfigOption("edge.cache_expire", "The expire time in seconds of edge cache.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)600);
        SNOWFLAKE_WORKER_ID = new ConfigOption("snowflake.worker_id", "The worker id of snowflake id generator.", OptionChecker.disallowEmpty(), (Object)0L);
        SNOWFLAKE_DATACENTER_ID = new ConfigOption("snowflake.datecenter_id", "The datacenter id of snowflake id generator.", OptionChecker.disallowEmpty(), (Object)0L);
        SNOWFLAKE_FORCE_STRING = new ConfigOption("snowflake.force_string", "Whether to force the snowflake long id to be a string.", OptionChecker.disallowEmpty(), (Object)false);
        TEXT_ANALYZER = new ConfigOption("search.text_analyzer", "Choose a text analyzer for searching the vertex/edge properties, available type are [word, ansj, hanlp, smartcn, jieba, jcseg, mmseg4j, ikanalyzer]", OptionChecker.disallowEmpty(), (Object)"ikanalyzer");
        TEXT_ANALYZER_MODE = new ConfigOption("search.text_analyzer_mode", "Specify the mode for the text analyzer, the available mode of analyzer are {word: [MaximumMatching, ReverseMaximumMatching, MinimumMatching, ReverseMinimumMatching, BidirectionalMaximumMatching, BidirectionalMinimumMatching, BidirectionalMaximumMinimumMatching, FullSegmentation, MinimalWordCount, MaxNgramScore, PureEnglish], ansj: [BaseAnalysis, IndexAnalysis, ToAnalysis, NlpAnalysis], hanlp: [standard, nlp, index, nShort, shortest, speed], smartcn: [], jieba: [SEARCH, INDEX], jcseg: [Simple, Complex], mmseg4j: [Simple, Complex, MaxWord], ikanalyzer: [smart, max_word]}", OptionChecker.disallowEmpty(), (Object)"smart");
    }
}

