/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.io;

import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.store.Shard;
import com.baidu.hugegraph.date.SafeDateFormat;
import com.baidu.hugegraph.io.GraphSONSchemaSerializer;
import com.baidu.hugegraph.io.HugeGraphIoRegistry;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.type.define.HugeKeys;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TinkerPopJacksonModule;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.DateSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.UUIDSerializer;

public class HugeGraphSONModule
extends TinkerPopJacksonModule {
    private static final long serialVersionUID = 6480426922914059122L;
    private static final String TYPE_NAMESPACE = "hugegraph";
    private static final Map<Class, String> TYPE_DEFINITIONS;
    private static final GraphSONSchemaSerializer schemaSerializer;
    private static final String DF = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final SafeDateFormat DATE_FORMAT;

    public static void register(HugeGraphIoRegistry io) {
        io.register(GraphSONIo.class, null, (Object)new HugeGraphSONModule());
    }

    private HugeGraphSONModule() {
        super(TYPE_NAMESPACE);
        this.addSerializer(Optional.class, (JsonSerializer)new OptionalSerializer());
        this.addSerializer(Date.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(false), (DateFormat)DATE_FORMAT));
        this.addSerializer(UUID.class, (JsonSerializer)new UUIDSerializer());
        this.addSerializer(IdGenerator.StringId.class, (JsonSerializer)new IdSerializer<IdGenerator.StringId>(IdGenerator.StringId.class));
        this.addDeserializer(IdGenerator.StringId.class, (JsonDeserializer)new IdDeserializer<IdGenerator.StringId>(IdGenerator.StringId.class));
        this.addSerializer(IdGenerator.LongId.class, (JsonSerializer)new IdSerializer<IdGenerator.LongId>(IdGenerator.LongId.class));
        this.addDeserializer(IdGenerator.LongId.class, (JsonDeserializer)new IdDeserializer<IdGenerator.LongId>(IdGenerator.LongId.class));
        this.addSerializer(EdgeId.class, (JsonSerializer)new IdSerializer<EdgeId>(EdgeId.class));
        this.addDeserializer(EdgeId.class, (JsonDeserializer)new IdDeserializer<EdgeId>(EdgeId.class));
        this.addSerializer(PropertyKey.class, (JsonSerializer)new PropertyKeySerializer());
        this.addSerializer(VertexLabel.class, (JsonSerializer)new VertexLabelSerializer());
        this.addSerializer(EdgeLabel.class, (JsonSerializer)new EdgeLabelSerializer());
        this.addSerializer(IndexLabel.class, (JsonSerializer)new IndexLabelSerializer());
        this.addSerializer(Shard.class, (JsonSerializer)new ShardSerializer());
    }

    public Map<Class, String> getTypeDefinitions() {
        return TYPE_DEFINITIONS;
    }

    public String getTypeNamespace() {
        return TYPE_NAMESPACE;
    }

    private static void writeEntry(JsonGenerator jsonGenerator, Map<HugeKeys, Object> schema) throws IOException {
        jsonGenerator.writeStartObject();
        for (Map.Entry<HugeKeys, Object> entry : schema.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey().string());
            jsonGenerator.writeObject(entry.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    static {
        schemaSerializer = new GraphSONSchemaSerializer();
        DATE_FORMAT = new SafeDateFormat(DF);
        TYPE_DEFINITIONS = new ConcurrentHashMap<Class, String>();
        TYPE_DEFINITIONS.put(Optional.class, "Optional");
        TYPE_DEFINITIONS.put(Date.class, "Date");
        TYPE_DEFINITIONS.put(UUID.class, "UUID");
        TYPE_DEFINITIONS.put(IdGenerator.StringId.class, "StringId");
        TYPE_DEFINITIONS.put(IdGenerator.LongId.class, "LongId");
        TYPE_DEFINITIONS.put(EdgeId.class, "EdgeId");
        TYPE_DEFINITIONS.put(PropertyKey.class, "PropertyKey");
        TYPE_DEFINITIONS.put(VertexLabel.class, "VertexLabel");
        TYPE_DEFINITIONS.put(EdgeLabel.class, "EdgeLabel");
        TYPE_DEFINITIONS.put(IndexLabel.class, "IndexLabel");
        TYPE_DEFINITIONS.put(Shard.class, "Shard");
    }

    private static class ShardSerializer
    extends StdSerializer<Shard> {
        public ShardSerializer() {
            super(Shard.class);
        }

        public void serialize(Shard shard, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("start", shard.start());
            jsonGenerator.writeStringField("end", shard.end());
            jsonGenerator.writeNumberField("length", shard.length());
            jsonGenerator.writeEndObject();
        }
    }

    private static class IndexLabelSerializer
    extends StdSerializer<IndexLabel> {
        public IndexLabelSerializer() {
            super(IndexLabel.class);
        }

        public void serialize(IndexLabel il, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, schemaSerializer.writeIndexLabel(il));
        }
    }

    private static class EdgeLabelSerializer
    extends StdSerializer<EdgeLabel> {
        public EdgeLabelSerializer() {
            super(EdgeLabel.class);
        }

        public void serialize(EdgeLabel el, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, schemaSerializer.writeEdgeLabel(el));
        }
    }

    private static class VertexLabelSerializer
    extends StdSerializer<VertexLabel> {
        public VertexLabelSerializer() {
            super(VertexLabel.class);
        }

        public void serialize(VertexLabel vl, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, schemaSerializer.writeVertexLabel(vl));
        }
    }

    private static class PropertyKeySerializer
    extends StdSerializer<PropertyKey> {
        public PropertyKeySerializer() {
            super(PropertyKey.class);
        }

        public void serialize(PropertyKey pk, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, schemaSerializer.writePropertyKey(pk));
        }
    }

    private static class IdDeserializer<T extends Id>
    extends StdDeserializer<T> {
        public IdDeserializer(Class<T> clazz) {
            super(clazz);
        }

        public T deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            Class clazz = this.handledType();
            if (clazz.equals(IdGenerator.LongId.class)) {
                Number idValue = (Number)ctxt.readValue(jsonParser, Number.class);
                return (T)IdGenerator.of(idValue.longValue());
            }
            if (clazz.equals(IdGenerator.StringId.class)) {
                String idValue = (String)ctxt.readValue(jsonParser, String.class);
                return (T)IdGenerator.of(idValue);
            }
            assert (clazz.equals(EdgeId.class));
            String idValue = (String)ctxt.readValue(jsonParser, String.class);
            return (T)EdgeId.parse(idValue);
        }
    }

    private static class IdSerializer<T extends Id>
    extends StdSerializer<T> {
        public IdSerializer(Class<T> clazz) {
            super(clazz);
        }

        public void serialize(T value, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            if (value.number()) {
                jsonGenerator.writeNumber(value.asLong());
            } else {
                jsonGenerator.writeString(value.asString());
            }
        }

        public void serializeWithType(T value, JsonGenerator jsonGenerator, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            typeSer.writeTypePrefixForScalar(value, jsonGenerator);
            this.serialize(value, jsonGenerator, serializers);
            typeSer.writeTypeSuffixForScalar(value, jsonGenerator);
        }
    }

    private static class OptionalSerializer
    extends StdSerializer<Optional> {
        public OptionalSerializer() {
            super(Optional.class);
        }

        public void serialize(Optional optional, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            if (optional.isPresent()) {
                jsonGenerator.writeObject(optional.get());
            } else {
                jsonGenerator.writeObject(null);
            }
        }
    }
}

