/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.io;

import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.io.GraphSONSchemaSerializer;
import com.baidu.hugegraph.io.HugeGraphIoRegistry;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.StringEncoding;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

public class HugeGryoModule {
    private static GraphSONSchemaSerializer schemaSerializer = new GraphSONSchemaSerializer();

    public static void register(HugeGraphIoRegistry io) {
        io.register(GryoIo.class, Optional.class, (Object)new OptionalSerializer());
        io.register(GryoIo.class, IdGenerator.StringId.class, (Object)new IdSerializer());
        io.register(GryoIo.class, IdGenerator.LongId.class, (Object)new IdSerializer());
        io.register(GryoIo.class, EdgeId.class, (Object)new EdgeIdSerializer());
        io.register(GryoIo.class, PropertyKey.class, (Object)new PropertyKeyKryoSerializer());
        io.register(GryoIo.class, VertexLabel.class, (Object)new VertexLabelKryoSerializer());
        io.register(GryoIo.class, EdgeLabel.class, (Object)new EdgeLabelKryoSerializer());
        io.register(GryoIo.class, IndexLabel.class, (Object)new IndexLabelKryoSerializer());
    }

    private static void writeEntry(Kryo kryo, Output output, Map<HugeKeys, Object> schema) {
        output.writeInt(schema.keySet().size());
        for (Map.Entry<HugeKeys, Object> entry : schema.entrySet()) {
            kryo.writeObject(output, (Object)entry.getKey());
            kryo.writeClassAndObject(output, entry.getValue());
        }
    }

    private static Map<HugeKeys, Object> readEntry(Kryo kryo, Input input) {
        int columnSize = input.readInt();
        LinkedHashMap<HugeKeys, Object> map = new LinkedHashMap<HugeKeys, Object>();
        for (int i = 0; i < columnSize; ++i) {
            HugeKeys key = (HugeKeys)((Object)kryo.readObject(input, HugeKeys.class));
            Object val = kryo.readClassAndObject(input);
            map.put(key, val);
        }
        return map;
    }

    static class IndexLabelKryoSerializer
    extends Serializer<IndexLabel> {
        IndexLabelKryoSerializer() {
        }

        public void write(Kryo kryo, Output output, IndexLabel il) {
            HugeGryoModule.writeEntry(kryo, output, schemaSerializer.writeIndexLabel(il));
        }

        public IndexLabel read(Kryo kryo, Input input, Class<IndexLabel> c) {
            return null;
        }
    }

    static class EdgeLabelKryoSerializer
    extends Serializer<EdgeLabel> {
        EdgeLabelKryoSerializer() {
        }

        public void write(Kryo kryo, Output output, EdgeLabel el) {
            HugeGryoModule.writeEntry(kryo, output, schemaSerializer.writeEdgeLabel(el));
        }

        public EdgeLabel read(Kryo kryo, Input input, Class<EdgeLabel> clazz) {
            return null;
        }
    }

    static class VertexLabelKryoSerializer
    extends Serializer<VertexLabel> {
        VertexLabelKryoSerializer() {
        }

        public void write(Kryo kryo, Output output, VertexLabel vl) {
            HugeGryoModule.writeEntry(kryo, output, schemaSerializer.writeVertexLabel(vl));
        }

        public VertexLabel read(Kryo kryo, Input input, Class<VertexLabel> c) {
            return null;
        }
    }

    static class PropertyKeyKryoSerializer
    extends Serializer<PropertyKey> {
        PropertyKeyKryoSerializer() {
        }

        public void write(Kryo kryo, Output output, PropertyKey pk) {
            HugeGryoModule.writeEntry(kryo, output, schemaSerializer.writePropertyKey(pk));
        }

        public PropertyKey read(Kryo kryo, Input input, Class<PropertyKey> c) {
            return null;
        }
    }

    static class EdgeIdSerializer
    extends Serializer<EdgeId> {
        EdgeIdSerializer() {
        }

        public void write(Kryo kryo, Output output, EdgeId edgeId) {
            byte[] idBytes = edgeId.asBytes();
            output.write(idBytes.length);
            output.writeBytes(edgeId.asBytes());
        }

        public EdgeId read(Kryo kryo, Input input, Class<EdgeId> clazz) {
            int length = input.read();
            byte[] idBytes = input.readBytes(length);
            return EdgeId.parse(StringEncoding.decode(idBytes));
        }
    }

    static class IdSerializer
    extends Serializer<Id> {
        IdSerializer() {
        }

        public void write(Kryo kryo, Output output, Id id) {
            output.writeBoolean(id.number());
            byte[] idBytes = id.asBytes();
            output.write(idBytes.length);
            output.writeBytes(id.asBytes());
        }

        public Id read(Kryo kryo, Input input, Class<Id> clazz) {
            boolean number = input.readBoolean();
            int length = input.read();
            byte[] idBytes = input.readBytes(length);
            return IdGenerator.of(idBytes, number);
        }
    }

    static class OptionalSerializer
    extends Serializer<Optional<?>> {
        OptionalSerializer() {
        }

        public void write(Kryo kryo, Output output, Optional<?> optional) {
            if (optional.isPresent()) {
                kryo.writeClassAndObject(output, optional.get());
            } else {
                kryo.writeObject(output, null);
            }
        }

        public Optional<?> read(Kryo kryo, Input input, Class<Optional<?>> c) {
            Object value = kryo.readClassAndObject(input);
            return value == null ? Optional.empty() : Optional.of(value);
        }
    }
}

