/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.job;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.job.Job;
import com.baidu.hugegraph.task.HugeTask;
import com.baidu.hugegraph.task.TaskScheduler;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.E;
import java.util.Set;

public class JobBuilder<T> {
    private final HugeGraph graph;
    private String name;
    private String input;
    private Job<T> job;
    private Set<Id> dependencies;

    public static <T> JobBuilder<T> of(HugeGraph graph) {
        return new JobBuilder<T>(graph);
    }

    public JobBuilder(HugeGraph graph) {
        this.graph = graph;
    }

    public JobBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public JobBuilder<T> input(String input) {
        this.input = input;
        return this;
    }

    public JobBuilder<T> job(Job<T> job) {
        this.job = job;
        return this;
    }

    public JobBuilder<T> dependencies(Set<Id> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public HugeTask<T> schedule() {
        E.checkArgumentNotNull((Object)this.name, (String)"Job name can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull(this.job, (String)"Job can't be null", (Object[])new Object[0]);
        HugeTask<T> task = new HugeTask<T>(this.genTaskId(), null, this.job);
        task.type(this.job.type());
        task.name(this.name);
        if (this.input != null) {
            task.input(this.input);
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            for (Id depend : this.dependencies) {
                task.depends(depend);
            }
        }
        TaskScheduler scheduler = this.graph.taskScheduler();
        scheduler.schedule(task);
        scheduler.save(task);
        return task;
    }

    private Id genTaskId() {
        return this.graph.schemaTransaction().store().nextId(HugeType.TASK);
    }
}

