/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.job.schema;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.job.schema.SchemaCallable;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.SchemaStatus;
import com.baidu.hugegraph.util.LockUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class RebuildIndexCallable
extends SchemaCallable {
    @Override
    public String type() {
        return "rebuild_index";
    }

    @Override
    public Object execute() {
        this.rebuildIndex(this.schemaElement());
        return null;
    }

    private void rebuildIndex(SchemaElement schema) {
        switch (schema.type()) {
            case INDEX_LABEL: {
                SchemaLabel label;
                IndexLabel indexLabel = (IndexLabel)schema;
                if (indexLabel.baseType() == HugeType.VERTEX_LABEL) {
                    label = this.graph().vertexLabel(indexLabel.baseValue());
                } else {
                    assert (indexLabel.baseType() == HugeType.EDGE_LABEL);
                    label = this.graph().edgeLabel(indexLabel.baseValue());
                }
                this.rebuildIndex(label, (Collection<Id>)ImmutableSet.of((Object)indexLabel.id()));
                break;
            }
            case VERTEX_LABEL: 
            case EDGE_LABEL: {
                SchemaLabel label = (SchemaLabel)schema;
                this.rebuildIndex(label, label.indexLabels());
                break;
            }
            default: {
                assert (schema.type() == HugeType.PROPERTY_KEY);
                throw new AssertionError((Object)String.format("The %s can't rebuild index", schema.type()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndex(SchemaLabel label, Collection<Id> indexLabelIds) {
        SchemaTransaction schemaTx = this.graph().schemaTransaction();
        GraphTransaction graphTx = this.graph().graphTransaction();
        Consumer<Object> indexUpdater = elem -> {
            for (Id id : indexLabelIds) {
                graphTx.updateIndex(id, (HugeElement)elem);
                graphTx.commitIfGtSize(500);
            }
        };
        LockUtil.Locks locks = new LockUtil.Locks(this.graph().name());
        try {
            Consumer<Object> consumer;
            locks.lockWrites("il_rebuild", indexLabelIds);
            locks.lockWrites("il_delete", indexLabelIds);
            Set ils = indexLabelIds.stream().map(schemaTx::getIndexLabel).collect(Collectors.toSet());
            for (IndexLabel il : ils) {
                if (il.status() == SchemaStatus.CREATING) continue;
                schemaTx.updateSchemaStatus(il, SchemaStatus.REBUILDING);
            }
            this.removeIndex(indexLabelIds);
            graphTx.commit();
            if (label.type() == HugeType.VERTEX_LABEL) {
                consumer = indexUpdater;
                graphTx.traverseVerticesByLabel((VertexLabel)label, consumer);
            } else {
                assert (label.type() == HugeType.EDGE_LABEL);
                consumer = indexUpdater;
                graphTx.traverseEdgesByLabel((EdgeLabel)label, consumer);
            }
            graphTx.commit();
            for (IndexLabel il : ils) {
                schemaTx.updateSchemaStatus(il, SchemaStatus.CREATED);
            }
        }
        finally {
            locks.unlock();
        }
    }

    private void removeIndex(Collection<Id> indexLabelIds) {
        SchemaTransaction schemaTx = this.graph().schemaTransaction();
        GraphTransaction graphTx = this.graph().graphTransaction();
        for (Id id : indexLabelIds) {
            IndexLabel indexLabel = schemaTx.getIndexLabel(id);
            if (indexLabel == null) continue;
            graphTx.removeIndex(indexLabel);
        }
    }

    private SchemaElement schemaElement() {
        HugeType type = this.schemaType();
        Id id = this.schemaId();
        SchemaTransaction schemaTx = this.graph().schemaTransaction();
        switch (type) {
            case VERTEX_LABEL: {
                return schemaTx.getVertexLabel(id);
            }
            case EDGE_LABEL: {
                return schemaTx.getEdgeLabel(id);
            }
            case INDEX_LABEL: {
                return schemaTx.getIndexLabel(id);
            }
        }
        throw new AssertionError((Object)String.format("Invalid HugeType '%s' for rebuild", type));
    }
}

