/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.job.schema;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.job.schema.IndexLabelRemoveCallable;
import com.baidu.hugegraph.job.schema.SchemaCallable;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.type.define.SchemaStatus;
import com.baidu.hugegraph.util.LockUtil;
import com.google.common.collect.ImmutableSet;
import java.util.List;

public class VertexLabelRemoveCallable
extends SchemaCallable {
    @Override
    public String type() {
        return "remove_schema";
    }

    @Override
    public Object execute() {
        VertexLabelRemoveCallable.removeVertexLabel(this.graph(), this.schemaId());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeVertexLabel(HugeGraph graph, Id id) {
        GraphTransaction graphTx = graph.graphTransaction();
        SchemaTransaction schemaTx = graph.schemaTransaction();
        VertexLabel vertexLabel = schemaTx.getVertexLabel(id);
        if (vertexLabel == null) {
            return;
        }
        List<EdgeLabel> edgeLabels = schemaTx.getEdgeLabels();
        for (EdgeLabel edgeLabel : edgeLabels) {
            if (!edgeLabel.linkWithLabel(id)) continue;
            throw new HugeException("Not allowed to remove vertex label '%s' because the edge label '%s' still link with it", vertexLabel.name(), edgeLabel.name());
        }
        ImmutableSet indexLabelIds = ImmutableSet.copyOf(vertexLabel.indexLabels());
        LockUtil.Locks locks = new LockUtil.Locks(graph.name());
        try {
            locks.lockWrites("vl_delete", id);
            schemaTx.updateSchemaStatus(vertexLabel, SchemaStatus.DELETING);
            for (Id indexLabelId : indexLabelIds) {
                IndexLabelRemoveCallable.removeIndexLabel(graph, indexLabelId);
            }
            graphTx.removeVertices(vertexLabel);
            VertexLabelRemoveCallable.removeSchema(schemaTx, vertexLabel);
            graph.tx().commit();
        }
        finally {
            locks.unlock();
        }
    }
}

